/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.events.OnPlayerInteracted;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.level.BlockHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.platform.Side;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@AutoInstance
public class HarvesterEnchantment
extends Handler {
    float growChance = 0.04f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.UNCOMMON).category(MajruszsEnchantments.IS_HOE).slots((List)EquipmentSlots.HANDS).maxLevel(3).minLevelCost(level -> level * 10).maxLevelCost(level -> level * 10 + 15);
    }

    public HarvesterEnchantment() {
        super(MajruszsEnchantments.HARVESTER, HarvesterEnchantment.class, false);
        OnPlayerInteracted.listen(this::apply).addCondition(data -> data.blockResult != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)data.itemStack)).addCondition(data -> BlockHelper.isCropAtMaxAge((Level)data.getLevel(), (BlockPos)data.blockResult.m_82425_()));
    }

    private void apply(OnPlayerInteracted data) {
        this.collectCrop(data);
        if (Side.isLogicalServer()) {
            this.spawnItems(data, this.tryToReplant(data));
            this.tickNearbyCrops(data);
            this.damageHoe(data);
        }
        data.finish();
    }

    private void collectCrop(OnPlayerInteracted data) {
        BlockPos blockPos = data.blockResult.m_82425_();
        BlockState blockState = data.getLevel().m_8055_(blockPos);
        blockState.m_60734_().m_5707_(data.getLevel(), blockPos, blockState, data.player);
    }

    private void spawnItems(OnPlayerInteracted data, List<ItemStack> itemStacks) {
        itemStacks.forEach(itemStack -> Block.m_49840_((Level)data.getLevel(), (BlockPos)data.blockResult.m_82425_(), (ItemStack)itemStack));
    }

    private List<ItemStack> tryToReplant(OnPlayerInteracted data) {
        Level level = data.getLevel();
        BlockPos blockPos = data.blockResult.m_82425_();
        BlockState blockState = level.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        Item seed = block.m_7397_((BlockGetter)level, blockPos, blockState).m_41720_();
        List itemStacks = blockState.m_287290_(new LootParams.Builder(data.getServerLevel()).m_287286_(LootContextParams.f_81460_, (Object)AnyPos.from((BlockPos)blockPos).center().vec3()).m_287286_(LootContextParams.f_81463_, (Object)data.itemStack).m_287286_(LootContextParams.f_81461_, (Object)blockState).m_287286_(LootContextParams.f_81455_, (Object)data.player));
        for (ItemStack itemStack : itemStacks) {
            if (!itemStack.m_150930_(seed)) continue;
            itemStack.m_41764_(itemStack.m_41613_() - 1);
            level.m_46597_(blockPos, block.m_49966_());
            return itemStacks;
        }
        for (Slot slot : data.player.f_36095_.f_38839_) {
            ItemStack itemStack = slot.m_7993_();
            if (!itemStack.m_150930_(seed)) continue;
            itemStack.m_41764_(itemStack.m_41613_() - 1);
            level.m_46597_(blockPos, block.m_49966_());
            return itemStacks;
        }
        level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
        return itemStacks;
    }

    private void tickNearbyCrops(OnPlayerInteracted data) {
        BlockPos blockPos = data.blockResult.m_82425_();
        int range = EnchantmentHelper.getLevel((Supplier)this.enchantment, (ItemStack)data.itemStack);
        for (int z = -range; z <= range; ++z) {
            for (int x = -range; x <= range; ++x) {
                if (x == 0 && z == 0) continue;
                BlockPos neighbourPosition = blockPos.m_7918_(x, 0, z);
                BlockState blockState = data.getLevel().m_8055_(blockPos.m_7918_(x, 0, z));
                Block block = blockState.m_60734_();
                if (!(block instanceof CropBlock) && !(block instanceof NetherWartBlock)) continue;
                int particlesCount = 1;
                if (Random.check((float)this.growChance)) {
                    BlockHelper.growCrop((Level)data.getLevel(), (BlockPos)neighbourPosition);
                    particlesCount = 3;
                }
                ParticleEmitter.of((ParticleOptions)ParticleTypes.f_123748_).position(AnyPos.from((BlockPos)blockPos).center().vec3()).count(particlesCount).emit((Level)data.getServerLevel());
            }
        }
    }

    private void damageHoe(OnPlayerInteracted data) {
        ItemHelper.damage((LivingEntity)data.player, (InteractionHand)data.hand, (int)1);
    }
}

