/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnExploded;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoInstance
public class FuseCutterEnchantment
extends Handler {
    float maxDistance = 6.0f;
    float cooldownRatio = 1.5f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.UNCOMMON).category(MajruszsEnchantments.IS_SHIELD).slots((List)EquipmentSlots.HANDS).minLevelCost(level -> 8).maxLevelCost(level -> 40);
    }

    public FuseCutterEnchantment() {
        super(MajruszsEnchantments.FUSE_CUTTER, FuseCutterEnchantment.class, false);
        OnExploded.listen(this::cancel).addCondition(Condition.isLogicalServer()).addCondition(this::isAnyoneBlockingNearby);
        this.config.define("max_distance", Reader.number(), s -> Float.valueOf(this.maxDistance), (s, v) -> {
            this.maxDistance = ((Float)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(64.0f)).clamp((Number)v)).floatValue();
        }).define("shield_cooldown_ratio", Reader.number(), s -> Float.valueOf(this.cooldownRatio), (s, v) -> {
            this.cooldownRatio = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        });
    }

    private void cancel(OnExploded data) {
        Vec3 position = AnyPos.from((Vec3)data.position).add((Number)0.0, (Number)0.5, (Number)0.0).vec3();
        data.cancelExplosion();
        ParticleEmitter.of((ParticleOptions)ParticleTypes.f_123762_).offset(ParticleEmitter.offset((float)(0.125f * data.radius))).speed(0.025f).count(Random.round((double)(12.0f * data.radius))).position(position).emit((Level)data.getServerLevel());
        ParticleEmitter.of((ParticleOptions)ParticleTypes.f_123755_).offset(ParticleEmitter.offset((float)(0.125f * data.radius))).speed(0.025f).count(Random.round((double)(8.0f * data.radius))).position(position).emit((Level)data.getServerLevel());
        SoundEmitter.of((SoundEvent)SoundEvents.f_11937_).position(position).emit((Level)data.getServerLevel());
    }

    private boolean isAnyoneBlockingNearby(OnExploded data) {
        AABB aabb = AABB.m_82333_((Vec3)data.position).m_82400_((double)this.maxDistance);
        for (LivingEntity entity : data.getLevel().m_45976_(LivingEntity.class, aabb)) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            if (!entity.m_21254_() || !EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)ItemHelper.getCurrentlyUsedItem((LivingEntity)entity))) continue;
            EntityHelper.disableCurrentItem((Player)player, (double)(data.radius * this.cooldownRatio));
            return true;
        }
        return false;
    }
}

