/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.collection.DefaultMap;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnFishingExtraItemsGet;
import com.majruszlibrary.events.OnItemEquipped;
import com.majruszlibrary.events.OnItemFished;
import com.majruszlibrary.events.base.Priority;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.text.TextHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;

@AutoInstance
public class FishingFanaticEnchantment
extends Handler {
    final AttributeHandler attackSpeed;
    ResourceLocation specialDropId = MajruszsEnchantments.HELPER.getLocation("gameplay/fishing/fishing_fanatic_extra");
    Map<String, Float> levelUpChance = DefaultMap.of((DefaultMap.Entry[])new DefaultMap.Entry[]{DefaultMap.defaultEntry((Object)Float.valueOf(0.06f)), DefaultMap.entry((String)"level_2", (Object)Float.valueOf(0.05f)), DefaultMap.entry((String)"level_3", (Object)Float.valueOf(0.04f)), DefaultMap.entry((String)"level_4", (Object)Float.valueOf(0.03f)), DefaultMap.entry((String)"level_5", (Object)Float.valueOf(0.02f)), DefaultMap.entry((String)"level_6", (Object)Float.valueOf(0.01f)), DefaultMap.entry((String)"level_7", (Object)Float.valueOf(0.004f)), DefaultMap.entry((String)"level_8", (Object)Float.valueOf(0.002f))});
    Map<String, Float> specialDropChance = DefaultMap.of((DefaultMap.Entry[])new DefaultMap.Entry[]{DefaultMap.defaultEntry((Object)Float.valueOf(0.0f)), DefaultMap.entry((String)"level_4", (Object)Float.valueOf(0.0025f)), DefaultMap.entry((String)"level_5", (Object)Float.valueOf(0.0075f)), DefaultMap.entry((String)"level_6", (Object)Float.valueOf(0.02f)), DefaultMap.entry((String)"level_7", (Object)Float.valueOf(0.04f)), DefaultMap.entry((String)"level_8", (Object)Float.valueOf(0.06f))});
    float extraLootChance = 0.33333f;
    float rainMultiplier = 2.0f;
    float damageBonus = 1.0f;
    float attackSpeedMultiplier = 0.82f;

    public static CustomEnchantment create() {
        return new CustomEnchantment(){

            public Component m_44700_(int level) {
                if (level == this.m_6586_()) {
                    return TextHelper.translatable((String)"enchantment.majruszsenchantments.fishing_fanatic.true", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY);
                }
                return super.m_44700_(level);
            }

            public boolean m_6594_() {
                return false;
            }

            public boolean m_6591_() {
                return true;
            }
        }.rarity(Enchantment.Rarity.UNCOMMON).category(EnchantmentCategory.FISHING_ROD).slots((List)EquipmentSlots.HANDS).maxLevel(8).minLevelCost(level -> level * 10).maxLevelCost(level -> level * 10 + 20);
    }

    public FishingFanaticEnchantment() {
        super(MajruszsEnchantments.FISHING_FANATIC, FishingFanaticEnchantment.class, false);
        this.attackSpeed = new AttributeHandler("%s_attack_speed".formatted(this.enchantment.getId()), () -> Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        OnFishingExtraItemsGet.listen(this::increaseLoot).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.player));
        OnEntityPreDamaged.listen(this::increaseDamage).addCondition(OnEntityPreDamaged::willTakeFullDamage).addCondition(data -> data.attacker != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.attacker));
        OnItemEquipped.listen(this::reduceAttackSpeed);
        OnItemFished.listen(this::tryToLevelUp).priority(Priority.LOW);
        this.config.define("extra_loot_chance", Reader.number(), s -> Float.valueOf(this.extraLootChance), (s, v) -> {
            this.extraLootChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("level_up_chance", Reader.map((IReader)Reader.number()), s -> this.levelUpChance, (s, v) -> {
            this.levelUpChance = Range.CHANCE.clamp((Map)DefaultMap.of((Map)v));
        }).define("level_up_chance_rain_multiplier", Reader.number(), s -> Float.valueOf(this.rainMultiplier), (s, v) -> {
            this.rainMultiplier = ((Float)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        }).define("special_drop_chance", Reader.map((IReader)Reader.number()), s -> this.specialDropChance, (s, v) -> {
            this.specialDropChance = Range.CHANCE.clamp((Map)DefaultMap.of((Map)v));
        }).define("special_drop_id", Reader.location(), s -> this.specialDropId, (s, v) -> {
            this.specialDropId = v;
        }).define("damage_bonus_per_level", Reader.number(), s -> Float.valueOf(this.damageBonus), (s, v) -> {
            this.damageBonus = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        }).define("attack_speed_multiplier_per_level", Reader.number(), s -> Float.valueOf(this.attackSpeedMultiplier), (s, v) -> {
            this.attackSpeedMultiplier = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        });
    }

    private void increaseLoot(OnFishingExtraItemsGet data) {
        ItemStack fishingRod = data.fishingRod;
        int level = EnchantmentHelper.getLevel((Supplier)this.enchantment, (ItemStack)fishingRod);
        List<ItemStack> loot = this.spawnExtraLoot(data, level);
        if (!loot.isEmpty()) {
            data.extraExperience += loot.size() + Random.nextInt((int)(2 * loot.size())) + 1;
            data.extraItems.addAll(loot);
        }
    }

    private List<ItemStack> spawnExtraLoot(OnFishingExtraItemsGet data, int level) {
        LootParams lootParams = LootHelper.toGiftParams((Entity)data.player);
        LootTable standard = LootHelper.getLootTable((ResourceLocation)BuiltInLootTables.f_78720_);
        LootTable special = LootHelper.getLootTable((ResourceLocation)this.specialDropId);
        ArrayList<ItemStack> extraLoot = new ArrayList<ItemStack>();
        for (int idx = 0; idx < level; ++idx) {
            if (!Random.check((float)this.extraLootChance)) continue;
            LootTable lootTable = Random.check((float)this.specialDropChance.get("level_%d".formatted(level)).floatValue()) ? special : standard;
            extraLoot.addAll((Collection<ItemStack>)lootTable.m_287195_(lootParams));
        }
        return extraLoot;
    }

    private void tryToLevelUp(OnItemFished data) {
        ItemStack fishingRod;
        int level;
        float chanceMultiplier;
        boolean isRaining = data.getLevel().m_46471_();
        float f = chanceMultiplier = isRaining ? this.rainMultiplier : 1.0f;
        if (!this.isEnabled) {
            chanceMultiplier = 0.0f;
        }
        if ((level = EnchantmentHelper.getLevel((Supplier)this.enchantment, (ItemStack)(fishingRod = ItemHelper.getHandItem((LivingEntity)data.player, itemStack -> itemStack.m_41720_() instanceof FishingRodItem)))) == ((CustomEnchantment)this.enchantment.get()).m_6586_() || !Random.check((float)(this.levelUpChance.get("level_%d".formatted(level)).floatValue() * chanceMultiplier))) {
            return;
        }
        EnchantmentHelper.increaseLevel((Supplier)this.enchantment, (ItemStack)fishingRod);
        ++level;
        Player player = data.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (level == 1) {
                MajruszsEnchantments.HELPER.triggerAchievement(player2, "fishing_fanatic");
            }
            if (level == ((CustomEnchantment)this.enchantment.get()).m_6586_()) {
                MajruszsEnchantments.HELPER.triggerAchievement(player2, "fishing_fanatic_true");
            }
            if (isRaining) {
                MajruszsEnchantments.HELPER.triggerAchievement(player2, "fishing_fanatic_rain");
            }
        }
        data.player.m_5661_((Component)TextHelper.translatable((String)"enchantment.majruszsenchantments.fishing_fanatic.level_up", (Object[])new Object[0]).m_130940_(ChatFormatting.BOLD), true);
    }

    private void increaseDamage(OnEntityPreDamaged data) {
        data.damage += (float)EnchantmentHelper.getLevel((Supplier)this.enchantment, (LivingEntity)data.attacker) * this.damageBonus;
        data.spawnMagicParticles = true;
        ItemHelper.damage((LivingEntity)data.attacker, (EquipmentSlot)EquipmentSlot.MAINHAND, (int)1);
    }

    private void reduceAttackSpeed(OnItemEquipped data) {
        float multiplier = (float)Math.pow(this.attackSpeedMultiplier, EnchantmentHelper.getLevel((Supplier)this.enchantment, (LivingEntity)data.entity));
        this.attackSpeed.setValue((double)(multiplier - 1.0f)).apply(data.entity);
    }
}

