/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.curses;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnItemDamaged;
import com.majruszlibrary.events.base.Priority;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

@AutoInstance
public class BreakingCurse
extends Handler {
    float damageMultiplier = 1.0f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.RARE).category(EnchantmentCategory.BREAKABLE).slots((List)EquipmentSlots.ALL).curse().maxLevel(3).minLevelCost(level -> 10).maxLevelCost(level -> 50).compatibility(enchantment -> !(enchantment instanceof DigDurabilityEnchantment));
    }

    public BreakingCurse() {
        super(MajruszsEnchantments.BREAKING, BreakingCurse.class, true);
        OnItemDamaged.listen(this::dealExtraDamage).priority(Priority.HIGH).addCondition(data -> data.player != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.player));
        this.config.define("damage_multiplier_per_level", Reader.number(), s -> Float.valueOf(this.damageMultiplier), (s, v) -> {
            this.damageMultiplier = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        });
    }

    private void dealExtraDamage(OnItemDamaged data) {
        data.damage += Random.round((double)((float)(data.damage * EnchantmentHelper.getLevel((Supplier)this.enchantment, (ItemStack)data.itemStack)) * this.damageMultiplier));
    }
}

