/*
 * Decompiled with CFR 0.152.
 */
package li.cil.bedrockores.common.world;

import com.mojang.serialization.Codec;
import li.cil.bedrockores.common.block.BedrockOreBlock;
import li.cil.bedrockores.common.block.Blocks;
import li.cil.bedrockores.common.block.entity.BedrockOreBlockEntity;
import li.cil.bedrockores.common.world.BedrockOreConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BedrockOreFeature
extends Feature<BedrockOreConfiguration> {
    public BedrockOreFeature(Codec<BedrockOreConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<BedrockOreConfiguration> context) {
        BedrockOreConfiguration config = (BedrockOreConfiguration)context.m_159778_();
        BlockPos origin = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        int radius = config.radius().m_214085_(random);
        int height = config.height().m_214085_(random);
        assert (radius > 0);
        assert (height > 0);
        int y = origin.m_123342_();
        int yShift = height / 2;
        int yMaxInclusive = y + height - 1 - yShift;
        int yMinInclusive = y - yShift;
        boolean didPlace = false;
        BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-radius, 0, -radius), (BlockPos)origin.m_7918_(radius, 0, radius))) {
            int dz;
            int dx = pos.m_123341_() - origin.m_123341_();
            if (dx * dx + (dz = pos.m_123343_() - origin.m_123343_()) * dz > radius * radius) continue;
            didPlace |= this.placeColumn(config, level, random, tempPos.m_122190_((Vec3i)pos), yMinInclusive, yMaxInclusive);
        }
        return didPlace;
    }

    protected boolean placeColumn(BedrockOreConfiguration config, WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos pos, int yMinInclusive, int yMaxInclusive) {
        boolean didPlace = false;
        for (int y = yMaxInclusive; y >= yMinInclusive; --y) {
            pos.m_142448_(y);
            if (!config.rule().m_213865_(level.m_8055_((BlockPos)pos), random) || random.m_188501_() >= config.density()) continue;
            this.m_5974_((LevelWriter)level, (BlockPos)pos, ((BedrockOreBlock)((Object)Blocks.BEDROCK_ORE.get())).m_49966_());
            BlockEntity blockEntity = level.m_7702_((BlockPos)pos);
            if (blockEntity instanceof BedrockOreBlockEntity) {
                BedrockOreBlockEntity bedrockOre = (BedrockOreBlockEntity)blockEntity;
                bedrockOre.setOreBlockState(config.ore());
                config.amount().ifLeft(amount -> bedrockOre.setAmount(amount.m_214085_(random))).ifRight(infinite -> bedrockOre.setInfinite());
            }
            didPlace = true;
        }
        return didPlace;
    }
}

