/*
 * Decompiled with CFR 0.152.
 */
package li.cil.bedrockores.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public record BedrockOreConfiguration(BlockState ore, Either<IntProvider, String> amount, IntProvider radius, IntProvider height, float density, RuleTest rule) implements FeatureConfiguration
{
    public static final Codec<String> INFINITE_CODEC = Codec.STRING.flatXmap(BedrockOreConfiguration::verifyInfinite, BedrockOreConfiguration::verifyInfinite);
    public static final Codec<BedrockOreConfiguration> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.f_61039_.fieldOf("ore").forGetter(BedrockOreConfiguration::ore), (App)Codec.either((Codec)IntProvider.f_146533_, INFINITE_CODEC).fieldOf("amount").forGetter(BedrockOreConfiguration::amount), (App)IntProvider.m_146545_((int)0, (int)8).optionalFieldOf("radius", (Object)ConstantInt.m_146483_((int)4)).forGetter(BedrockOreConfiguration::radius), (App)IntProvider.f_146533_.optionalFieldOf("height", (Object)ConstantInt.m_146483_((int)8)).forGetter(BedrockOreConfiguration::height), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("density", (Object)Float.valueOf(0.75f)).forGetter(BedrockOreConfiguration::density), (App)RuleTest.f_74307_.optionalFieldOf("rule", (Object)new BlockMatchTest(Blocks.f_50752_)).forGetter(BedrockOreConfiguration::rule)).apply((Applicative)builder, BedrockOreConfiguration::new));

    private static DataResult<? extends String> verifyInfinite(String value) {
        return "infinite".equals(value) ? DataResult.success((Object)value) : DataResult.error(() -> "Expected 'infinite' or an integer value");
    }
}

