/*
 * Decompiled with CFR 0.152.
 */
package li.cil.bedrockores.common.network.message;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.NotImplementedException;

public abstract class AbstractMessage {
    protected AbstractMessage() {
    }

    protected AbstractMessage(FriendlyByteBuf buffer) {
        this.fromBytes(buffer);
    }

    public static boolean handleMessage(AbstractMessage message, Supplier<NetworkEvent.Context> contextSupplied) {
        message.handleMessage(contextSupplied);
        return true;
    }

    public abstract void fromBytes(FriendlyByteBuf var1);

    public abstract void toBytes(FriendlyByteBuf var1);

    protected void handleMessage(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> this.handleMessage(context));
    }

    protected void handleMessage(NetworkEvent.Context context) {
        throw new NotImplementedException("Message implements neither asynchronous nor synchronous handleMessage() method.");
    }

    @Nullable
    protected static Level getLevel(NetworkEvent.Context context) {
        if (context.getDirection().getReceptionSide().isClient()) {
            return AbstractMessage.getClientLevel();
        }
        return AbstractMessage.getServerLevel(context);
    }

    @Nullable
    private static Level getServerLevel(NetworkEvent.Context context) {
        ServerPlayer sender = context.getSender();
        return sender != null ? sender.m_9236_() : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }
}

