/*
 * Decompiled with CFR 0.152.
 */
package li.cil.bedrockores.common.network;

import java.util.function.Function;
import li.cil.bedrockores.common.network.message.AbstractMessage;
import li.cil.bedrockores.common.network.message.InfoRequestMessage;
import li.cil.bedrockores.common.network.message.InfoResponseMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public final class Network {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("bedrockores", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int nextPacketId = 1;

    public static void initialize() {
        Network.registerMessage(InfoRequestMessage.class, InfoRequestMessage::new, NetworkDirection.PLAY_TO_SERVER);
        Network.registerMessage(InfoResponseMessage.class, InfoResponseMessage::new, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <T extends AbstractMessage> void sendToServer(T message) {
        INSTANCE.sendToServer(message);
    }

    private static <T extends AbstractMessage> void registerMessage(Class<T> type, Function<FriendlyByteBuf, T> decoder, NetworkDirection direction) {
        INSTANCE.messageBuilder(type, Network.getNextPacketId(), direction).encoder(AbstractMessage::toBytes).decoder(decoder).consumerNetworkThread(AbstractMessage::handleMessage).add();
    }

    private static int getNextPacketId() {
        return nextPacketId++;
    }
}

