/*
 * Decompiled with CFR 0.152.
 */
package li.cil.bedrockores.common.block.entity;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import javax.annotation.Nullable;
import li.cil.bedrockores.common.network.Network;
import li.cil.bedrockores.common.network.message.InfoRequestMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockEntityWithInfo
extends BlockEntity {
    public static final TemporalAmount UPDATE_INTERVAL = Duration.ofMillis(500L);
    private Component currentInfo;
    private Instant infoValidUntil = Instant.MIN;

    protected BlockEntityWithInfo(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public final Component getLookAtInfo() {
        Level level = this.m_58904_();
        if (level == null) {
            return null;
        }
        if (Instant.now().isAfter(this.infoValidUntil)) {
            this.infoValidUntil = Instant.now().plus(UPDATE_INTERVAL);
            if (level.m_5776_()) {
                Network.sendToServer(new InfoRequestMessage(this.m_58899_()));
            } else {
                this.currentInfo = this.buildInfo();
            }
        }
        return this.currentInfo;
    }

    public void setInfoClient(@Nullable Component info) {
        this.currentInfo = info;
    }

    protected abstract Component buildInfo();
}

