/*
 * Decompiled with CFR 0.152.
 */
package li.cil.bedrockores.common.block.entity;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import li.cil.bedrockores.common.block.entity.BedrockOreBlockEntity;
import li.cil.bedrockores.common.block.entity.BlockEntities;
import li.cil.bedrockores.common.block.entity.BlockEntityWithInfo;
import li.cil.bedrockores.common.config.Settings;
import li.cil.bedrockores.common.sound.Sounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BedrockOreMinerBlockEntity
extends BlockEntityWithInfo {
    private final FuelItemHandler fuelInventory = new FuelItemHandler();
    private final OutputItemHandler outputInventory = new OutputItemHandler();
    private final EnergyStorageMiner energyStorage = new EnergyStorageMiner();
    private int remainingBurnTime = 0;
    private int extractionCooldown = -1;
    private int transferCooldown = 20;
    private static final String TAG_FUEL_INVENTORY = "input";
    private static final String TAG_OUTPUT_INVENTORY = "output";
    private static final String TAG_ENERGY_STORAGE = "energyStorage";
    private static final String TAG_REMAINING_BURN_TIME = "burnTime";
    private static final String TAG_EXTRACTION_COOLDOWN = "extractionCooldown";
    private static final String TAG_WORKING = "working";
    private static final TemporalAmount SEND_WORKING_STATE_DELAY = Duration.ofSeconds(1L);
    private static final int SLOT_FUEL_COUNT = 1;
    private static final int SLOT_OUTPUT_COUNT = 6;
    private static final int RF_PER_BURN_TIME = 10;
    private static final int SOUND_INTERVAL = 30;
    @javax.annotation.Nullable
    private BedrockOreBlockEntity currentOre;
    private boolean hasNoMoreOres;
    private boolean isWorkingServer;
    private boolean isWorkingClient;
    @javax.annotation.Nullable
    private Instant sendUpdateTagAfter;
    private int soundCooldown;

    public BedrockOreMinerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.MINER.get(), pos, state);
    }

    public boolean isWorking() {
        return this.isWorkingServer;
    }

    public static void clientTick(Level ignoredLevel, BlockPos ignoredPos, BlockState ignoredState, BedrockOreMinerBlockEntity miner) {
        miner.clientTick();
    }

    public static void serverTick(Level ignoredLevel, BlockPos ignoredPos, BlockState ignoredState, BedrockOreMinerBlockEntity miner) {
        miner.serverTick();
    }

    private void clientTick() {
        this.updateEffects();
    }

    private void serverTick() {
        this.flushOutput();
        if (!this.hasAvailableOutputSlot()) {
            this.setWorking(false);
            return;
        }
        this.findBedrockOre();
        if (!this.hasAvailableInputOre()) {
            this.setWorking(false);
            return;
        }
        if (BedrockOreMinerBlockEntity.getInternalPowerEfficiency() > 0.0 || BedrockOreMinerBlockEntity.getExternalPowerEfficiency() > 0.0) {
            this.updateBurnTime();
            if (!this.hasRemainingBurnTime()) {
                this.setWorking(false);
                return;
            }
        }
        this.extractBedrockOre();
        this.setWorking(true);
    }

    @Override
    protected Component buildInfo() {
        Map<Boolean, List<OptionalInt>> ores = this.findBedrockOres().map(BedrockOreBlockEntity::getAmount).collect(Collectors.partitioningBy(OptionalInt::isPresent));
        List<OptionalInt> infiniteOres = ores.get(false);
        if (!infiniteOres.isEmpty()) {
            return Component.m_237110_((String)"gui.bedrockores.expected_yield", (Object[])new Object[]{Component.m_237115_((String)"gui.bedrockores.infinite")});
        }
        List<OptionalInt> finiteOres = ores.get(true);
        int yield = finiteOres.stream().map(OptionalInt::getAsInt).reduce(Integer::sum).orElse(0);
        if (yield > 0) {
            return Component.m_237110_((String)"gui.bedrockores.expected_yield", (Object[])new Object[]{yield});
        }
        return Component.m_237115_((String)"gui.bedrockores.exhausted");
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(TAG_WORKING, this.isWorkingServer);
        return tag;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(TAG_FUEL_INVENTORY, (Tag)this.fuelInventory.serializeNBT());
        tag.m_128365_(TAG_OUTPUT_INVENTORY, (Tag)this.outputInventory.serializeNBT());
        tag.m_128405_(TAG_ENERGY_STORAGE, this.energyStorage.getEnergyStored());
        tag.m_128405_(TAG_REMAINING_BURN_TIME, this.remainingBurnTime);
        tag.m_128405_(TAG_EXTRACTION_COOLDOWN, this.extractionCooldown);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fuelInventory.deserializeNBT(tag.m_128469_(TAG_FUEL_INVENTORY));
        this.outputInventory.deserializeNBT(tag.m_128469_(TAG_OUTPUT_INVENTORY));
        this.energyStorage.setEnergy(tag.m_128451_(TAG_ENERGY_STORAGE));
        this.remainingBurnTime = tag.m_128451_(TAG_REMAINING_BURN_TIME);
        this.extractionCooldown = tag.m_128451_(TAG_EXTRACTION_COOLDOWN);
        this.isWorkingClient = tag.m_128471_(TAG_WORKING);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side != null) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                if (side == Direction.UP) {
                    return LazyOptional.of(() -> this.outputInventory).cast();
                }
                if (side.m_122434_().m_122479_() && BedrockOreMinerBlockEntity.getInternalPowerEfficiency() > 0.0) {
                    return LazyOptional.of(() -> this.fuelInventory).cast();
                }
            } else if (cap == ForgeCapabilities.ENERGY && side.m_122434_().m_122479_() && BedrockOreMinerBlockEntity.getExternalPowerEfficiency() > 0.0) {
                return LazyOptional.of(() -> this.energyStorage).cast();
            }
        }
        return super.getCapability(cap, side);
    }

    private void updateEffects() {
        Level level;
        if (!this.isWorkingClient) {
            return;
        }
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
        if ((level = this.m_58904_()) == null) {
            return;
        }
        if (this.soundCooldown <= 0) {
            this.soundCooldown = 30;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                Vec3 pos = Vec3.m_82512_((Vec3i)this.m_58899_());
                float volume = 1.0f;
                float range = ((SoundEvent)Sounds.MINER.get()).m_215668_(1.0f);
                if (player.m_20238_(pos) < (double)(range * range)) {
                    level.m_7785_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), (SoundEvent)Sounds.MINER.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
        }
        RandomSource rng = level.f_46441_;
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            Vec3 direction = new Vec3(facing.m_253071_());
            Vec3 up = new Vec3(0.0, 1.0, 0.0);
            Vec3 right = direction.m_82537_(up);
            float dx = (rng.m_188501_() - 0.5f) * 0.3f;
            float dy = (rng.m_188501_() - 0.5f) * 0.3f;
            Vec3 origin = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82549_(direction.m_82490_(0.5)).m_82549_(right.m_82490_((double)dx)).m_82549_(up.m_82490_((double)dy));
            Vec3 velocity = direction.m_82490_(0.05);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, origin.f_82479_, origin.f_82480_, origin.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    private void flushOutput() {
        IItemHandler itemHandler;
        ItemStack remainder;
        List entities;
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        int outputSlot = this.findFirstNonEmptyOutputSlot();
        if (outputSlot < 0) {
            return;
        }
        if (this.transferCooldown > 0) {
            --this.transferCooldown;
        }
        if (this.transferCooldown > 0) {
            return;
        }
        LazyOptional optionalItemhandler = LazyOptional.empty();
        BlockPos blockPos = this.m_58899_().m_7494_();
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity != null) {
            optionalItemhandler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
        }
        if (!optionalItemhandler.isPresent() && !(entities = level.m_6249_((Entity)null, new AABB(blockPos), entity -> entity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).isPresent())).isEmpty()) {
            Entity entity2 = (Entity)entities.get(level.f_46441_.m_188503_(entities.size()));
            optionalItemhandler = entity2.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
        }
        if (!optionalItemhandler.isPresent()) {
            this.transferCooldown = 20;
            return;
        }
        ItemStack stack = this.outputInventory.getStackInSlot(outputSlot);
        if (optionalItemhandler.isPresent() && !ItemStack.m_41728_((ItemStack)stack, (ItemStack)(remainder = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (IItemHandler)optionalItemhandler.orElseThrow(AssertionError::new)), (ItemStack)stack.m_41777_(), (boolean)false)))) {
            this.outputInventory.setStackInSlot(outputSlot, remainder);
            this.m_6596_();
        }
        this.transferCooldown = 10;
    }

    private int findFirstNonEmptyOutputSlot() {
        for (int slot = 0; slot < this.outputInventory.getSlots(); ++slot) {
            ItemStack stack = this.outputInventory.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            return slot;
        }
        return -1;
    }

    private boolean hasAvailableOutputSlot() {
        for (int slot = 0; slot < this.outputInventory.getSlots(); ++slot) {
            ItemStack stack = this.outputInventory.getStackInSlot(slot);
            if (!stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    private void findBedrockOre() {
        if (this.hasNoMoreOres) {
            return;
        }
        if (this.currentOre == null || this.currentOre.m_58901_() || this.currentOre.isEmpty()) {
            this.currentOre = this.findBedrockOres().findFirst().orElse(null);
            if (this.currentOre == null) {
                this.hasNoMoreOres = true;
                this.setWorking(false);
            }
        }
    }

    private boolean hasAvailableInputOre() {
        return this.currentOre != null;
    }

    private void updateBurnTime() {
        ItemStack stack;
        int stackBurnTime;
        int scaledBurnTime;
        int energyBurnTime;
        int scaledBurnTime2;
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.remainingBurnTime <= 0 && BedrockOreMinerBlockEntity.getExternalPowerEfficiency() > 0.0 && (scaledBurnTime2 = Mth.m_14165_((double)((double)(energyBurnTime = this.energyStorage.consumeEnergyForBurnTime()) * BedrockOreMinerBlockEntity.getExternalPowerEfficiency()))) > 0) {
            this.remainingBurnTime = scaledBurnTime2;
            this.m_6596_();
        }
        if (this.remainingBurnTime <= 0 && BedrockOreMinerBlockEntity.getInternalPowerEfficiency() > 0.0 && (scaledBurnTime = Mth.m_14165_((double)((double)(stackBurnTime = ForgeHooks.getBurnTime((ItemStack)(stack = this.fuelInventory.extractItem(0, Integer.MAX_VALUE, false)), (RecipeType)RecipeType.f_44108_)) * BedrockOreMinerBlockEntity.getInternalPowerEfficiency()))) > 0) {
            this.remainingBurnTime = scaledBurnTime;
            this.m_6596_();
        }
    }

    private boolean hasRemainingBurnTime() {
        return this.remainingBurnTime > 0;
    }

    private void extractBedrockOre() {
        BedrockOreBlockEntity bedrockOre = Objects.requireNonNull(this.currentOre);
        if (this.extractionCooldown > 0) {
            --this.extractionCooldown;
            return;
        }
        Level level = Objects.requireNonNull(this.m_58904_());
        BlockPos pos = bedrockOre.m_58899_();
        ItemHandlerHelper.insertItem((IItemHandler)this.outputInventory, (ItemStack)bedrockOre.extract(), (boolean)false);
        this.m_6596_();
        this.extractionCooldown = (Integer)Settings.minerExtractionCooldown.get();
        BlockState oreState = bedrockOre.getOreBlockState();
        SoundType soundType = oreState.getSoundType((LevelReader)level, pos, null);
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)pos);
        level.m_6263_(null, blockCenter.m_7096_(), blockCenter.m_7098_(), blockCenter.m_7094_(), soundType.m_56775_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
    }

    private Stream<BedrockOreBlockEntity> findBedrockOres() {
        return StreamSupport.stream(new ScanAreaSpliterator(), false);
    }

    private void setWorking(boolean value) {
        this.isWorkingServer = value;
        if (this.isWorkingServer == this.isWorkingClient) {
            this.sendUpdateTagAfter = null;
        } else if (this.sendUpdateTagAfter == null) {
            this.sendUpdateTagAfter = Instant.now().plus(SEND_WORKING_STATE_DELAY);
        }
        if (this.sendUpdateTagAfter != null && Instant.now().isAfter(this.sendUpdateTagAfter)) {
            this.sendUpdateTagAfter = null;
            this.isWorkingClient = this.isWorkingServer;
            Objects.requireNonNull(this.m_58904_()).m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private static double getInternalPowerEfficiency() {
        return (Double)Settings.minerEfficiency.get() * (Double)Settings.minerEfficiencyInternalPower.get();
    }

    private static double getExternalPowerEfficiency() {
        return (Double)Settings.minerEfficiency.get() * (Double)Settings.minerEfficiencyExternalPower.get();
    }

    private final class FuelItemHandler
    extends ItemStackHandler {
        FuelItemHandler() {
            super(1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (BedrockOreMinerBlockEntity.getInternalPowerEfficiency() <= 0.0) {
                return stack;
            }
            int stackBurnTime = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_);
            int scaledBurnTime = Mth.m_14165_((double)((double)stackBurnTime * BedrockOreMinerBlockEntity.getInternalPowerEfficiency()));
            if (scaledBurnTime <= 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BedrockOreMinerBlockEntity.this.m_6596_();
        }
    }

    private final class OutputItemHandler
    extends ItemStackHandler {
        OutputItemHandler() {
            super(6);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BedrockOreMinerBlockEntity.this.m_6596_();
        }
    }

    private static final class EnergyStorageMiner
    extends EnergyStorage {
        public EnergyStorageMiner() {
            super(EnergyStorageMiner.computeCapacity(), EnergyStorageMiner.computeCapacity(), 0);
        }

        public void setEnergy(int value) {
            this.energy = value;
        }

        public int consumeEnergyForBurnTime() {
            int availableBurnTime = this.energy / 10;
            int usedEnergy = Math.min(this.energy, availableBurnTime * 10);
            this.energy -= usedEnergy;
            return availableBurnTime;
        }

        private static int computeCapacity() {
            return Math.max(100, Mth.m_14165_((double)((double)ForgeHooks.getBurnTime((ItemStack)new ItemStack((ItemLike)Items.f_42413_), (RecipeType)RecipeType.f_44108_) / (10.0 * BedrockOreMinerBlockEntity.getExternalPowerEfficiency()))));
        }
    }

    private final class ScanAreaSpliterator
    extends Spliterators.AbstractSpliterator<BedrockOreBlockEntity> {
        private int x;
        private int y;
        private int z;

        ScanAreaSpliterator() {
            super(ScanAreaSpliterator.numberOfBlocksInArea(), 17745);
            this.x = -ScanAreaSpliterator.radius();
            this.z = -ScanAreaSpliterator.radius();
            this.y = 0;
        }

        @Override
        public boolean tryAdvance(Consumer<? super BedrockOreBlockEntity> action) {
            Level scanLevel = Objects.requireNonNull(BedrockOreMinerBlockEntity.this.m_58904_());
            while (this.y < ScanAreaSpliterator.layers()) {
                BlockEntity tileEntity;
                BlockPos pos = BedrockOreMinerBlockEntity.this.m_58899_().m_7495_().m_7918_(this.x, -this.y, this.z);
                ++this.x;
                if (this.x > ScanAreaSpliterator.radius()) {
                    this.x = -ScanAreaSpliterator.radius();
                    ++this.z;
                    if (this.z > ScanAreaSpliterator.radius()) {
                        this.z = -ScanAreaSpliterator.radius();
                        ++this.y;
                    }
                }
                if (!((tileEntity = scanLevel.m_7702_(pos)) instanceof BedrockOreBlockEntity)) continue;
                BedrockOreBlockEntity bedrockOre = (BedrockOreBlockEntity)tileEntity;
                action.accept(bedrockOre);
                return true;
            }
            return false;
        }

        private static int radius() {
            return (Integer)Settings.minerAreaRadius.get() - 1;
        }

        private static int layers() {
            return (Integer)Settings.minerAreaLayers.get();
        }

        private static int numberOfBlocksInArea() {
            return (ScanAreaSpliterator.radius() * 2 + 1) * (ScanAreaSpliterator.radius() * 2 + 1) * ScanAreaSpliterator.layers();
        }
    }
}

