/*
 * Decompiled with CFR 0.152.
 */
package li.cil.bedrockores.common.block.entity;

import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import li.cil.bedrockores.client.render.Ore;
import li.cil.bedrockores.common.block.Blocks;
import li.cil.bedrockores.common.block.entity.BlockEntities;
import li.cil.bedrockores.common.block.entity.BlockEntityWithInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public final class BedrockOreBlockEntity
extends BlockEntityWithInfo {
    private BlockState oreBlockState = net.minecraft.world.level.block.Blocks.f_50016_.m_49966_();
    @Nullable
    private Integer amount;
    private static final String TAG_STATE = "state";
    private static final String TAG_AMOUNT = "amount";
    private ItemStack droppedStack = ItemStack.f_41583_;

    public BedrockOreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.BEDROCK_ORE.get(), pos, state);
    }

    public BlockState getOreBlockState() {
        return this.oreBlockState;
    }

    public void setOreBlockState(BlockState state) {
        if (state.m_60713_((Block)Blocks.BEDROCK_ORE.get())) {
            throw new IllegalArgumentException("Bedrock ore cannot contain itself.");
        }
        if (Objects.equals(state, this.oreBlockState)) {
            return;
        }
        BlockState oldState = this.oreBlockState;
        this.oreBlockState = state;
        this.droppedStack = new ItemStack((ItemLike)state.m_60734_().m_5456_());
        Level level = this.m_58904_();
        if (level != null) {
            if (level.m_5776_()) {
                this.setChangedAndSendUpdateClient();
            } else {
                this.setChangedAndSendUpdateServer();
            }
            if (this.oreBlockState.getLightEmission((BlockGetter)level, this.m_58899_()) != oldState.getLightEmission((BlockGetter)level, this.m_58899_()) || this.oreBlockState.m_60739_((BlockGetter)level, this.m_58899_()) != oldState.m_60739_((BlockGetter)level, this.m_58899_())) {
                level.m_7726_().m_7827_().m_7174_(this.m_58899_());
            }
        }
    }

    public OptionalInt getAmount() {
        if (this.oreBlockState.m_60795_()) {
            return OptionalInt.of(0);
        }
        if (this.isInfinite()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.amount);
    }

    public void setAmount(int value) {
        this.amount = value;
    }

    public boolean isInfinite() {
        return this.amount == null;
    }

    public void setInfinite() {
        this.amount = null;
    }

    public boolean isEmpty() {
        OptionalInt amount = this.getAmount();
        if (amount.isPresent()) {
            return amount.getAsInt() <= 0;
        }
        return false;
    }

    public ItemStack extract() {
        Level level = this.m_58904_();
        if (level == null || level.m_5776_()) {
            return ItemStack.f_41583_;
        }
        boolean wasEmpty = this.isEmpty();
        if (!this.isInfinite()) {
            if (!wasEmpty) {
                this.amount = this.amount - 1;
            }
            if (this.isEmpty()) {
                level.m_7731_(this.m_58899_(), net.minecraft.world.level.block.Blocks.f_50752_.m_49966_(), level.m_5776_() ? 11 : 3);
            } else {
                this.m_6596_();
            }
        }
        return wasEmpty ? ItemStack.f_41583_ : this.droppedStack.m_41777_();
    }

    @Override
    protected Component buildInfo() {
        if (this.isInfinite()) {
            return Component.m_237110_((String)"gui.bedrockores.expected_yield", (Object[])new Object[]{Component.m_237115_((String)"gui.bedrockores.infinite")});
        }
        return Component.m_237110_((String)"gui.bedrockores.expected_yield", (Object[])new Object[]{this.amount});
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        BlockState oldState = this.oreBlockState;
        super.handleUpdateTag(tag);
        if (this.oreBlockState != oldState) {
            this.requestModelDataUpdate();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.oreBlockState != null) {
            BlockState.f_61039_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.oreBlockState).result().ifPresent(stateNbt -> tag.m_128365_(TAG_STATE, stateNbt));
            if (!this.isInfinite()) {
                tag.m_128405_(TAG_AMOUNT, this.amount.intValue());
            } else {
                tag.m_128473_(TAG_AMOUNT);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.oreBlockState = BlockState.f_61039_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(TAG_STATE)).result().orElse(net.minecraft.world.level.block.Blocks.f_50016_.m_49966_());
        this.droppedStack = new ItemStack((ItemLike)this.oreBlockState.m_60734_().m_5456_());
        if (tag.m_128425_(TAG_AMOUNT, 3)) {
            this.setAmount(tag.m_128451_(TAG_AMOUNT));
        } else {
            this.setInfinite();
        }
    }

    @NotNull
    public ModelData getModelData() {
        return Ore.create(this).asModelData();
    }

    private void setChangedAndSendUpdateServer() {
        this.m_6596_();
        Objects.requireNonNull(this.m_58904_()).m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    private void setChangedAndSendUpdateClient() {
        this.requestModelDataUpdate();
        Objects.requireNonNull(this.m_58904_()).m_6550_(this.m_58899_(), this.m_58900_(), this.m_58900_());
    }
}

