/*
 * Decompiled with CFR 0.152.
 */
package li.cil.bedrockores.common.block;

import li.cil.bedrockores.common.block.entity.BedrockOreBlockEntity;
import li.cil.bedrockores.common.block.entity.BlockEntities;
import li.cil.bedrockores.common.config.Settings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public final class BedrockOreBlock
extends BaseEntityBlock {
    public BedrockOreBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(-1.0f, 3600000.0f).m_222994_().m_60922_((state, reader, pos, entity) -> false));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntities.BEDROCK_ORE.get()).m_155264_(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.m_7500_()) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        if (!((Boolean)Settings.allowPlayerMining.get()).booleanValue()) {
            return false;
        }
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof BedrockOreBlockEntity) {
            BedrockOreBlockEntity bedrockOre = (BedrockOreBlockEntity)tileEntity;
            BlockState oreBlockState = bedrockOre.getOreBlockState();
            bedrockOre.extract();
            oreBlockState.m_60734_().m_5707_(level, pos, oreBlockState, player);
            oreBlockState.m_60734_().m_6240_(level, player, pos, oreBlockState, null, player.m_21205_().m_41777_());
        }
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.m_60739_(level, pos);
        }
        return super.m_7753_(state, level, pos);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.m_60625_(player, level, pos);
        }
        return super.m_5880_(state, player, level, pos);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @javax.annotation.Nullable Entity entity) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.getFriction(level, pos, entity);
        }
        return super.getFriction(state, level, pos, entity);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.getLightEmission(level, pos);
        }
        return super.getLightEmission(state, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.canHarvestBlock(level, pos, player);
        }
        return super.canHarvestBlock(state, level, pos, player);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.m_60643_(level, pos, entityType);
        }
        return super.isValidSpawn(state, level, pos, type, entityType);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.getCloneItemStack(target, level, pos, player);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public boolean addLandingEffects(BlockState state, ServerLevel level, BlockPos pos, BlockState stateOverride, LivingEntity entity, int numberOfParticles) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.addLandingEffects(level, pos, stateOverride, entity, numberOfParticles);
        }
        return super.addLandingEffects(state, level, pos, stateOverride, entity, numberOfParticles);
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.addRunningEffects(level, pos, entity);
        }
        return super.addRunningEffects(state, level, pos, entity);
    }

    public int getExpDrop(BlockState state, LevelReader level, RandomSource randomSource, BlockPos pos, int fortuneLevel, int silkTouchLevel) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.getExpDrop(level, randomSource, pos, fortuneLevel, silkTouchLevel);
        }
        return super.getExpDrop(state, level, randomSource, pos, fortuneLevel, silkTouchLevel);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        return false;
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.m_284242_(level, pos);
        }
        return super.getMapColor(state, level, pos, defaultColor);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        BlockState ore = BedrockOreBlock.getOreBlockState(level.m_7702_(pos));
        if (ore != null) {
            return ore.getAppearance(level, pos, side, queryState, queryPos);
        }
        return super.getAppearance(state, level, pos, side, queryState, queryPos);
    }

    @javax.annotation.Nullable
    private static BlockState getOreBlockState(@javax.annotation.Nullable BlockEntity tileEntity) {
        if (tileEntity instanceof BedrockOreBlockEntity) {
            BedrockOreBlockEntity bedrockOre = (BedrockOreBlockEntity)tileEntity;
            return bedrockOre.getOreBlockState();
        }
        return null;
    }
}

