/*
 * Decompiled with CFR 0.152.
 */
package li.cil.bedrockores.common.block;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.bedrockores.common.block.entity.BedrockOreMinerBlockEntity;
import li.cil.bedrockores.common.block.entity.BlockEntities;
import li.cil.bedrockores.common.config.Settings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public final class BedrockMinerBlock
extends BaseEntityBlock {
    public BedrockMinerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56743_));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntities.MINER.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return BedrockMinerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockEntities.MINER.get()), BedrockOreMinerBlockEntity::clientTick);
        }
        return BedrockMinerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockEntities.MINER.get()), BedrockOreMinerBlockEntity::serverTick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BedrockOreMinerBlockEntity) {
            BedrockOreMinerBlockEntity miner = (BedrockOreMinerBlockEntity)blockEntity;
            return miner.isWorking() ? 15 : 0;
        }
        return super.m_6782_(blockState, level, pos);
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BedrockOreMinerBlockEntity) {
            BedrockOreMinerBlockEntity miner = (BedrockOreMinerBlockEntity)blockEntity;
            miner.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemHandler.getStackInSlot(slot));
                }
            });
        }
        super.m_6810_(oldState, level, pos, newState, movedByPiston);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flags) {
        super.m_5871_(stack, level, tooltip, flags);
        int edgeLength = ((Integer)Settings.minerAreaRadius.get() - 1) * 2 + 1;
        Integer layers = (Integer)Settings.minerAreaLayers.get();
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bedrockores.bedrock_miner", (Object[])new Object[]{edgeLength, layers, edgeLength}).m_130940_(ChatFormatting.GRAY));
    }
}

