/*
 * Decompiled with CFR 0.152.
 */
package net.finallion.nyctophobia.init;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.finallion.nyctophobia.NyctophobiaBiomes;
import net.finallion.nyctophobia.config.NyctophobiaConfig;
import net.finallion.nyctophobia.init.NBiomes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class NBiomeProvider
extends Region {
    public NBiomeProvider(ResourceLocation name, int overworldWeight) {
        super(name, RegionType.OVERWORLD, overworldWeight);
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
            List configBiomes;
            if (((Boolean)NyctophobiaConfig.COMMON.enableHauntedForest.get()).booleanValue()) {
                configBiomes = (List)NyctophobiaConfig.COMMON.replaceableBiomesHauntedForest.get();
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome, registry.m_6579_()), NBiomes.HAUNTED_FOREST_KEY);
                }
            }
            if (((Boolean)NyctophobiaConfig.COMMON.enableErodedHauntedForest.get()).booleanValue()) {
                configBiomes = (List)NyctophobiaConfig.COMMON.replaceableBiomesErodedHauntedForest.get();
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome, registry.m_6579_()), NBiomes.ERODED_HAUNTED_FOREST_KEY);
                }
            }
            if (((Boolean)NyctophobiaConfig.COMMON.enableHauntedLakes.get()).booleanValue()) {
                configBiomes = (List)NyctophobiaConfig.COMMON.replaceableBiomesHauntedlakes.get();
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome, registry.m_6579_()), NBiomes.HAUNTED_LAKES_KEY);
                }
            }
            if (((Boolean)NyctophobiaConfig.COMMON.enableAncientDeadCoralReef.get()).booleanValue()) {
                configBiomes = (List)NyctophobiaConfig.COMMON.replaceableBiomesDeadCoralReef.get();
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome, registry.m_6579_()), NBiomes.ANCIENT_DEAD_CORAL_REEF_KEY);
                }
            }
            if (((Boolean)NyctophobiaConfig.COMMON.enableDeepDarkForest.get()).booleanValue()) {
                configBiomes = (List)NyctophobiaConfig.COMMON.replaceableBiomesDeepDarkForest.get();
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome, registry.m_6579_()), NBiomes.DEEP_DARK_FOREST_KEY);
                }
            }
        });
    }

    private ResourceKey<Biome> parseBiomeKeys(String configKey, Set<Map.Entry<ResourceKey<Biome>, Biome>> entrySet) {
        List biomeKeys = entrySet.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        for (ResourceKey key : biomeKeys) {
            String biomeName = key.m_135782_().m_135815_();
            if (!biomeName.equals(configKey)) continue;
            return key;
        }
        NyctophobiaBiomes.LOGGER.error("Wrong biome key \"" + configKey + "\" in config!");
        return null;
    }
}

