/*
 * Decompiled with CFR 0.152.
 */
package net.finallion.nyctophobia.events;

import com.mojang.blaze3d.systems.RenderSystem;
import net.finallion.nyctophobia.config.NyctophobiaConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nyctophobia", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    private static double fogDensity;
    private static float fogStart;

    @SubscribeEvent
    public static void FogDensityEvent(ViewportEvent.RenderFog event) {
        BlockPos pos = event.getRenderer().m_109153_().m_90588_();
        Entity entity = event.getCamera().m_90592_();
        FogType cameraSubmersionType = event.getCamera().m_167685_();
        String biomeName = entity.m_9236_().m_204166_(pos).toString();
        if (!(((Boolean)NyctophobiaConfig.COMMON.enableFogHauntedForest.get()).booleanValue() || ((Boolean)NyctophobiaConfig.COMMON.enableFogHauntedLakes.get()).booleanValue() || ((Boolean)NyctophobiaConfig.COMMON.enableFogErodedHauntedForest.get()).booleanValue())) {
            return;
        }
        if (biomeName.contains("haunted_lakes") && ((Boolean)NyctophobiaConfig.COMMON.enableFogHauntedLakes.get()).booleanValue()) {
            if (pos.m_123342_() > (Integer)NyctophobiaConfig.COMMON.fogHauntedLakesMaxY.get() || pos.m_123342_() < (Integer)NyctophobiaConfig.COMMON.fogHauntedLakesMinY.get()) {
                if (fogStart < event.getFarPlaneDistance() / 2.0f) {
                    fogStart *= 1.05f;
                } else {
                    fogStart = event.getFarPlaneDistance() / 2.0f;
                    return;
                }
            }
            fogDensity = (Double)NyctophobiaConfig.COMMON.fogHauntedLakesDensity.get();
        } else if (biomeName.contains("eroded_haunted_forest") && ((Boolean)NyctophobiaConfig.COMMON.enableFogErodedHauntedForest.get()).booleanValue()) {
            if (pos.m_123342_() > (Integer)NyctophobiaConfig.COMMON.fogErodedHauntedForestMaxY.get() || pos.m_123342_() < (Integer)NyctophobiaConfig.COMMON.fogErodedHauntedForestMinY.get()) {
                if (fogStart < event.getFarPlaneDistance() / 2.0f) {
                    fogStart *= 1.05f;
                } else {
                    fogStart = event.getFarPlaneDistance() / 2.0f;
                    return;
                }
            }
            fogDensity = (Double)NyctophobiaConfig.COMMON.fogErodedHauntedForestDensity.get();
        } else if (biomeName.contains("haunted_forest") && !biomeName.contains("eroded") && ((Boolean)NyctophobiaConfig.COMMON.enableFogHauntedForest.get()).booleanValue()) {
            if (pos.m_123342_() > (Integer)NyctophobiaConfig.COMMON.fogHauntedForestMaxY.get() || pos.m_123342_() < (Integer)NyctophobiaConfig.COMMON.fogHauntedForestMinY.get()) {
                if (fogStart < event.getFarPlaneDistance() / 2.0f) {
                    fogStart *= 1.05f;
                } else {
                    fogStart = event.getFarPlaneDistance() / 2.0f;
                    return;
                }
            }
            fogDensity = (Double)NyctophobiaConfig.COMMON.fogHauntedForestDensity.get();
        } else if (fogStart < event.getFarPlaneDistance() / 2.0f) {
            fogStart *= 1.05f;
        } else {
            fogStart = event.getFarPlaneDistance() / 2.0f;
            return;
        }
        if (!(cameraSubmersionType != FogType.NONE || entity instanceof LivingEntity && ((LivingEntity)entity).m_21023_(MobEffects.f_19610_))) {
            float g = event.getRenderer().m_109152_();
            float viewDistance = Math.max(g - 16.0f, 32.0f);
            if ((double)fogStart > fogDensity) {
                fogStart *= 0.975f;
            }
            float start = viewDistance * 0.05f * fogStart;
            float end = Math.min(viewDistance, 192.0f) * 0.5f * fogStart;
            if (start > 64.0f) {
                start = 64.0f;
            }
            if (end > event.getFarPlaneDistance()) {
                end = event.getFarPlaneDistance();
            }
            RenderSystem.setShaderFogStart((float)start);
            RenderSystem.setShaderFogEnd((float)end);
        }
    }

    static {
        fogStart = 32.0f;
    }
}

