/*
 * Decompiled with CFR 0.152.
 */
package net.finallion.nyctophobia.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public final ForgeConfigSpec.IntValue nyctophobiaBiomesWeight;
    public final ForgeConfigSpec.BooleanValue enableHauntedForest;
    public final ForgeConfigSpec.BooleanValue enableHauntedLakes;
    public final ForgeConfigSpec.BooleanValue enableErodedHauntedForest;
    public final ForgeConfigSpec.BooleanValue enableAncientDeadCoralReef;
    public final ForgeConfigSpec.BooleanValue enableDeepDarkForest;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> replaceableBiomesHauntedForest;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> replaceableBiomesErodedHauntedForest;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> replaceableBiomesHauntedlakes;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> replaceableBiomesDeadCoralReef;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> replaceableBiomesDeepDarkForest;
    public final ForgeConfigSpec.BooleanValue enableFogHauntedForest;
    public final ForgeConfigSpec.DoubleValue fogHauntedForestDensity;
    public final ForgeConfigSpec.IntValue fogHauntedForestMinY;
    public final ForgeConfigSpec.IntValue fogHauntedForestMaxY;
    public final ForgeConfigSpec.BooleanValue enableFogHauntedLakes;
    public final ForgeConfigSpec.DoubleValue fogHauntedLakesDensity;
    public final ForgeConfigSpec.IntValue fogHauntedLakesMinY;
    public final ForgeConfigSpec.IntValue fogHauntedLakesMaxY;
    public final ForgeConfigSpec.BooleanValue enableFogErodedHauntedForest;
    public final ForgeConfigSpec.DoubleValue fogErodedHauntedForestDensity;
    public final ForgeConfigSpec.IntValue fogErodedHauntedForestMinY;
    public final ForgeConfigSpec.IntValue fogErodedHauntedForestMaxY;
    public final ForgeConfigSpec.BooleanValue useSoulLanternsInHauntedLakes;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Welcome to the Nyctophobia Config!\n\nConfigure the weight of the biomes by changing \"nyctophobiaBiomesWeight\".\nConfigure which minecraft biomes can be replaced by Nyctophobia biomes.\nA full list of all the biomes can be found here https:minecraft.fandom.com/wiki/Biome#Biome_IDs.\nConfigure fog density and fog height.\n");
        builder.push("Nyctophobia - Biome Config");
        this.nyctophobiaBiomesWeight = builder.comment("Set weight of the Nyctophobia biomes").defineInRange("nyctophobia_weight.weight", 1, 0, 100);
        this.enableAncientDeadCoralReef = builder.comment("Allow the biome to spawn: ").define("ancient_dead_coral_reef.generate", true);
        this.replaceableBiomesDeadCoralReef = builder.comment("Set minecraft biomes in which the Nyctophobia biome will spawn: ").defineList("ancient_dead_coral_reef.replaceableBiomes", Arrays.asList("beach"), o -> o instanceof String);
        this.enableHauntedForest = builder.comment("Allow the biome to spawn: ").define("haunted_forest.generate", true);
        this.replaceableBiomesHauntedForest = builder.comment("Set minecraft biomes in which the Nyctophobia biome will spawn: ").defineList("haunted_forest.replaceableBiomes", Arrays.asList("windswept_forest"), o -> o instanceof String);
        this.enableHauntedLakes = builder.comment("Allow the biome to spawn: ").define("haunted_lakes.generate", true);
        this.replaceableBiomesHauntedlakes = builder.comment("Set minecraft biomes in which the Nyctophobia biome will spawn: ").defineList("haunted_lakes.replaceableBiomes", Arrays.asList("swamp"), o -> o instanceof String);
        this.enableErodedHauntedForest = builder.comment("Allow the biome to spawn: ").define("eroded_haunted_forest.generate", true);
        this.replaceableBiomesErodedHauntedForest = builder.comment("Set minecraft biomes in which the Nyctophobia biome will spawn: ").defineList("eroded_haunted_forest.replaceableBiomes", Arrays.asList("meadow"), o -> o instanceof String);
        this.enableDeepDarkForest = builder.comment("Allow the biome to spawn: ").define("deep_dark_forest.generate", true);
        this.replaceableBiomesDeepDarkForest = builder.comment("Set minecraft biomes in which the Nyctophobia biome will spawn: ").defineList("deep_dark_forest.replaceableBiomes", Arrays.asList("dark_forest"), o -> o instanceof String);
        builder.pop();
        builder.push("Nyctophobia - Biome Fog Config");
        this.enableFogHauntedForest = builder.comment("Enable fog in the biome: ").define("fog_haunted_forest.generate", true);
        this.fogHauntedForestDensity = builder.comment("Set density of the fog (smaller values = denser): ").defineInRange("fog_haunted_forest.density", 0.35, 0.0, 32.0);
        this.fogHauntedForestMinY = builder.comment("Set Y value, where the fog starts: ").defineInRange("fog_haunted_forest.minY", 63, -64, 256);
        this.fogHauntedForestMaxY = builder.comment("Set Y value, where the fog ends: ").defineInRange("fog_haunted_forest.maxY", 148, -64, 256);
        this.enableFogHauntedLakes = builder.comment("Enable fog in the biome: ").define("fog_haunted_lakes.generate", true);
        this.fogHauntedLakesDensity = builder.comment("Set density of the fog (smaller values = denser): ").defineInRange("fog_haunted_lakes.density", 0.3, 0.0, 32.0);
        this.fogHauntedLakesMinY = builder.comment("Set Y value, where the fog starts: ").defineInRange("fog_haunted_lakes.minY", 63, -64, 256);
        this.fogHauntedLakesMaxY = builder.comment("Set Y value, where the fog ends: ").defineInRange("fog_haunted_lakes.maxY", 128, -64, 256);
        this.enableFogErodedHauntedForest = builder.comment("Enable fog in the biome: ").define("fog_eroded_haunted_forest.generate", true);
        this.fogErodedHauntedForestDensity = builder.comment("Set density of the fog (smaller values = denser): ").defineInRange("fog_eroded_haunted_forest.density", 0.35, 0.0, 32.0);
        this.fogErodedHauntedForestMinY = builder.comment("Set Y value, where the fog starts: ").defineInRange("fog_eroded_haunted_forest.minY", 93, -64, 256);
        this.fogErodedHauntedForestMaxY = builder.comment("Set Y value, where the fog ends: ").defineInRange("fog_eroded_haunted_forest.maxY", 160, -64, 256);
        builder.pop();
        builder.push("Nyctophobia - Misc Config");
        this.useSoulLanternsInHauntedLakes = builder.comment("Soul Lanterns will spawn instead of candles in the Haunted Lakes.").define("haunted_lakes_soul_lanterns", false);
        builder.pop();
    }
}

