/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.event.bus;

import com.blamejared.crafttweaker.api.event.Phase;
import com.blamejared.crafttweaker.api.event.bus.IEventBus;
import com.blamejared.crafttweaker.api.event.bus.IEventBusWire;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.google.common.base.Suppliers;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.eventbus.api.IGenericEvent;
import net.minecraftforge.fml.event.IModBusEvent;
import org.apache.commons.lang3.NotImplementedException;

public final class ForgeEventBusWire
implements IEventBusWire {
    private static final Supplier<IEventBusWire> INSTANCE = Suppliers.memoize(ForgeEventBusWire::new);
    private static final Map<Phase, EventPriority> PRIORITIES = (Map)Util.m_137469_(new EnumMap(Phase.class), it -> {
        it.put(Phase.EARLIEST, EventPriority.HIGHEST);
        it.put(Phase.NORMAL, EventPriority.NORMAL);
        it.put(Phase.LATEST, EventPriority.LOWEST);
    });

    private ForgeEventBusWire() {
    }

    public static IEventBusWire of() {
        return INSTANCE.get();
    }

    @Override
    public <T> void registerBusForDispatch(TypeToken<T> eventType, IEventBus<T> bus) {
        if (!eventType.isSubtypeOf(Event.class)) {
            throw new IllegalArgumentException("Unable to wire EventBus to Forge bus for type " + eventType);
        }
        this.registerBus((TypeToken)GenericUtil.uncheck(eventType), (IEventBus)GenericUtil.uncheck(bus));
    }

    private <T extends Event> void registerBus(TypeToken<T> eventType, IEventBus<T> bus) {
        ListenerRegistrationHandler registrationHandler = this.discoverRegistrationHandler(eventType);
        PRIORITIES.forEach((phase, priority) -> registrationHandler.register((EventPriority)priority, true, e -> bus.post((Phase)((Object)phase), (Object)e)));
    }

    private <T extends Event> ListenerRegistrationHandler<T> discoverRegistrationHandler(TypeToken<T> token) {
        net.minecraftforge.eventbus.api.IEventBus bus = this.discoverBus(token);
        boolean isGeneric = token.isSubtypeOf(IGenericEvent.class);
        Class rawClass = (Class)GenericUtil.uncheck(token.getRawType());
        if (!isGeneric) {
            return (priority, receiveCanceled, handler) -> bus.addListener(priority, receiveCanceled, rawClass, handler);
        }
        return (ListenerRegistrationHandler)GenericUtil.uncheck(this.discoverGenericHandler((TypeToken)GenericUtil.uncheck(token), (Class)GenericUtil.uncheck(rawClass), bus));
    }

    private <T extends Event> net.minecraftforge.eventbus.api.IEventBus discoverBus(TypeToken<T> token) {
        if (token.isSubtypeOf(IModBusEvent.class)) {
            throw new NotImplementedException("TODO");
        }
        return MinecraftForge.EVENT_BUS;
    }

    private <E, T extends GenericEvent<? extends E>> ListenerRegistrationHandler<T> discoverGenericHandler(TypeToken<T> token, Class<T> rawType, net.minecraftforge.eventbus.api.IEventBus bus) {
        Class genericType = (Class)GenericUtil.uncheck(this.determineGeneric(token.getType()));
        Objects.requireNonNull(genericType, "Expected a generic type for a generic event: buses listening to all instances are unsupported as of now");
        return (priority, receiveCanceled, handler) -> bus.addGenericListener(genericType, priority, receiveCanceled, rawType, handler);
    }

    private Class<?> determineGeneric(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Generic event must be specified by a parameterized type, not " + type.getTypeName() + "/" + type.getClass().getName());
        }
        ParameterizedType generic = (ParameterizedType)type;
        Object[] generics = generic.getActualTypeArguments();
        if (generics.length != 1) {
            throw new IllegalArgumentException("Generic event on Forge requires only a single parameter type, but got " + Arrays.deepToString(generics));
        }
        Type argument = generics[0];
        return this.determineInnerGeneric(argument);
    }

    private Class<?> determineInnerGeneric(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType generic = (ParameterizedType)type;
            Type raw = generic.getRawType();
            if (!(raw instanceof Class)) {
                throw new UnsupportedOperationException("Java reflection API has changed");
            }
            Class clazz = (Class)raw;
            return clazz;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            Type[] upperBounds = wildcard.getUpperBounds();
            Type[] lowerBounds = wildcard.getLowerBounds();
            if (upperBounds.length == 1 && lowerBounds.length == 0 && upperBounds[0] == Object.class) {
                return null;
            }
            throw new IllegalArgumentException("Generic event on Forge must not be parameterized with wildcards");
        }
        throw new IllegalArgumentException("Type " + type.getTypeName() + "/" + type.getClass().getName() + " is unsupported on Forge");
    }

    @FunctionalInterface
    private static interface ListenerRegistrationHandler<E extends Event> {
        public void register(EventPriority var1, boolean var2, Consumer<E> var3);
    }
}

