/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.goal.mauler;

import com.faboslav.friendsandfoes.entity.MaulerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public final class MaulerBurrowDownGoal
extends Goal {
    private final MaulerEntity mauler;
    private int burrowedDownTicks;
    private Block blockUnderMauler;
    private SoundEvent soundForBlockUnderMauler;
    private boolean isRunning;

    public MaulerBurrowDownGoal(MaulerEntity mauler) {
        this.mauler = mauler;
    }

    public boolean m_8036_() {
        if (this.mauler.m_21660_() || this.mauler.m_9236_().m_46462_() || this.mauler.m_21573_().m_26572_() || this.mauler.m_217043_().m_188501_() < 0.999f || this.mauler.getTicksUntilNextBurrowingDown() > 0) {
            return false;
        }
        this.setBlockUnderMauler();
        boolean isRelatedBlock = this.blockUnderMauler == Blocks.f_49992_ || this.blockUnderMauler == Blocks.f_49993_ || this.blockUnderMauler == Blocks.f_50493_ || this.blockUnderMauler == Blocks.f_50546_ || this.blockUnderMauler == Blocks.f_50440_;
        return isRelatedBlock;
    }

    public boolean m_8045_() {
        return this.burrowedDownTicks > 0;
    }

    public void m_8056_() {
        this.isRunning = true;
        this.mauler.m_21573_().m_26517_(0.0);
        this.mauler.m_21573_().m_26573_();
        if (this.getBurrowedDownTicks() == 0) {
            this.burrowedDownTicks = this.mauler.m_217043_().m_216332_(600, 1200);
        }
        this.mauler.setBurrowedDown(true);
        this.mauler.m_20331_(true);
        this.soundForBlockUnderMauler = this.blockUnderMauler == Blocks.f_49992_ || this.blockUnderMauler == Blocks.f_49993_ ? SoundEvents.f_12331_ : SoundEvents.f_11988_;
    }

    public void m_8041_() {
        this.isRunning = false;
        this.mauler.m_6842_(false);
        this.mauler.m_20331_(false);
        this.mauler.setBurrowedDown(false);
        this.mauler.setTicksUntilNextBurrowingDown(this.mauler.m_217043_().m_216332_(3000, 6000));
    }

    public void m_8037_() {
        float burrowingDownAnimationProgress = this.mauler.getBurrowingDownAnimationProgress();
        if (burrowingDownAnimationProgress > 0.0f && burrowingDownAnimationProgress < 1.0f) {
            Level world;
            BlockPos blockPos = this.mauler.m_20183_();
            if (this.mauler.f_19797_ % 3 == 0) {
                this.mauler.m_9236_().m_5594_(null, blockPos, this.soundForBlockUnderMauler, SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            if ((world = this.mauler.m_9236_()).m_5776_()) {
                return;
            }
            for (int i = 0; i < 7; ++i) {
                ((ServerLevel)world).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.blockUnderMauler.m_49966_()), this.mauler.m_20208_(0.5), this.mauler.m_20187_(), this.mauler.m_20262_(0.5), 1, this.mauler.m_217043_().m_188583_() * 0.02, this.mauler.m_217043_().m_188583_() * 0.02, this.mauler.m_217043_().m_188583_() * 0.02, 0.1);
            }
        } else if (this.mauler.isBurrowedDown() && this.mauler.getBurrowingDownAnimationProgress() == 1.0f) {
            this.mauler.m_6842_(true);
        }
        --this.burrowedDownTicks;
    }

    public void setBlockUnderMauler() {
        BlockPos blockPos = this.mauler.m_20183_().m_7495_();
        BlockState blockState = this.mauler.m_9236_().m_8055_(blockPos);
        this.blockUnderMauler = blockState.m_60734_();
    }

    public int getBurrowedDownTicks() {
        return this.burrowedDownTicks;
    }

    public void setBurrowedDownTicks(int burrowedDownTicks) {
        this.burrowedDownTicks = burrowedDownTicks;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

