/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.brain.sensor;

import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CopperGolemSpecificSensor
extends Sensor<CopperGolemEntity> {
    private static final Predicate<Player> NOTICEABLE_PLAYER_FILTER = player -> {
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        Item itemInHand = itemStack.m_41720_();
        return itemInHand instanceof AxeItem && EntitySelector.f_20406_.test(player);
    };
    private static final UniformInt AVOID_MEMORY_DURATION = TimeUtil.m_145020_((int)5, (int)10);

    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)MemoryModuleType.f_26383_);
    }

    protected void sense(ServerLevel world, CopperGolemEntity copperGolem) {
        Brain<CopperGolemEntity> brain = copperGolem.m_6274_();
        if (brain.m_21876_(MemoryModuleType.f_26383_, MemoryStatus.VALUE_PRESENT)) {
            return;
        }
        List<ServerPlayer> players = world.m_6907_().stream().filter(NOTICEABLE_PLAYER_FILTER).filter(player -> copperGolem.m_19950_((Entity)player, 16.0)).sorted(Comparator.comparingDouble(arg_0 -> ((CopperGolemEntity)copperGolem).m_20280_(arg_0))).toList();
        if (players.isEmpty() || !copperGolem.isWaxed()) {
            return;
        }
        brain.m_21936_(MemoryModuleType.f_26372_);
        brain.m_21936_(MemoryModuleType.f_26370_);
        brain.m_21936_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get());
        brain.m_21882_(MemoryModuleType.f_26383_, (Object)((LivingEntity)players.get(0)), (long)AVOID_MEMORY_DURATION.m_214085_(copperGolem.m_217043_()));
    }
}

