/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events.overrides;

import com.google.common.base.Suppliers;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.supplementaries.common.block.blocks.DirectionalCakeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.DoubleCakeBlock;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventOverrideHandler;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ItemUseOnBlockOverride;
import net.mehvahdjukaar.supplementaries.common.misc.CakeRegistry;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

class DoubleCakeBehavior
implements ItemUseOnBlockOverride {
    private static final Supplier<Set<Block>> CAKES = Suppliers.memoize(() -> CakeRegistry.INSTANCE.getValues().stream().map(v -> v.cake).collect(Collectors.toUnmodifiableSet()));
    private static final Supplier<Set<Item>> CAKES_ITEMS = Suppliers.memoize(() -> CakeRegistry.INSTANCE.getValues().stream().map(v -> v.cake.m_5456_()).collect(Collectors.toUnmodifiableSet()));

    DoubleCakeBehavior() {
    }

    @Override
    public boolean altersWorld() {
        return true;
    }

    @Override
    public boolean placesBlock() {
        return true;
    }

    @Override
    @Nullable
    public MutableComponent getTooltip() {
        return Component.m_237115_((String)"message.supplementaries.double_cake");
    }

    @Override
    public boolean isEnabled() {
        return CommonConfigs.Tweaks.DOUBLE_CAKE_PLACEMENT.get();
    }

    @Override
    public boolean appliesToItem(Item item) {
        return CAKES_ITEMS.get().contains(item);
    }

    @Override
    public InteractionResult tryPerformingAction(Level level, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        BlockPos pos = hit.m_82425_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if ((CAKES.get().contains(block) || block instanceof DirectionalCakeBlock) && (Integer)state.m_61143_((Property)DirectionalCakeBlock.f_51180_) == 0) {
            BlockItem bi;
            Item item;
            CakeRegistry.CakeType t;
            if (block instanceof DirectionalCakeBlock) {
                DirectionalCakeBlock dc = (DirectionalCakeBlock)block;
                t = dc.type;
            } else {
                t = (CakeRegistry.CakeType)CakeRegistry.INSTANCE.getBlockTypeOf((ItemLike)block);
            }
            if (t == null || !((item = stack.m_41720_()) instanceof BlockItem) || CakeRegistry.INSTANCE.getBlockTypeOf((ItemLike)(bi = (BlockItem)item).m_40614_()) != t) {
                return InteractionResult.PASS;
            }
            Block doubleCake = t.getBlockOfThis("double_cake");
            return InteractEventOverrideHandler.replaceSimilarBlock(doubleCake, player, stack, pos, level, state, null, new Property[]{DoubleCakeBlock.FACING});
        }
        return InteractionResult.PASS;
    }
}

