/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdventurerMapsHandler {
    public static final int SEARCH_RADIUS = 150;

    public static ItemStack createMapOrQuill(ServerLevel serverLevel, BlockPos pos, @Nullable HolderSet<Structure> targets, int radius, boolean skipKnown, int zoom, @Nullable ResourceLocation mapMarker, @Nullable String name, int color) {
        StructureLocator.LocatedStruct found;
        if (CompatHandler.QUARK && CommonConfigs.Tweaks.QUARK_QUILL.get().booleanValue()) {
            ItemStack item = QuarkCompat.makeAdventurerQuill(serverLevel, targets, radius, skipKnown, zoom, null, name, color);
            item.m_41714_((Component)Component.m_237115_((String)name));
            return item;
        }
        if (!serverLevel.m_7654_().m_129910_().m_246337_().m_247749_()) {
            return ItemStack.f_41583_;
        }
        if (targets == null && (targets = (HolderSet)serverLevel.m_9598_().m_175515_(Registries.f_256944_).m_203431_(ModTags.ADVENTURE_MAP_DESTINATIONS).orElse(null)) == null) {
            targets = HolderSet.m_205809_((Holder[])new Holder[0]);
        }
        if ((found = StructureLocator.findNearestRandomMapFeature(serverLevel, targets, pos, radius, skipKnown)) != null) {
            BlockPos toPos = found.pos();
            return AdventurerMapsHandler.createStructureMap(serverLevel, toPos, found.structure(), zoom, mapMarker, name, color);
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static ItemStack createStructureMap(ServerLevel level, BlockPos pos, Holder<Structure> structure, int zoom, @Nullable ResourceLocation decoration, @Nullable String name, int color) {
        ItemStack stack = MapItem.m_42886_((Level)level, (int)pos.m_123341_(), (int)pos.m_123343_(), (byte)((byte)zoom), (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)level, (ItemStack)stack);
        if (decoration == null) {
            MapDecorationType type = MapDataRegistry.getAssociatedType(structure);
            decoration = Utils.getID((MapDecorationType)type);
            if (color == 0) {
                color = type.getDefaultMapColor();
            }
        }
        MapHelper.addDecorationToMap((ItemStack)stack, (BlockPos)pos, (ResourceLocation)decoration, (int)color);
        if (name != null) {
            stack.m_41714_((Component)Component.m_237115_((String)name));
        }
        return stack;
    }

    public static ItemStack createCustomMapForTrade(Level level, BlockPos pos, ResourceLocation structureName, @Nullable String mapName, int mapColor, @Nullable ResourceLocation mapMarker) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TagKey destination = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureName);
            String name = mapName == null ? "filled_map." + structureName.m_135815_().toLowerCase(Locale.ROOT) : mapName;
            HolderSet.Named targets = serverLevel.m_9598_().m_175515_(Registries.f_256944_).m_203431_(destination).orElse(null);
            if (targets != null) {
                return AdventurerMapsHandler.createMapOrQuill(serverLevel, pos, (HolderSet<Structure>)targets, 150, true, 2, mapMarker, name, mapColor);
            }
        }
        return ItemStack.f_41583_;
    }
}

