/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.SpriteCoordinateUnExpander;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.EnchantRedesignCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BookPileBlockTile
extends ItemDisplayTile
implements IExtraModelDataProvider {
    public final boolean horizontal;
    private float enchantPower = 0.0f;
    public final BooksList books = new BooksList();
    public static final ModelDataKey<BooksList> BOOKS_KEY = ModBlockProperties.BOOKS_KEY;
    private static final RandomSource rand = RandomSource.m_216327_();
    public static final List<BookColor> DEFAULT_COLORS = List.of(BookColor.BROWN, BookColor.ORANGE, BookColor.YELLOW, BookColor.RED, BookColor.DARK_GREEN, BookColor.LIME, BookColor.TEAL, BookColor.BLUE, BookColor.PURPLE);

    public BookPileBlockTile(BlockPos pos, BlockState state) {
        this(pos, state, false);
    }

    public BookPileBlockTile(BlockPos pos, BlockState state, boolean horizontal) {
        super(ModRegistry.BOOK_PILE_TILE.get(), pos, state, 4);
        this.horizontal = horizontal;
    }

    public ExtraModelData getExtraModelData() {
        return ExtraModelData.builder().with(BOOKS_KEY, (Object)this.books).build();
    }

    private void makeRandomBook(int i) {
        for (int j = 0; j < i; ++j) {
            int r = rand.m_188503_(10);
            Item it = r < 3 ? Items.f_42690_ : (r < 4 ? Items.f_42614_ : Items.f_42517_);
            ArrayList<BookColor> col = new ArrayList<BookColor>(List.of(BookColor.values()));
            this.books.add(new VisualBook(it.m_7968_(), this.f_58858_, j, col, null));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128350_("EnchantPower", this.enchantPower);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.enchantPower = compound.m_128457_("EnchantPower");
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.requestModelReload();
        }
    }

    public void updateTileOnInventoryChanged() {
        int b = (int)this.m_7086_().stream().filter(i -> !i.m_41619_()).count();
        if (b != (Integer)this.m_58900_().m_61143_((Property)BookPileBlock.BOOKS)) {
            if (b == 0) {
                this.f_58857_.m_7471_(this.f_58858_, false);
            } else {
                this.consolidateBookPile();
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BookPileBlock.BOOKS, (Comparable)Integer.valueOf(b)), 2);
            }
        }
        this.enchantPower = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            Item item = this.m_8020_(i2).m_41720_();
            if (BookPileBlock.isNormalBook(item)) {
                this.enchantPower = (float)((double)this.enchantPower + CommonConfigs.Tweaks.BOOK_POWER.get() / 4.0);
                continue;
            }
            if (BookPileBlock.isQuarkTome(item)) {
                this.enchantPower = (float)((double)this.enchantPower + CommonConfigs.Tweaks.BOOK_POWER.get() / 4.0 * 2.0);
                continue;
            }
            if (!BookPileBlock.isEnchantedBook(item)) continue;
            this.enchantPower = (float)((double)this.enchantPower + CommonConfigs.Tweaks.ENCHANTED_BOOK_POWER.get() / 4.0);
        }
    }

    private void consolidateBookPile() {
        boolean prevEmpty = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack it = this.m_8020_(i);
            if (it.m_41619_()) {
                prevEmpty = true;
                continue;
            }
            if (!prevEmpty) continue;
            this.m_7086_().set(i - 1, (Object)it);
            this.m_7086_().set(i, (Object)ItemStack.f_41583_);
        }
    }

    public void updateClientVisualsOnLoad() {
        ItemStack stack;
        this.books.clear();
        ArrayList<BookColor> colors = new ArrayList<BookColor>((Collection)ClientConfigs.Tweaks.BOOK_COLORS.get());
        for (int i = 0; i < 4 && !(stack = this.m_8020_(i)).m_41619_(); ++i) {
            BookColor last = i == 0 ? null : this.books.get((int)(i - 1)).color;
            this.books.add(i, new VisualBook(stack, this.f_58858_, i, colors, last));
        }
        if (this.books.isEmpty()) {
            this.makeRandomBook((Integer)this.m_58900_().m_61143_((Property)BookPileBlock.BOOKS));
        }
    }

    public float getEnchantPower() {
        return this.enchantPower;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.supplementaries.book_pile");
    }

    public static class BooksList {
        private final List<VisualBook> list = new ArrayList<VisualBook>();

        public void add(VisualBook visualBook) {
            this.list.add(visualBook);
        }

        public void add(int i, VisualBook visualBook) {
            this.list.add(i, visualBook);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public void clear() {
            this.list.clear();
        }

        public VisualBook get(int i) {
            return this.list.get(i);
        }

        public int size() {
            return this.list.size();
        }
    }

    public static enum BookColor implements StringRepresentable
    {
        BROWN(DyeColor.BROWN, 1.0f),
        WHITE(DyeColor.WHITE, 1.0f),
        BLACK(DyeColor.BLACK, 1.0f),
        LIGHT_GRAY(DyeColor.LIGHT_GRAY),
        GRAY(DyeColor.GRAY),
        ORANGE(DyeColor.ORANGE),
        YELLOW(DyeColor.YELLOW),
        LIME(DyeColor.LIME),
        DARK_GREEN("green", 3129655),
        TEAL("cyan", 1502399),
        LIGHT_BLUE(DyeColor.LIGHT_BLUE),
        BLUE(DyeColor.BLUE),
        PURPLE(DyeColor.PURPLE),
        MAGENTA(DyeColor.MAGENTA),
        PINK(DyeColor.PINK),
        RED(DyeColor.RED),
        ENCHANTED("enchanted", 0, 1.0f),
        AND_QUILL("and_quill", 0, 1.0f),
        WRITTEN("written", 0, 1.0f),
        TOME("tome", 0, 1.0f),
        TATTERED("tattered", 0, 1.0f),
        GENE("gene", 0, 1.0f);

        private final String name;
        private final float hue;
        private final float angle;
        public static final Codec<BookColor> CODEC;

        private BookColor(String s, int rgb, float angle) {
            this.name = s;
            HSLColor col = new RGBColor(rgb).asHSL();
            this.hue = col.hue();
            this.angle = angle < 0.0f ? this.getAllowedHueShift(col) : Math.max(1.0f, angle);
        }

        private BookColor(DyeColor color, float angle) {
            this(color.m_41065_(), ColorHelper.pack(color.m_41068_()), angle);
        }

        private BookColor(String name, int color) {
            this(name, color, -1.0f);
        }

        private BookColor(DyeColor color) {
            this(color.m_41065_(), ColorHelper.pack(color.m_41068_()), -1.0f);
        }

        public static BookColor byName(String name) {
            for (BookColor c : BookColor.values()) {
                if (!c.name.equals(name)) continue;
                return c;
            }
            return BROWN;
        }

        public boolean looksGoodNextTo(BookColor other) {
            float diff = Math.abs(Mth.m_14118_((float)(this.hue * 360.0f), (float)(other.hue * 360.0f)) / 360.0f);
            return diff < (other.angle + this.angle) / 2.0f;
        }

        private float getAllowedHueShift(HSLColor color) {
            float l = color.lightness();
            float s = ColorHelper.normalizeSaturation(color.saturation(), l);
            float minAngle = 0.25f;
            float addAngle = 0.18055555f;
            float distLightSq = 2.0f;
            float distDarkSq = s * s + l * l;
            float distSq = Math.min(1.0f, Math.min(distDarkSq, distLightSq));
            return minAngle + (1.0f - distSq) * addAngle;
        }

        public static BookColor rand(Random r) {
            return BookColor.values()[r.nextInt(BookColor.values().length)];
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.getName();
        }

        static {
            CODEC = StringRepresentable.m_216439_(BookColor::values);
        }
    }

    public static class VisualBook {
        private final float angle;
        @Nullable
        private final BookColor color;
        private final ItemStack stack;
        private final boolean isEnchanted;

        public VisualBook(ItemStack stack, BlockPos pos, int index, List<BookColor> colors, @Nullable BookColor lastColor) {
            this.stack = stack;
            Random rand = new Random(pos.m_121878_());
            for (int j = 0; j < index; ++j) {
                rand.nextInt();
            }
            Item item = stack.m_41720_();
            this.angle = (float)((double)rand.nextInt(32) * Math.PI / 16.0);
            if (item == CompatObjects.GENE_BOOK) {
                this.isEnchanted = false;
                this.color = BookColor.GENE;
            } else if (item instanceof BookItem) {
                if (lastColor == null) {
                    this.color = colors.get(rand.nextInt(colors.size()));
                } else {
                    List<BookColor> c = colors.stream().filter(b -> b.looksGoodNextTo(lastColor)).toList();
                    this.color = c.get(rand.nextInt(c.size()));
                }
                colors.remove((Object)this.color);
                this.isEnchanted = false;
            } else if (Utils.getID((Item)item).m_135827_().equals("inspirations")) {
                String colName = Utils.getID((Item)item).m_135815_().replace("_book", "");
                this.color = BookColor.byName(colName);
                this.isEnchanted = false;
            } else if (BookPileBlock.isWrittenBook(item)) {
                this.color = item instanceof WrittenBookItem ? (AntiqueInkItem.hasAntiqueInk(stack) ? BookColor.TATTERED : BookColor.WRITTEN) : BookColor.AND_QUILL;
                this.isEnchanted = false;
            } else {
                this.color = BookPileBlock.isQuarkTome(item) ? BookColor.TOME : BookColor.ENCHANTED;
                this.isEnchanted = true;
            }
        }

        public VertexConsumer getBuilder(MultiBufferSource buffer) {
            if (this.isEnchanted && ClientConfigs.Tweaks.BOOK_GLINT.get().booleanValue()) {
                VertexConsumer foilBuilder = null;
                if (CompatHandler.ENCHANTEDBOOKREDESIGN) {
                    foilBuilder = EnchantRedesignCompat.getBookColoredFoil(this.stack, buffer);
                }
                if (foilBuilder == null) {
                    foilBuilder = new SpriteCoordinateUnExpander(buffer.m_6299_(RenderType.m_110496_()), ModMaterials.BOOK_GLINT_MATERIAL.m_119204_());
                }
                return foilBuilder;
            }
            return null;
        }

        public float getAngle() {
            return this.angle;
        }

        public boolean isEnchanted() {
            return this.isEnchanted;
        }

        public BookColor getColor() {
            return this.color;
        }
    }
}

