/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockTarget;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.integration.FarmersRespriteCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

class KettleInteraction
implements IFaucetBlockSource,
IFaucetBlockTarget {
    KettleInteraction() {
    }

    @Override
    public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
        if (FarmersRespriteCompat.isKettle(state)) {
            IntegerProperty p = FarmersRespriteCompat.getWaterLevel();
            int waterLevel = (Integer)state.m_61143_((Property)p);
            if (waterLevel > 0) {
                FaucetBehaviorsManager.prepareToTransferBottle(faucetTank, (SoftFluid)BuiltInSoftFluids.WATER.get());
                if (fillAction == null) {
                    return InteractionResult.SUCCESS;
                }
                if (fillAction.tryExecute()) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)p, (Comparable)Integer.valueOf(waterLevel - 1)), 3);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
        SoftFluid softFluid;
        if (FarmersRespriteCompat.isKettle(state) && (softFluid = faucetTank.getFluid()) == BuiltInSoftFluids.WATER.get()) {
            IntegerProperty p = FarmersRespriteCompat.getWaterLevel();
            int levels = (Integer)state.m_61143_((Property)p);
            if (levels < 3) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)p, (Comparable)Integer.valueOf(levels + 1)), 3);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

