/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PulleyBlock
extends RotatedPillarBlock
implements EntityBlock,
IRotatable {
    public static final EnumProperty<ModBlockProperties.Winding> TYPE = ModBlockProperties.WINDING;
    public static final BooleanProperty FLIPPED = ModBlockProperties.FLIPPED;

    public PulleyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_(TYPE, (Comparable)((Object)ModBlockProperties.Winding.NONE))).m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE, FLIPPED});
    }

    public boolean windPulley(BlockState state, BlockPos pos, LevelAccessor world, Rotation rot, @Nullable Direction dir) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)f_55923_);
        if (axis == Direction.Axis.Y) {
            return false;
        }
        if (dir == null) {
            dir = axis == Direction.Axis.Z ? Direction.NORTH : Direction.WEST;
        }
        return this.rotateOverAxis(state, world, pos, rot, dir, null).isPresent();
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, Vec3 hit) {
        Direction.Axis targetAxis;
        Direction.Axis myAxis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
        if (myAxis == (targetAxis = axis.m_122434_())) {
            return Optional.of((BlockState)state.m_61122_((Property)FLIPPED));
        }
        if (myAxis == Direction.Axis.X) {
            return Optional.of((BlockState)state.m_61124_((Property)f_55923_, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y)));
        }
        if (myAxis == Direction.Axis.Z) {
            return Optional.of((BlockState)state.m_61124_((Property)f_55923_, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.X : Direction.Axis.Y)));
        }
        if (myAxis == Direction.Axis.Y) {
            return Optional.of((BlockState)state.m_61124_((Property)f_55923_, (Comparable)(targetAxis == Direction.Axis.Z ? Direction.Axis.X : Direction.Axis.Z)));
        }
        return Optional.of(state);
    }

    public void onRotated(BlockState newState, BlockState oldState, LevelAccessor world, BlockPos pos, Rotation originalRot, Direction axis, @Nullable Vec3 hit) {
        if (axis.m_122434_().m_122479_() && axis.m_122434_() == oldState.m_61143_((Property)f_55923_)) {
            BlockPos connectedPos;
            BlockState connected;
            Rotation rot = originalRot;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof PulleyBlockTile) {
                PulleyBlockTile pulley = (PulleyBlockTile)blockEntity;
                if (axis.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                    rot = rot.m_55952_(Rotation.CLOCKWISE_180);
                }
                pulley.rotateDirectly(rot);
            }
            if ((connected = world.m_8055_(connectedPos = pos.m_121945_(axis))).m_60713_((Block)this) && newState.m_61143_((Property)f_55923_) == connected.m_61143_((Property)f_55923_)) {
                this.windPulley(connected, connectedPos, world, originalRot, axis);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        PulleyBlockTile tile;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof PulleyBlockTile && (tile = (PulleyBlockTile)blockEntity).isAccessibleBy(player)) {
            if (!(!(player instanceof ServerPlayer) || player.m_6144_() && this.windPulley(state, pos, (LevelAccessor)worldIn, Rotation.COUNTERCLOCKWISE_90, null))) {
                player.m_5893_((MenuProvider)tile);
            }
            return InteractionResult.m_19078_((boolean)worldIn.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public MenuProvider m_7246_(BlockState state, Level blockEntity, BlockPos pos) {
        MenuProvider mp;
        BlockEntity tileEntity = blockEntity.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (mp = (MenuProvider)tileEntity) : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PulleyBlockTile(pPos, pState);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof Container) {
                Container tile = (Container)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)tile);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockUtil.addOptionalOwnership(placer, worldIn, pos);
    }
}

