/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.c2s;

import immersive_paintings.cobalt.network.Message;
import immersive_paintings.network.LazyNetworkManager;
import immersive_paintings.network.s2c.ImageResponse;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import immersive_paintings.util.Utils;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.util.TriConsumer;

public class ImageRequest
extends Message {
    private final String identifier;
    private final Painting.Type type;

    public ImageRequest(ResourceLocation identifier, Painting.Type type) {
        this.identifier = identifier.toString();
        this.type = type;
    }

    public ImageRequest(FriendlyByteBuf b) {
        this.identifier = b.m_130277_();
        this.type = (Painting.Type)b.m_130066_(Painting.Type.class);
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        b.m_130070_(this.identifier);
        b.m_130068_((Enum)this.type);
    }

    @Override
    public void receive(Player e) {
        ResourceLocation identifier = new ResourceLocation(this.identifier);
        Optional<byte[]> image = ServerPaintingManager.getImageData(identifier, this.type);
        image.ifPresent(i -> Utils.processByteArrayInChunks(i, (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(ints, split, splits) -> LazyNetworkManager.sendToClient(new ImageResponse(identifier, this.type, (byte[])ints, (int)split, (int)splits), (ServerPlayer)e))));
    }
}

