/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.registry.LithostitchedRegistries;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.TrueModifierPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public abstract class Modifier {
    public static final Codec<Modifier> CODEC = ExtraCodecs.m_184415_(() -> {
        Registry modifierRegistry = (Registry)BuiltInRegistries.f_257047_.m_7745_(LithostitchedRegistries.MODIFIER_TYPE.m_135782_());
        if (modifierRegistry == null) {
            throw new NullPointerException("Worldgen modifier registry does not exist yet!");
        }
        return modifierRegistry.m_194605_();
    }).dispatch(Modifier::codec, Function.identity());
    private final ModifierPredicate predicate;
    private final ModifierPhase phase;

    protected Modifier(ModifierPredicate modifierPredicate, ModifierPhase phase) {
        this.predicate = modifierPredicate;
        this.phase = phase;
    }

    public static <P extends Modifier> Products.P1<RecordCodecBuilder.Mu<P>, ModifierPredicate> addModifierFields(RecordCodecBuilder.Instance<P> codec) {
        return codec.group((App)ModifierPredicate.CODEC.fieldOf("predicate").orElse((Object)TrueModifierPredicate.INSTANCE).forGetter(Modifier::predicate));
    }

    public ModifierPredicate predicate() {
        return this.predicate;
    }

    public ModifierPhase phase() {
        return this.phase;
    }

    public abstract void applyModifier();

    public abstract Codec<? extends Modifier> codec();

    public static void applyModifiers(MinecraftServer server) {
        Registry modifiers = server.m_206579_().m_175515_(LithostitchedRegistries.WORLDGEN_MODIFIER);
        for (ModifierPhase phase : ModifierPhase.values()) {
            if (phase == ModifierPhase.NONE) continue;
            for (Modifier modifier2 : modifiers.m_123024_().filter(modifier -> modifier.phase() == phase).collect(Collectors.toSet())) {
                if (!modifier2.predicate().test()) continue;
                modifier2.applyModifier();
            }
        }
    }

    public static enum ModifierPhase implements StringRepresentable
    {
        NONE("none"),
        BEFORE_ALL("before_all"),
        ADD("add"),
        REMOVE("remove"),
        MODIFY("modify"),
        AFTER_ALL("after_all");

        private final String name;

        private ModifierPhase(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

