/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.access.StructurePoolAccess;
import dev.worldgen.lithostitched.mixin.common.StructureTemplatePoolAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class AddTemplatePoolElementsModifier
extends Modifier {
    public static final Codec<AddTemplatePoolElementsModifier> CODEC = RecordCodecBuilder.create(instance -> AddTemplatePoolElementsModifier.addModifierFields(instance).and(instance.group((App)ResourceLocation.f_135803_.fieldOf("template_pool").forGetter(AddTemplatePoolElementsModifier::rawTemplatePoolLocation), (App)Codec.mapPair((MapCodec)StructurePoolElement.f_210468_.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(AddTemplatePoolElementsModifier::elements), (App)RegistryOps.m_255175_((ResourceKey)Registries.f_256948_))).apply((Applicative)instance, AddTemplatePoolElementsModifier::new));
    private final ResourceKey<StructureTemplatePool> EMPTY_TEMPLATE_POOL = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("lithostitched", "empty"));
    private final ResourceLocation rawTemplatePoolLocation;
    private final Holder<StructureTemplatePool> templatePool;
    private final List<Pair<StructurePoolElement, Integer>> elements;

    public AddTemplatePoolElementsModifier(ModifierPredicate predicate, ResourceLocation rawTemplatePoolLocation, List<Pair<StructurePoolElement, Integer>> elements, HolderGetter<StructureTemplatePool> getter) {
        super(predicate, Modifier.ModifierPhase.ADD);
        this.rawTemplatePoolLocation = rawTemplatePoolLocation;
        Optional templatePoolEntry = getter.m_254902_(predicate.test() ? ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)rawTemplatePoolLocation) : this.EMPTY_TEMPLATE_POOL);
        this.templatePool = (Holder)templatePoolEntry.get();
        this.elements = elements;
    }

    public Holder<StructureTemplatePool> templatePool() {
        return this.templatePool;
    }

    public ResourceLocation rawTemplatePoolLocation() {
        return this.rawTemplatePoolLocation;
    }

    public List<Pair<StructurePoolElement, Integer>> elements() {
        return this.elements;
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }

    @Override
    public void applyModifier() {
        if (this.templatePool.m_203565_(this.EMPTY_TEMPLATE_POOL)) {
            return;
        }
        StructureTemplatePoolAccessor structurePoolAccessor = (StructureTemplatePoolAccessor)this.templatePool().m_203334_();
        ArrayList<Pair<StructurePoolElement, Integer>> originalElementCounts = new ArrayList<Pair<StructurePoolElement, Integer>>(structurePoolAccessor.getRawTemplates());
        originalElementCounts.addAll(this.elements());
        structurePoolAccessor.setRawTemplates(originalElementCounts);
        ObjectArrayList originalElements = new ObjectArrayList(structurePoolAccessor.getTemplates());
        ShufflingList lithostitchedPoolElements = new ShufflingList();
        for (Pair<StructurePoolElement, Integer> pair : this.elements()) {
            lithostitchedPoolElements.m_147929_((Object)((StructurePoolElement)pair.getFirst()), ((Integer)pair.getSecond()).intValue());
            StructurePoolElement structurePoolElement = (StructurePoolElement)pair.getFirst();
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                originalElements.add((Object)structurePoolElement);
            }
        }
        structurePoolAccessor.setTemplates((ObjectArrayList<StructurePoolElement>)originalElements);
        ((StructurePoolAccess)this.templatePool().m_203334_()).lithostitched$setStructurePoolElements((ShufflingList<StructurePoolElement>)lithostitchedPoolElements);
    }
}

