/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.StructureSetAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class AddStructureSetEntriesModifier
extends Modifier {
    public static final Codec<AddStructureSetEntriesModifier> CODEC = RecordCodecBuilder.create(instance -> AddStructureSetEntriesModifier.addModifierFields(instance).and(instance.group((App)ResourceLocation.f_135803_.fieldOf("structure_set").forGetter(AddStructureSetEntriesModifier::rawStructureSetLocation), (App)StructureSet.StructureSelectionEntry.f_210025_.listOf().fieldOf("entries").forGetter(AddStructureSetEntriesModifier::entries), (App)RegistryOps.m_255175_((ResourceKey)Registries.f_256998_))).apply((Applicative)instance, AddStructureSetEntriesModifier::new));
    private final ResourceKey<StructureSet> EMPTY_STRUCTURE_SET = ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)new ResourceLocation("lithostitched", "empty"));
    private final ResourceLocation rawStructureSetLocation;
    private final Holder<StructureSet> structureSet;
    private final List<StructureSet.StructureSelectionEntry> entries;

    public AddStructureSetEntriesModifier(ModifierPredicate predicate, ResourceLocation rawStructureSetLocation, List<StructureSet.StructureSelectionEntry> entries, HolderGetter<StructureSet> getter) {
        super(predicate, Modifier.ModifierPhase.ADD);
        this.rawStructureSetLocation = rawStructureSetLocation;
        Optional structureSetEntry = getter.m_254902_(predicate.test() ? ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)rawStructureSetLocation) : this.EMPTY_STRUCTURE_SET);
        this.structureSet = (Holder)structureSetEntry.get();
        this.entries = entries;
    }

    public ResourceLocation rawStructureSetLocation() {
        return this.rawStructureSetLocation;
    }

    public Holder<StructureSet> structureSet() {
        return this.structureSet;
    }

    public List<StructureSet.StructureSelectionEntry> entries() {
        return this.entries;
    }

    @Override
    public void applyModifier() {
        if (this.structureSet.m_203565_(this.EMPTY_STRUCTURE_SET)) {
            return;
        }
        StructureSetAccessor structureSetAccessor = (StructureSetAccessor)this.structureSet().m_203334_();
        ArrayList<StructureSet.StructureSelectionEntry> structureSelectionEntries = new ArrayList<StructureSet.StructureSelectionEntry>(((StructureSet)this.structureSet().m_203334_()).f_210003_());
        structureSelectionEntries.addAll(this.entries());
        structureSetAccessor.setStructures(structureSelectionEntries);
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }
}

