/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.witherstormmod.common.capability.PlayerWitherStormData;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.util.CachedLevel;

public class WorldUtil {
    public static <T extends Entity> List<T> getPerformantEntitiesOfClass(ServerLevel world, Class<T> clazz, AABB box, @Nullable Predicate<? super T> predicate) {
        return world.m_6443_(clazz, box, predicate);
    }

    public static <T extends Entity> List<T> getPerformantEntitiesOfClass(ServerLevel world, Class<T> clazz, AABB box) {
        return WorldUtil.getPerformantEntitiesOfClass(world, clazz, box, EntitySelector.f_20408_);
    }

    public static List<BlockEntity> getBlockEntitiesInAABB(Level world, AABB box) {
        ArrayList<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        ChunkSource source = world.m_7726_();
        for (int x = Mth.m_14107_((double)(box.f_82288_ / 16.0)); x < Mth.m_14165_((double)(box.f_82291_ / 16.0)); ++x) {
            for (int z = Mth.m_14107_((double)(box.f_82290_ / 16.0)); z < Mth.m_14165_((double)(box.f_82293_ / 16.0)); ++z) {
                LevelChunk chunk = source.m_62227_(x, z, false);
                if (chunk == null) continue;
                for (BlockPos pos : chunk.m_5928_()) {
                    if (!box.m_82390_(Vec3.m_82539_((Vec3i)pos))) continue;
                    blockEntities.add(chunk.m_7702_(pos));
                }
            }
        }
        return blockEntities;
    }

    @Nullable
    public static <T> T getNearest(List<T> objects, Vec3 center, Function<T, Vec3> toVec) {
        double distance = -1.0;
        T toReturn = null;
        for (T t : objects) {
            Vec3 vec = toVec.apply(t);
            double d0 = vec.m_82557_(center);
            if (distance != -1.0 && !(d0 < distance)) continue;
            distance = d0;
            toReturn = t;
        }
        return toReturn;
    }

    public static List<WitherStormEntity> getAllStorms(ServerLevel level) {
        return Lists.newArrayList((Iterable)level.m_8583_()).stream().filter(e -> e instanceof WitherStormEntity).collect(Collectors.mapping(e -> (WitherStormEntity)e, Collectors.toList()));
    }

    public static boolean checkForIntersect(AABB box, Vec3 start, Vec3 end) {
        double d1;
        double d0 = Double.MAX_VALUE;
        boolean flag = false;
        Optional optional = box.m_82371_(start, end);
        if (optional.isPresent() && (d1 = start.m_82557_((Vec3)optional.get())) < d0) {
            flag = true;
            d0 = d1;
        }
        if (box.m_82390_(start)) {
            flag = true;
        }
        return flag;
    }

    public static boolean areaLoaded(Level level, BlockPos center, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ChunkPos chunkPos = new ChunkPos(center);
                ChunkAccess chunk = level.m_6522_(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z, ChunkStatus.f_62326_, false);
                if (!(chunk instanceof LevelChunk)) {
                    return false;
                }
                FullChunkStatus type = ((LevelChunk)chunk).m_287138_();
                if (type.m_287205_(FullChunkStatus.BLOCK_TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isLoaded(Level level, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkAccess chunk = level.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false);
        if (!(chunk instanceof LevelChunk)) {
            return false;
        }
        FullChunkStatus type = ((LevelChunk)chunk).m_287138_();
        return type.m_287205_(FullChunkStatus.ENTITY_TICKING);
    }

    public static boolean isInAnOpenArea(Entity entity) {
        int radius = 5;
        Integer lowest = null;
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                int height = entity.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, entity.m_146903_() + x, entity.m_146907_() + z);
                if (lowest != null && lowest <= height) continue;
                lowest = height;
            }
        }
        return entity.m_20186_() >= (double)lowest.intValue() - 10.0;
    }

    public static boolean hasLineOfSight(Entity caster, Entity target) {
        return WorldUtil.raycast(caster, target, 300.0).m_6662_() == HitResult.Type.MISS;
    }

    public static boolean canSeeOrIsNotInASmallArea(Entity entity, Entity target) {
        PlayerWitherStormData data = (PlayerWitherStormData)target.getCapability(WitherStormModCapabilities.PLAYER_WITHER_STORM_DATA).orElse(null);
        if (data != null) {
            return data.isInAnOpenArea() || WorldUtil.hasLineOfSight(entity, target);
        }
        return WorldUtil.isInAnOpenArea(target) || WorldUtil.hasLineOfSight(entity, target);
    }

    public static List<BlockState> getBlockStatesBetweenClosed(Level level, BlockPos min, BlockPos max) {
        ArrayList states = Lists.newArrayList();
        CachedLevel cached = new CachedLevel(level);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            states.add(cached.getBlockState(pos));
        }
        cached.close();
        return states;
    }

    public static int getHeightStartingAt(Level level, int height, int x, int z) {
        BlockPos pos = new BlockPos(x, height, z);
        LevelChunk chunk = level.m_46745_(pos);
        while (pos.m_123342_() > level.m_141937_() && chunk.m_8055_(pos).m_60795_()) {
            pos = pos.m_7495_();
        }
        return pos.m_123342_();
    }

    public static int getCeilingStartingAt(Level level, int height, int x, int z) {
        CachedLevel cached = new CachedLevel(level);
        int y = WorldUtil.getCeilingStartingAt(cached, height, x, z);
        cached.close();
        return y;
    }

    public static int getCeilingStartingAt(CachedLevel level, int height, int x, int z) {
        BlockPos pos = new BlockPos(x, height, z);
        while (pos.m_123342_() < level.level().m_151558_() && level.getBlockState(pos).m_60795_()) {
            pos = pos.m_7494_();
        }
        return pos.m_123342_();
    }

    public static BlockHitResult raycast(Entity caster, Entity entity, double maxDist) {
        Vec3 pos = caster.m_146892_();
        Vec3 entityPos = entity.m_146892_();
        Vec3 delta = entityPos.m_82546_(pos);
        double dist = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82480_ * delta.f_82480_ + delta.f_82481_ * delta.f_82481_);
        delta = delta.m_82490_(dist > maxDist ? maxDist / dist : 1.0);
        Vec3 end = pos.m_82549_(delta);
        return caster.m_9236_().m_45547_(new ClipContext(pos, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, caster));
    }
}

