/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WitherStormModCompat {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean OPTIFINE_LOADED;
    private static boolean VIVECRAFT_LOADED;
    private static boolean hasErrored;

    public static void checkForLoaded() {
        try {
            Class.forName("net.optifine.Config");
            OPTIFINE_LOADED = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("org.vivecraft.settings.VRSettings");
            VIVECRAFT_LOADED = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean isShadersRunning() {
        try {
            if (WitherStormModCompat.isOculusLoaded()) {
                Class<?> clazz = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
                Method instanceGetter = clazz.getMethod("getInstance", new Class[0]);
                Object irisApi = instanceGetter.invoke(null, new Object[0]);
                return (Boolean)irisApi.getClass().getMethod("isShaderPackInUse", new Class[0]).invoke(irisApi, new Object[0]);
            }
            if (WitherStormModCompat.isOptifineLoaded()) {
                Class<?> clazz = Class.forName("net.optifine.Config");
                Method method = clazz.getMethod("isShaders", new Class[0]);
                return (Boolean)method.invoke(null, new Object[0]);
            }
            return false;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            if (!hasErrored) {
                LOGGER.error("Failed to check if shaders are running:");
                e.printStackTrace();
                hasErrored = true;
            }
            return false;
        }
    }

    public static boolean isVivecraftLoaded() {
        return VIVECRAFT_LOADED || ModList.get().isLoaded("vivecraft");
    }

    public static boolean isOculusLoaded() {
        return ModList.get().isLoaded("oculus");
    }

    public static boolean isOptifineLoaded() {
        return OPTIFINE_LOADED;
    }

    public static boolean isSodiumLoaded() {
        return ModList.get().isLoaded("rubidium");
    }
}

