/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import nonamecrackers2.witherstormmod.common.entity.BlockClusterEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModBlocks;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEntityTypes;

public class DeathClusterBuilder {
    private static final SimpleWeightedRandomList<Block> OUTSIDE = SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_FLESH_BLOCK.get()), 20).m_146271_((Object)((Block)WitherStormModBlocks.INFECTED_FLESH_BLOCK.get()), 3).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_PLANKS.get()), 1).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_COBBLESTONE.get()), 1).m_146270_();
    private static final SimpleWeightedRandomList<Block> BLOCKS = SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_FLESH_BLOCK.get()), 20).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_SAND.get()), 15).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_COBBLESTONE.get()), 10).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_STONE.get()), 10).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_PLANKS.get()), 8).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_LOG.get()), 5).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_LEAVES.get()), 2).m_146271_((Object)((Block)WitherStormModBlocks.INFECTED_FLESH_BLOCK.get()), 5).m_146270_();
    private static final SimpleWeightedRandomList<Block> DECORATION = SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_DUST.get()), 10).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_MUSHROOM.get()), 5).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_BONE_PILE.get()), 1).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_ZOMBIE_SITTING.get()), 1).m_146270_();

    public static BlockClusterEntity buildRandomDeathCluster(Level level, RandomSource random, int radius) {
        LinkedHashMap states = Maps.newLinkedHashMap();
        radius += random.m_188503_(2);
        float stretch = 3.0f;
        for (int i = 0; i <= 3; ++i) {
            float xStretch = stretch * Math.max(0.5f, random.m_188501_());
            float yStretch = stretch;
            float zStretch = stretch * Math.max(0.5f, random.m_188501_());
            int offsetR = radius - 1;
            BlockPos offset = new BlockPos(random.m_188503_(offsetR * 2) - offsetR, random.m_188503_(radius * 2) - radius, random.m_188503_(radius * 2) - radius);
            for (int x = -radius; x < radius; ++x) {
                for (int y = -radius; y < radius; ++y) {
                    for (int z = -radius; z < radius; ++z) {
                        int sqrt = Mth.m_14143_((float)Mth.m_14116_((float)((float)(x * x) * xStretch + 1.0f + ((float)(y * y) * yStretch + 1.0f) + ((float)(z * z) * zStretch + 1.0f))));
                        if (sqrt > radius) continue;
                        SimpleWeightedRandomList<Block> list = OUTSIDE;
                        if (sqrt < radius - 1) {
                            list = BLOCKS;
                        }
                        int randomY = random.m_188503_(2);
                        for (int l = -randomY; l <= randomY; ++l) {
                            BlockPos pos = new BlockPos(x, y - l, z).m_121955_((Vec3i)offset);
                            if (states.containsKey(pos)) continue;
                            BlockState state = list.m_216820_(random).orElse(Blocks.f_50016_).m_49966_();
                            states.put(pos, state);
                        }
                    }
                }
            }
        }
        HashMap toAdd = Maps.newHashMap();
        for (Map.Entry entry : states.entrySet()) {
            BlockPos above = ((BlockPos)entry.getKey()).m_7494_();
            if (states.containsKey(above) || random.m_188503_(3) != 0) continue;
            BlockState decoration = DECORATION.m_216820_(random).orElse(Blocks.f_50016_).m_49966_();
            toAdd.put(above, decoration);
        }
        toAdd.forEach(states::put);
        BlockClusterEntity cluster = (BlockClusterEntity)((EntityType)WitherStormModEntityTypes.BLOCK_CLUSTER.get()).m_20615_(level);
        cluster.populate(states);
        return cluster;
    }
}

