/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class UpdateWitherSicknessTrackerMessage
extends Message<UpdateWitherSicknessTrackerMessage> {
    private int id;
    private int requiredProximityTicks;
    private int applicationDelay;
    private int cureDelay;
    private int proximityTicksModifier;
    private int applicationDelayModifier;
    private int cureDelayModifier;
    private int proximityTicks;
    private int delayTicks;
    private int contacts;
    private int totalInfections;
    private int multiplierDecreaseTicks;
    private int multiplier;
    private int contactsDecreaseTicks;
    private int cureDelayTicks;
    private int totalCures;
    private boolean isBeingCured;
    private boolean isInfected;
    private boolean isNearStorm;
    private boolean isActuallyImmune;

    public UpdateWitherSicknessTrackerMessage(Entity entity) {
        super(true);
        this.id = entity.m_19879_();
        entity.getCapability(WitherStormModCapabilities.WITHER_SICKNESS_TRACKER).ifPresent(tracker -> {
            this.requiredProximityTicks = tracker.getRawRequiredProximityTicks();
            this.applicationDelay = tracker.getRawApplicationDelay();
            this.cureDelay = tracker.getRawCureDelay();
            this.proximityTicksModifier = tracker.getRequiredProximityTicksModifier();
            this.applicationDelayModifier = tracker.getApplicationDelayModifier();
            this.proximityTicks = tracker.getProximityTicks();
            this.delayTicks = tracker.getDelayTicks();
            this.contacts = tracker.getContacts();
            this.totalInfections = tracker.getTotalInfections();
            this.multiplierDecreaseTicks = tracker.getAmplifierDecreaseTicks();
            this.multiplier = tracker.getBaseMultiplier();
            this.contactsDecreaseTicks = tracker.getContactsDecreaseTicks();
            this.isInfected = tracker.isInfected();
            this.isNearStorm = tracker.isNearStorm();
            this.cureDelayModifier = tracker.getCureDelayModifier();
            this.cureDelayTicks = tracker.getCureDelayTicks();
            this.totalCures = tracker.getTotalCures();
            this.isBeingCured = tracker.isBeingCured();
            this.isActuallyImmune = tracker.isActuallyImmune();
        });
    }

    public UpdateWitherSicknessTrackerMessage() {
        super(false);
    }

    public int getId() {
        return this.id;
    }

    public int getProximityTicksModifier() {
        return this.proximityTicksModifier;
    }

    public int getApplicationDelayModifier() {
        return this.applicationDelayModifier;
    }

    public int getProximityTicks() {
        return this.proximityTicks;
    }

    public int getDelayTicks() {
        return this.delayTicks;
    }

    public int getContacts() {
        return this.contacts;
    }

    public int getTotalInfections() {
        return this.totalInfections;
    }

    public int getMultiplierDecreaseTicks() {
        return this.multiplierDecreaseTicks;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public int getContactsDecreaseTicks() {
        return this.contactsDecreaseTicks;
    }

    public boolean isInfected() {
        return this.isInfected;
    }

    public boolean isNearStorm() {
        return this.isNearStorm;
    }

    public int getCureDelayModifier() {
        return this.cureDelayModifier;
    }

    public int getCureDelayTicks() {
        return this.cureDelayTicks;
    }

    public int getTotalCures() {
        return this.totalCures;
    }

    public boolean isBeingCured() {
        return this.isBeingCured;
    }

    public int getRequiredProximityTicks() {
        return this.requiredProximityTicks;
    }

    public int getApplicationDelay() {
        return this.applicationDelay;
    }

    public int getCureDelay() {
        return this.cureDelay;
    }

    public boolean isActuallyImmune() {
        return this.isActuallyImmune;
    }

    @Override
    public void decode(UpdateWitherSicknessTrackerMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.id = buffer.m_130242_();
        message.requiredProximityTicks = buffer.m_130242_();
        message.applicationDelay = buffer.m_130242_();
        message.cureDelay = buffer.m_130242_();
        message.proximityTicksModifier = buffer.m_130242_();
        message.applicationDelayModifier = buffer.m_130242_();
        message.proximityTicks = buffer.m_130242_();
        message.delayTicks = buffer.m_130242_();
        message.contacts = buffer.m_130242_();
        message.totalInfections = buffer.m_130242_();
        message.multiplierDecreaseTicks = buffer.m_130242_();
        message.multiplier = buffer.m_130242_();
        message.contactsDecreaseTicks = buffer.m_130242_();
        message.isInfected = buffer.readBoolean();
        message.isNearStorm = buffer.readBoolean();
        message.cureDelayModifier = buffer.m_130242_();
        message.cureDelayTicks = buffer.m_130242_();
        message.totalCures = buffer.m_130242_();
        message.isBeingCured = buffer.readBoolean();
        message.isActuallyImmune = buffer.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130130_(this.id);
        buffer.m_130130_(this.requiredProximityTicks);
        buffer.m_130130_(this.applicationDelay);
        buffer.m_130130_(this.cureDelay);
        buffer.m_130130_(this.proximityTicksModifier);
        buffer.m_130130_(this.applicationDelayModifier);
        buffer.m_130130_(this.proximityTicks);
        buffer.m_130130_(this.delayTicks);
        buffer.m_130130_(this.contacts);
        buffer.m_130130_(this.totalInfections);
        buffer.m_130130_(this.multiplierDecreaseTicks);
        buffer.m_130130_(this.multiplier);
        buffer.m_130130_(this.contactsDecreaseTicks);
        buffer.writeBoolean(this.isInfected);
        buffer.writeBoolean(this.isNearStorm);
        buffer.m_130130_(this.cureDelayModifier);
        buffer.m_130130_(this.cureDelayTicks);
        buffer.m_130130_(this.totalCures);
        buffer.writeBoolean(this.isBeingCured);
        buffer.writeBoolean(this.isActuallyImmune);
    }

    @Override
    public Runnable getProcessor(UpdateWitherSicknessTrackerMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processUpdateWitherSicknessTrackerMessage(message));
    }

    public String toString() {
        return "UpdateWitherSicknessTrackerMessage[id=" + this.id + ", requiredProximityTicks" + this.requiredProximityTicks + ", applicationDelay" + this.applicationDelay + ", cureDelay" + this.cureDelay + ", proximityTicksModifier=" + String.valueOf(this.proximityTicksModifier) + ", applicationDelayModifier=" + String.valueOf(this.applicationDelayModifier) + ", proximityTicks=" + String.valueOf(this.proximityTicks) + ", delayTicks=" + String.valueOf(this.delayTicks) + ", contacts= " + String.valueOf(this.contacts) + ", totalInfections= " + String.valueOf(this.totalInfections) + ", multiplierDecreaseTicks= " + String.valueOf(this.multiplierDecreaseTicks) + ", multiplier= " + String.valueOf(this.multiplier) + ", contactsDecreaseTicks= " + String.valueOf(this.contactsDecreaseTicks) + ", isInfected=" + String.valueOf(this.isInfected) + ", isNearStorm=" + String.valueOf(this.isNearStorm) + ", cureDelayModifier=" + String.valueOf(this.cureDelayModifier) + ", cureDelayTicks=" + String.valueOf(this.cureDelayTicks) + ", totalCures=" + String.valueOf(this.totalCures) + ", isBeingCured=" + String.valueOf(this.isBeingCured) + ", isActuallyImmune" + String.valueOf(this.isActuallyImmune) + "]";
    }
}

