/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.packet.DistantRendererMessage;

public class UpdateStormHeadLookMessage
extends DistantRendererMessage<UpdateStormHeadLookMessage> {
    private int entityId;
    private byte yHeadRot;
    private byte[] xHeadsRot = new byte[2];
    private byte[] yHeadsRot = new byte[2];

    public UpdateStormHeadLookMessage(List<Integer> applicable, WitherStormEntity entity, byte yHeadRot, byte[] xHeadsRot, byte[] yHeadsRot) {
        super(true, applicable);
        this.entityId = entity.m_19879_();
        this.yHeadRot = yHeadRot;
        this.xHeadsRot = xHeadsRot;
        this.yHeadsRot = yHeadsRot;
    }

    public UpdateStormHeadLookMessage() {
        super(false, Lists.newArrayList());
    }

    public int getEntityID() {
        return this.entityId;
    }

    public byte getYRot() {
        return this.yHeadRot;
    }

    public byte[] getXHeadsRot() {
        return this.xHeadsRot;
    }

    public byte[] getYHeadsRot() {
        return this.yHeadsRot;
    }

    @Override
    public void decode(UpdateStormHeadLookMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        super.decode(message, buffer);
        message.entityId = buffer.m_130242_();
        message.yHeadRot = buffer.readByte();
        message.xHeadsRot = buffer.m_130052_();
        message.yHeadsRot = buffer.m_130052_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130130_(this.entityId);
        buffer.writeByte((int)this.yHeadRot);
        buffer.m_130087_(this.xHeadsRot);
        buffer.m_130087_(this.yHeadsRot);
    }

    @Override
    public Runnable getProcessor(UpdateStormHeadLookMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processUpdateStormHeadLookMessage(message));
    }

    public String toString() {
        return "UpdateStormHeadLookMessage[id=" + this.entityId + ", xHeadsRot=" + this.xHeadsRot + ", yHeadsRot=" + this.yHeadsRot + ", yHeadRot=" + this.yHeadRot + "]";
    }
}

