/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class UpdateDistantSuperBeaconMessage
extends Message<UpdateDistantSuperBeaconMessage> {
    private BlockPos pos;
    private int[] color;
    public boolean active;
    public int beaconHeight;
    public float beamWidth;
    public float outerBeamWidth;

    public UpdateDistantSuperBeaconMessage(BlockPos pos, int[] color, boolean active, int beaconHeight, float beamWidth, float outerBeamWidth) {
        super(true);
        this.pos = pos;
        this.color = color;
        this.active = active;
        this.beaconHeight = beaconHeight;
        this.beamWidth = beamWidth;
        this.outerBeamWidth = outerBeamWidth;
    }

    public UpdateDistantSuperBeaconMessage() {
        super(false);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int[] getColor() {
        return this.color;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getBeaconHeight() {
        return this.beaconHeight;
    }

    public float getBeamWidth() {
        return this.beamWidth;
    }

    public float getOuterBeamWidth() {
        return this.outerBeamWidth;
    }

    @Override
    public void decode(UpdateDistantSuperBeaconMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.pos = buffer.m_130135_();
        message.color = buffer.m_130100_();
        message.active = buffer.readBoolean();
        message.beaconHeight = buffer.readInt();
        message.beamWidth = buffer.readFloat();
        message.outerBeamWidth = buffer.readFloat();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130064_(this.pos);
        buffer.m_130089_(this.color);
        buffer.writeBoolean(this.active);
        buffer.writeInt(this.beaconHeight);
        buffer.writeFloat(this.beamWidth);
        buffer.writeFloat(this.outerBeamWidth);
    }

    @Override
    public Runnable getProcessor(UpdateDistantSuperBeaconMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processUpdateDistantSuperBeaconMessage(message));
    }
}

