/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class ShakeScreenMessage
extends Message<ShakeScreenMessage> {
    private float duration;
    private float power;

    public ShakeScreenMessage(float duration, float power) {
        super(true);
        this.duration = duration;
        this.power = power;
    }

    public ShakeScreenMessage() {
        super(false);
    }

    public float getDuration() {
        return this.duration;
    }

    public float getPower() {
        return this.power;
    }

    @Override
    public void decode(ShakeScreenMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.duration = buffer.readFloat();
        message.power = buffer.readFloat();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeFloat(this.duration);
        buffer.writeFloat(this.power);
    }

    @Override
    public Runnable getProcessor(ShakeScreenMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processShakeScreenMessage(message));
    }

    public String toString() {
        return "ShakeScreenMessage[duration=" + this.duration + ", power=" + this.power + "]";
    }
}

