/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class PlayerMotionMessage
extends Message<PlayerMotionMessage> {
    private Vec3 motion;

    public PlayerMotionMessage(Vec3 motion) {
        super(true);
        this.motion = motion;
    }

    public PlayerMotionMessage() {
        super(false);
    }

    public Vec3 getMotion() {
        return this.motion;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeDouble(this.motion.f_82479_);
        buffer.writeDouble(this.motion.f_82480_);
        buffer.writeDouble(this.motion.f_82481_);
    }

    @Override
    public void decode(PlayerMotionMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        message.motion = new Vec3(x, y, z);
    }

    @Override
    public Runnable getProcessor(PlayerMotionMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processPlayerMotionMessage(message));
    }

    public String toString() {
        return "PlayerMotionMessageToClient[motion=" + String.valueOf(this.motion) + "]";
    }
}

