/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Message<T extends Message<T>> {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected boolean isMessageValid;

    protected Message(boolean valid) {
        this.isMessageValid = valid;
    }

    public boolean isMessageValid() {
        return this.isMessageValid;
    }

    public static <T extends Message<T>> T decode(Supplier<T> blank, FriendlyByteBuf buffer) {
        Message message = (Message)blank.get();
        try {
            message.decode(message, buffer);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            LOGGER.warn("Exception while reading " + message.toString() + "; " + e);
            return (T)message;
        }
        message.isMessageValid = true;
        return (T)message;
    }

    public void encode(FriendlyByteBuf buffer) {
        if (!this.isMessageValid) {
            return;
        }
    }

    public abstract void decode(T var1, FriendlyByteBuf var2) throws IllegalArgumentException, IndexOutOfBoundsException;

    public abstract Runnable getProcessor(T var1, NetworkEvent.Context var2);
}

