/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class FormidibombExplosionMessage
extends Message<FormidibombExplosionMessage> {
    private int entityId;
    private double x;
    private double y;
    private double z;
    private byte radius;
    private byte squish;

    public FormidibombExplosionMessage(@Nullable Entity entity, double x, double y, double z, int radius, int squish) {
        super(true);
        if (entity != null) {
            this.entityId = entity.m_19879_();
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = (byte)radius;
        this.squish = (byte)squish;
    }

    public FormidibombExplosionMessage() {
        super(false);
    }

    public int getId() {
        return this.entityId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getSquish() {
        return this.squish;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeInt(this.entityId);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeByte((int)this.radius);
        buffer.writeByte((int)this.squish);
    }

    @Override
    public void decode(FormidibombExplosionMessage blank, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        blank.entityId = buffer.readInt();
        blank.x = buffer.readDouble();
        blank.y = buffer.readDouble();
        blank.z = buffer.readDouble();
        blank.radius = buffer.readByte();
        blank.squish = buffer.readByte();
    }

    @Override
    public Runnable getProcessor(FormidibombExplosionMessage message, NetworkEvent.Context contextt) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processFormidibombExplosionMessage(message));
    }

    public String toString() {
        return "FormidibombExplosionMessage[id=" + this.entityId + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", radius=" + this.radius + ", squish=" + this.squish + "]";
    }
}

