/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class BlindScreenMessage
extends Message<BlindScreenMessage> {
    private int duration;
    private int fadeInDuration;
    private int fadeOutDuration;

    public BlindScreenMessage(int duration, int fadeInDuration, int fadeOutDuration) {
        super(true);
        this.duration = duration;
        this.fadeInDuration = fadeInDuration;
        this.fadeOutDuration = fadeOutDuration;
    }

    public BlindScreenMessage() {
        super(false);
    }

    public int getDuration() {
        return this.duration;
    }

    public int getFadeInDuration() {
        return this.fadeInDuration;
    }

    public int getFadeOutDuration() {
        return this.fadeOutDuration;
    }

    @Override
    public void decode(BlindScreenMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.duration = buffer.readInt();
        message.fadeInDuration = buffer.readInt();
        message.fadeOutDuration = buffer.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeInt(this.duration);
        buffer.writeInt(this.fadeInDuration);
        buffer.writeInt(this.fadeOutDuration);
    }

    @Override
    public Runnable getProcessor(BlindScreenMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processBlindScreenMessage(message));
    }
}

