/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.event;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModPacketHandlers;
import nonamecrackers2.witherstormmod.common.packet.CreateLoopingSoundMessage;

public class WitherStormSoundLoopingManagerUpdater {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        WitherStormSoundLoopingManagerUpdater.sendInformationToManager((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onChangedDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        WitherStormSoundLoopingManagerUpdater.sendInformationToManager((ServerPlayer)event.getEntity());
    }

    public static void sendInformationToManager(ServerPlayer player) {
        ServerLevel world = (ServerLevel)player.m_9236_();
        for (Entity entity : world.m_8583_()) {
            WitherStormEntity storm;
            if (!(entity instanceof WitherStormEntity) || !(storm = (WitherStormEntity)entity).shouldPlaySoundLoops()) continue;
            CreateLoopingSoundMessage loopingSoundMessage = new CreateLoopingSoundMessage(storm);
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)loopingSoundMessage);
        }
    }
}

