/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.event;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.AbstractSickenedEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherSickened;
import nonamecrackers2.witherstormmod.common.init.SickenedConversionRegistry;
import nonamecrackers2.witherstormmod.common.init.WitherStormModDamageTypes;

public class EntityConversionEvents {
    @SubscribeEvent
    public static <T extends Mob> void onLivingDeath(LivingDeathEvent event) {
        DamageSource source;
        Level world = event.getEntity().m_9236_();
        if (!world.f_46443_ && ((Boolean)WitherStormModConfig.SERVER.sickenedMobConversions.get()).booleanValue() && (source = event.getSource()).m_276093_(WitherStormModDamageTypes.WITHER_SICKNESS)) {
            LivingEntity living = event.getEntity();
            EntityType<? extends AbstractSickenedEntity> toDeprecated = AbstractSickenedEntity.getConversion(living.m_6095_());
            if (living instanceof Mob) {
                Mob mob = (Mob)living;
                if (toDeprecated != null) {
                    CompoundTag data = mob.serializeNBT();
                    EntityType original = mob.m_6095_();
                    AbstractSickenedEntity conversion = (AbstractSickenedEntity)mob.m_21406_(toDeprecated, true);
                    conversion.setOriginal(original, data);
                    conversion.convertFrom(mob);
                    event.setCanceled(true);
                } else {
                    EntityType to = SickenedConversionRegistry.getConversion(living.m_6095_());
                    if (to != null) {
                        CompoundTag data = mob.serializeNBT();
                        EntityType original = mob.m_6095_();
                        Mob conversion = mob.m_21406_(to, true);
                        ((WitherSickened)conversion).getData().setOriginal(original, data);
                        ((WitherSickened)conversion).convertFrom(mob);
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

