/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity.goal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import nonamecrackers2.witherstormmod.common.capability.WitherSicknessTracker;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModAttributes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.tags.WitherStormModEntityTags;
import nonamecrackers2.witherstormmod.common.util.WorldUtil;

public class AdditionalHeadTargetGoal<T extends LivingEntity>
extends TargetGoal {
    private final WitherStormEntity storm;
    private final int head;
    private final Class<T> targetType;
    private final int randomInterval;
    @Nullable
    private LivingEntity target;
    private final TargetingConditions targetConditions;
    private int unseenTicks;
    @Nullable
    private Vec3 lastTargetPos;

    public AdditionalHeadTargetGoal(WitherStormEntity entity, int head, Class<T> targetType, int interval, boolean mustSee, boolean mustReach, Predicate<LivingEntity> conditions) {
        super((Mob)entity, mustSee, mustReach);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.storm = entity;
        this.head = head;
        this.targetType = targetType;
        this.randomInterval = interval;
        this.targetConditions = TargetingConditions.m_148352_().m_26888_(conditions).m_148355_();
    }

    public boolean m_8036_() {
        if (this.randomInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    public boolean m_8045_() {
        LivingEntity entity = this.storm.getAlternativeTarget(this.head);
        if (entity == null) {
            entity = this.f_26137_;
        }
        if (entity != null) {
            if (!entity.m_6084_()) {
                return false;
            }
            Team team = this.f_26135_.m_5647_();
            Team team1 = entity.m_5647_();
            if (team != null && team1 == team) {
                return false;
            }
            double d0 = this.m_7623_();
            if (this.f_26135_.m_20280_((Entity)entity) > d0 * d0) {
                return false;
            }
            if (this.f_26136_) {
                int unseenMemoryTicks = 20;
                if (this.storm.canSee(this.head, (Entity)entity)) {
                    this.unseenTicks = 0;
                } else if (++this.unseenTicks > unseenMemoryTicks) {
                    return false;
                }
            }
            if (entity instanceof Player && ((Player)entity).m_150110_().f_35934_) {
                return false;
            }
            if (this.storm.getPhase() > 3 && this.storm.isEntityBehindBack((Entity)entity)) {
                return false;
            }
            if (!entity.m_9236_().m_46472_().equals((Object)this.storm.m_9236_().m_46472_())) {
                return false;
            }
            if (this.lastTargetPos != null && entity.m_20182_().m_82554_(this.lastTargetPos) > 20.0) {
                return false;
            }
            this.lastTargetPos = entity.m_20182_();
            this.setAlternativeTarget(entity);
            return true;
        }
        return false;
    }

    private void findTarget() {
        this.target = this.findApplicableTarget();
        if (this.target != null) {
            this.target.getCapability(WitherStormModCapabilities.WITHER_SICKNESS_TRACKER).ifPresent(WitherSicknessTracker::countContact);
        }
    }

    private AABB getTargetSearchArea(double range) {
        return this.storm.getPhase() > 3 ? this.f_26135_.m_20191_().m_82377_(range, range + 50.0, range) : this.f_26135_.m_20191_().m_82377_(range, range * 2.0, range);
    }

    private T findApplicableTarget() {
        double range = this.storm.getPhase() > 3 ? this.f_26135_.m_21133_(Attributes.f_22277_) : this.f_26135_.m_21133_((Attribute)WitherStormModAttributes.HUNCHBACK_FOLLOW_RANGE.get());
        List<LivingEntity> nearbyEntities = WorldUtil.getPerformantEntitiesOfClass((ServerLevel)this.f_26135_.m_9236_(), this.targetType, this.getTargetSearchArea(range));
        ArrayList<LivingEntity> entitiesToSort = new ArrayList<LivingEntity>();
        for (LivingEntity entity : nearbyEntities) {
            if (!this.storm.targetApplicable(this.targetType, entity, this.head)) continue;
            entitiesToSort.add(entity);
        }
        double d0 = -1.0;
        LivingEntity t = null;
        for (int i = 0; i < 10 && !entitiesToSort.isEmpty(); ++i) {
            double random;
            LivingEntity t1 = (LivingEntity)entitiesToSort.get(this.storm.m_217043_().m_188503_(entitiesToSort.size()));
            if (!this.targetConditions.m_26885_((LivingEntity)this.f_26135_, t1) || !this.storm.canSee(this.head, (Entity)t1)) continue;
            double d1 = t1.m_20275_(this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
            if (d0 == -1.0 || d1 < d0) {
                d0 = d1;
                t = t1;
            }
            if (!((Boolean)WitherStormModConfig.COMMON.playerFavorability.get()).booleanValue() || !this.storm.getPlayingJukeboxes().isEmpty() || !t1.m_6095_().m_204039_(WitherStormModEntityTags.FAVOURABLE_MOBS) || !((random = (double)this.storm.m_217043_().m_188503_(10)) <= (double)((Integer)WitherStormModConfig.SERVER.playerPickupChance.get()).intValue())) continue;
            t = t1;
            break;
        }
        return (T)t;
    }

    public void m_8056_() {
        this.setAlternativeTarget(this.target);
        super.m_8056_();
        this.unseenTicks = 0;
        this.lastTargetPos = null;
    }

    public void m_8041_() {
        this.setAlternativeTarget(null);
        this.target = null;
    }

    protected double m_7623_() {
        return this.f_26135_.m_21133_(Attributes.f_22277_) + 100.0;
    }

    private void setAlternativeTarget(@Nullable LivingEntity entity) {
        this.storm.setAlternativeTarget(this.head, entity);
    }
}

