/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity.ai.witherstorm.head;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormSegmentEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModSoundEvents;
import nonamecrackers2.witherstormmod.common.serializer.WitherStormModDataSerializers;
import nonamecrackers2.witherstormmod.common.util.HeadConfiguration;

public class HeadManager {
    private static final EntityDataAccessor<Optional<Vec3>> TARGET_A = WitherStormEntity.registerDataAccessor(WitherStormModDataSerializers.OPTIONAL_VECTOR_3D, Optional::empty);
    private static final EntityDataAccessor<Optional<Vec3>> TARGET_B = WitherStormEntity.registerDataAccessor(WitherStormModDataSerializers.OPTIONAL_VECTOR_3D, Optional::empty);
    private static final EntityDataAccessor<Optional<Vec3>> TARGET_C = WitherStormEntity.registerDataAccessor(WitherStormModDataSerializers.OPTIONAL_VECTOR_3D, Optional::empty);
    private static final EntityDataAccessor<Integer> LOOK_STEPS = WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135028_, () -> 3);
    private static final EntityDataAccessor<Boolean> CAN_ROAR_A = WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135035_, () -> false);
    private static final EntityDataAccessor<Boolean> CAN_ROAR_B = WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135035_, () -> false);
    private static final EntityDataAccessor<Boolean> CAN_ROAR_C = WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135035_, () -> false);
    private static final EntityDataAccessor<Boolean> CAN_BITE_A = WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135035_, () -> false);
    private static final EntityDataAccessor<Boolean> CAN_BITE_B = WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135035_, () -> false);
    private static final EntityDataAccessor<Boolean> CAN_BITE_C = WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135035_, () -> false);
    private static final EntityDataAccessor<Boolean> OTHER_HEADS_DISABLED = WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135035_, () -> false);
    public static final List<EntityDataAccessor<Boolean>> HEAD_ROARS = ImmutableList.of(CAN_ROAR_A, CAN_ROAR_B, CAN_ROAR_C);
    public static final List<EntityDataAccessor<Boolean>> HEADS_BITING = ImmutableList.of(CAN_BITE_A, CAN_BITE_B, CAN_BITE_C);
    public static final List<EntityDataAccessor<Optional<Vec3>>> TARGETS = ImmutableList.of(TARGET_A, TARGET_B, TARGET_C);
    private final List<HeadConfiguration> configurations;
    private LivingEntity[] targets = new LivingEntity[]{null, null, null};
    private Vec3[] distractedPositions = new Vec3[]{null, null, null};
    public final float[] xRotHeads = new float[2];
    public final float[] yRotHeads = new float[2];
    public final float[] xRotOHeads = new float[2];
    public final float[] yRotOHeads = new float[2];
    protected final float[] lerpXRotHeads = new float[3];
    protected final float[] lerpYRotHeads = new float[3];
    protected final float[] lerpXRotHeadsSteps = new float[3];
    protected final float[] lerpYRotHeadsSteps = new float[3];
    protected final float[] mouthAnim = new float[3];
    protected final float[] mouthAnimO = new float[3];
    protected final float[] jawBrokenAnimation = new float[3];
    protected final float[] jawBrokenAnimationO = new float[3];
    public final int[] distractedTime = new int[3];
    protected Vec3[] headPos = new Vec3[]{Vec3.f_82478_, Vec3.f_82478_, Vec3.f_82478_};
    protected Vec3[] headPosO = new Vec3[]{Vec3.f_82478_, Vec3.f_82478_, Vec3.f_82478_};
    public final int[] nextHeadUpdate = new int[2];
    public final int[] idleHeadUpdates = new int[2];
    public final int[] nextClusterPickup = new int[3];
    public final int[] idleClusterPickup = new int[3];
    public int[] nextRoarTick = new int[3];
    public int[] roarTicks = new int[3];
    public int[] biteTicks = new int[3];
    private double[] tractorBeamCutoffDistances = new double[]{-1.0, -1.0, -1.0};
    private final WitherStormEntity storm;

    public HeadManager(WitherStormEntity storm, List<HeadConfiguration> configurations) {
        this.storm = storm;
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException("Head configurations cannot be empty!");
        }
        this.configurations = configurations;
    }

    public void baseTick() {
        for (int i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotHeads[i];
            this.xRotOHeads[i] = this.xRotHeads[i];
        }
        this.headPosO = this.headPos;
    }

    public void tick() {
        int i;
        for (i = 0; i < 3; ++i) {
            this.mouthAnimO[i] = this.mouthAnim[i];
            if (!this.isBiting(i) && this.getCanRoar(i)) {
                int n = i;
                this.mouthAnim[n] = this.mouthAnim[n] + ((1.0f - this.mouthAnim[i]) * 0.15f + 0.04f);
                if (this.mouthAnim[i] > 2.0f) {
                    this.mouthAnim[i] = 2.0f;
                }
            } else if (this.isBiting(i)) {
                int n = i;
                this.mouthAnim[n] = this.mouthAnim[n] + ((1.0f - this.mouthAnim[i]) * 0.16f + 0.1f);
                if (this.mouthAnim[i] > 1.4f) {
                    this.mouthAnim[i] = 1.4f;
                }
            } else {
                int n = i;
                this.mouthAnim[n] = this.mouthAnim[n] + (-this.mouthAnim[i] * 0.16f - 0.02f);
                if (this.mouthAnim[i] < 0.0f) {
                    this.mouthAnim[i] = 0.0f;
                }
            }
            this.jawBrokenAnimationO[i] = this.jawBrokenAnimation[i];
            if (this.storm.m_20096_() && this.storm.isDeadOrPlayingDead()) {
                int n = i;
                this.jawBrokenAnimation[n] = this.jawBrokenAnimation[n] + ((1.0f - this.jawBrokenAnimation[i]) * 0.2f + 0.05f);
                if (!(this.jawBrokenAnimation[i] > 1.5f)) continue;
                this.jawBrokenAnimation[i] = 1.5f;
                continue;
            }
            int n = i;
            this.jawBrokenAnimation[n] = this.jawBrokenAnimation[n] + (-this.jawBrokenAnimation[i] * 0.2f - 0.05f);
            if (!(this.jawBrokenAnimation[i] < 0.0f)) continue;
            this.jawBrokenAnimation[i] = 0.0f;
        }
        for (i = 0; i < 3; ++i) {
            float rotNew;
            float rot;
            if (this.lerpXRotHeadsSteps[i] > 0.0f) {
                rot = i == 0 ? this.storm.m_146909_() : this.xRotHeads[i - 1];
                rotNew = (float)((double)rot + Mth.m_14175_((double)((double)this.lerpXRotHeads[i] - (double)rot)) / (double)this.lerpXRotHeadsSteps[i]);
                if (i == 0) {
                    this.storm.m_146926_(rotNew);
                } else {
                    this.xRotHeads[i - 1] = rotNew;
                }
                int n = i;
                this.lerpXRotHeadsSteps[n] = this.lerpXRotHeadsSteps[n] - 1.0f;
            }
            if (!(this.lerpYRotHeadsSteps[i] > 0.0f)) continue;
            rot = i == 0 ? this.storm.m_146908_() : this.yRotHeads[i - 1];
            rotNew = (float)((double)rot + Mth.m_14175_((double)((double)this.lerpYRotHeads[i] - (double)rot)) / (double)this.lerpYRotHeadsSteps[i]);
            if (i == 0) {
                this.storm.m_146922_(rotNew);
            } else {
                this.yRotHeads[i - 1] = rotNew;
            }
            int n = i;
            this.lerpYRotHeadsSteps[n] = this.lerpYRotHeadsSteps[n] - 1.0f;
        }
        this.headPos = this.calculateHeadPositions();
        if (!this.storm.isOnDistantRenderer()) {
            for (i = 0; i < 3; ++i) {
                Vec3 pos = this.getHeadPos(i);
                float x = i > 0 ? this.getHeadXRot(i - 1) : this.storm.m_5686_(1.0f);
                float y = i > 0 ? this.getHeadYRot(i - 1) : this.storm.m_5675_(1.0f);
                Vec3 end = pos.m_82549_(this.storm.getViewVector(x, y, 250.0f));
                BlockHitResult hitResult = this.storm.m_9236_().m_45547_(new ClipContext(pos, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                this.tractorBeamCutoffDistances[i] = hitResult.m_6662_() == HitResult.Type.BLOCK ? pos.m_82554_(hitResult.m_82450_()) : -1.0;
            }
        }
    }

    public void customServerAiStep() {
        int i;
        if (this.storm.getPhase() > 1) {
            for (i = 0; i < (this.storm.getPhase() < 4 || this.storm.areOtherHeadsDisabled() ? this.idleClusterPickup.length - 2 : this.idleClusterPickup.length); ++i) {
                if (!this.storm.tractorBeamActive(i) || this.storm.f_19797_ < this.nextClusterPickup[i]) continue;
                this.nextClusterPickup[i] = this.storm.getPhase() <= 3 ? this.storm.f_19797_ + 50 : (this.storm.getPhase() >= 4 ? this.storm.f_19797_ + 15 + this.storm.m_217043_().m_188503_(5) : this.storm.f_19797_ + 45);
                this.idleClusterPickup[i] = this.idleClusterPickup[i] + 1;
                float x = i > 0 ? this.getHeadXRot(i - 1) : this.storm.m_5686_(1.0f);
                float y = i > 0 ? this.getHeadYRot(i - 1) : this.storm.m_5675_(1.0f);
                this.storm.createClusterFromLook(x, y, (int)this.storm.getClusterRadius(), i);
                this.idleClusterPickup[i] = 0;
            }
        }
        if (!this.storm.areOtherHeadsDisabled()) {
            for (i = 1; i < 3; ++i) {
                if (this.storm.f_19797_ < this.nextHeadUpdate[i - 1]) continue;
                this.nextHeadUpdate[i - 1] = this.storm.getPhase() < 4 ? this.storm.f_19797_ + 10 + this.storm.m_217043_().m_188503_(10) : this.storm.f_19797_ + 1200 + this.storm.m_217043_().m_188503_(120);
                int k3 = this.idleHeadUpdates[i - 1];
                this.idleHeadUpdates[i - 1] = this.idleHeadUpdates[i - 1] + 1;
                if (k3 > 15) {
                    double d0 = Mth.m_216263_((RandomSource)this.storm.m_217043_(), (double)(this.getHeadX(i) - 10.0), (double)(this.getHeadX(i) + 10.0));
                    double d1 = Mth.m_216263_((RandomSource)this.storm.m_217043_(), (double)(this.getHeadY(i) - 5.0), (double)(this.getHeadY(i) + 5.0));
                    double d2 = Mth.m_216263_((RandomSource)this.storm.m_217043_(), (double)(this.getHeadZ(i) - 10.0), (double)(this.getHeadZ(i) + 10.0));
                    this.storm.performRangedAttack(i, d0, d1, d2, true);
                    this.idleHeadUpdates[i - 1] = 0;
                }
                if (this.getAlternativeTarget(i) == null) continue;
                LivingEntity entity = this.getAlternativeTarget(i);
                if (entity != null) {
                    if (this.storm.targetIsStillApplicable(i, entity)) {
                        this.storm.performRangedAttack(i, entity);
                        this.nextHeadUpdate[i - 1] = this.storm.getPhase() < 4 ? this.storm.f_19797_ + 40 + this.storm.m_217043_().m_188503_(20) : this.storm.f_19797_ + 1800 + this.storm.m_217043_().m_188503_(160);
                        this.idleHeadUpdates[i - 1] = 0;
                        continue;
                    }
                    this.nextHeadUpdate[i - 1] = this.storm.f_19797_ + 40 + this.storm.m_217043_().m_188503_(20);
                    continue;
                }
                this.nextHeadUpdate[i - 1] = this.storm.f_19797_ + 40 + this.storm.m_217043_().m_188503_(20);
            }
        }
    }

    public void tickDistractionTimer() {
        for (int i = 0; i < 3; ++i) {
            if (this.distractedTime[i] <= 0) continue;
            int n = i;
            this.distractedTime[n] = this.distractedTime[n] - 1;
            if (this.distractedTime[i] > 0) continue;
            this.setDistractedPos(i, null);
        }
    }

    public void tickAnimations() {
        for (int i = 0; i < 3; ++i) {
            if (this.nextRoarTick[i] == 0) {
                this.nextRoarTick[i] = this.storm.f_19797_ + 200 + this.storm.m_217043_().m_188503_(200);
            }
            if (this.storm.f_19797_ > this.nextRoarTick[i]) {
                if (!this.storm.m_21525_()) {
                    if ((this.storm.areOtherHeadsDisabled() && i == 0 || !this.storm.areOtherHeadsDisabled()) && !this.storm.isDistracted(i)) {
                        Vec3 view = this.storm.getViewVector(this.storm.m_146909_(), this.storm.f_20885_, 1.0f);
                        if (i > 0) {
                            view = this.storm.getViewVector(this.getHeadXRot(i - 1), this.getHeadYRot(i - 1), 1.0f);
                        }
                        if (this.storm.getPhase() < 4 && i == 0 && this.storm.m_5448_() != null || this.storm.getPhase() > 3) {
                            this.storm.spawnFlamingWitherSkull(i, view.f_82479_ + this.getHeadX(i), view.f_82480_ + this.getHeadY(i), view.f_82481_ + this.getHeadZ(i));
                        }
                    }
                    this.doRoar(i, this.storm.isHeadInjured(i));
                }
                int min = (Integer)WitherStormModConfig.SERVER.minimumRoarInterval.get() * 20;
                int max = (Integer)WitherStormModConfig.SERVER.maximumRoarInterval.get() * 20;
                int randomMax = max - min;
                int random = 0;
                if (randomMax > 0) {
                    random = this.storm.m_217043_().m_188503_(randomMax);
                }
                this.nextRoarTick[i] = this.storm.f_19797_ + min + random;
            }
            if (this.getCanRoar(i)) {
                int n = i;
                this.roarTicks[n] = this.roarTicks[n] + 1;
                if (this.roarTicks[i] > 40) {
                    this.disableRoar(i);
                    this.roarTicks[i] = 0;
                }
            }
            if (!this.isBiting(i)) continue;
            int n = i;
            this.biteTicks[n] = this.biteTicks[n] + 1;
            if (this.biteTicks[i] <= 10) continue;
            this.stopBiting(i);
            this.biteTicks[i] = 0;
            this.storm.playSound((SoundEvent)WitherStormModSoundEvents.WITHER_STORM_BITE.get(), i, Math.max(2.0f, this.storm.m_6121_()), 1.0f);
        }
    }

    public void doHeadLookLogic() {
        for (int j = 0; j < 2; ++j) {
            Vec3 pos = this.getLookPos(j + 1);
            if (pos != null) {
                double d9 = this.getHeadX(j + 1);
                double d1 = this.getHeadY(j + 1);
                double d3 = this.getHeadZ(j + 1);
                double d4 = pos.m_7096_() - d9;
                double d5 = pos.m_7098_() - d1;
                double d6 = pos.m_7094_() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f = (float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(Mth.m_14136_((double)d5, (double)d7) * 57.2957763671875));
                this.lerpHeadsTo(j + 1, f1, f, this.getLookSteps());
                continue;
            }
            if (this.storm.isOnDistantRenderer() || this.storm.isDeadOrPlayingDead()) continue;
            this.yRotHeads[j] = WitherStormEntity.m_21376_(this.yRotHeads[j], this.storm.f_20883_, 10.0f);
        }
    }

    public Vec3[] calculateHeadPositions() {
        Vec3[] positions = new Vec3[3];
        HeadConfiguration config = this.findCurrentConfig();
        for (int i = 0; i < 3; ++i) {
            positions[i] = this.calculateHeadPosition(i, config);
        }
        return positions;
    }

    private HeadConfiguration findCurrentConfig() {
        for (HeadConfiguration configuration : this.configurations) {
            if (!configuration.predicate().test(this.storm)) continue;
            return configuration;
        }
        return this.configurations.get(0);
    }

    public Vec3 calculateHeadPosition(int head, HeadConfiguration config) {
        if (head > 2) {
            head = 2;
        }
        float yBodyRot = (this.storm.f_20883_ + 180.0f) * ((float)Math.PI / 180);
        float yBodyRot90 = (this.storm.f_20883_ + 270.0f) * ((float)Math.PI / 180);
        float xBodyRot = -(this.storm.xBodyRot + 270.0f) * ((float)Math.PI / 180);
        Vec3 headOffset = config.getOffsetForHead(head);
        double staticX = headOffset.f_82479_;
        double staticY = headOffset.f_82480_;
        double staticZ = headOffset.f_82481_;
        double xOffset = (double)Mth.m_14089_((float)yBodyRot) * staticX;
        double zOffset = (double)Mth.m_14031_((float)yBodyRot) * staticX;
        float offset = (float)Mth.m_14136_((double)staticZ, (double)staticY);
        double rawX = Mth.m_14089_((float)(xBodyRot + offset)) * Mth.m_14089_((float)yBodyRot90);
        double rawY = Mth.m_14031_((float)(xBodyRot + offset));
        double rawZ = Mth.m_14089_((float)(xBodyRot + offset)) * Mth.m_14031_((float)yBodyRot90);
        double sqrt = Math.sqrt(staticZ * staticZ + staticY * staticY);
        double x = xOffset + this.storm.m_20185_() + rawX * sqrt;
        double y = this.storm.m_20186_() + rawY * sqrt;
        double z = zOffset + this.storm.m_20189_() + rawZ * sqrt;
        return new Vec3(x, y, z);
    }

    public Vec3 getHeadPos(int head) {
        if (head > 2) {
            head = 2;
        }
        return this.headPos[head];
    }

    public Vec3 getHeadPosO(int head) {
        if (head > 2) {
            head = 2;
        }
        return this.headPosO[head];
    }

    public double getHeadX(int head) {
        return this.getHeadPos(head).m_7096_();
    }

    public double getHeadY(int head) {
        return this.getHeadPos(head).m_7098_();
    }

    public double getHeadZ(int head) {
        return this.getHeadPos(head).m_7094_();
    }

    public double getPrevHeadX(int head) {
        return this.getHeadPosO(head).m_7096_();
    }

    public double getPrevHeadY(int head) {
        return this.getHeadPosO(head).m_7098_();
    }

    public double getPrevHeadZ(int head) {
        return this.getHeadPosO(head).m_7094_();
    }

    public float getHeadYRot(int head) {
        return this.yRotHeads[head];
    }

    public float getHeadXRot(int head) {
        return this.xRotHeads[head];
    }

    public float getHeadYRotO(int head) {
        return this.yRotOHeads[head];
    }

    public float getHeadXRotO(int head) {
        return this.xRotOHeads[head];
    }

    @Nullable
    public LivingEntity getAlternativeTarget(int head) {
        return this.targets[head];
    }

    public void setAlternativeTarget(int head, @Nullable LivingEntity entity) {
        this.targets[head] = entity;
    }

    public void lerpHeadsTo(int head, float lerpToX, float lerpToY, float steps) {
        this.lerpXRotHeads[head] = lerpToX;
        this.lerpYRotHeads[head] = lerpToY;
        this.lerpXRotHeadsSteps[head] = steps;
        this.lerpYRotHeadsSteps[head] = steps;
    }

    public void lerpHeadsXTo(int head, float lerpToX, float steps) {
        this.lerpXRotHeads[head] = lerpToX;
        this.lerpXRotHeadsSteps[head] = steps;
    }

    public void lerpHeadsYTo(int head, float lerpToY, float steps) {
        this.lerpYRotHeads[head] = lerpToY;
        this.lerpYRotHeadsSteps[head] = steps;
    }

    public float getMouthAnimation(int head, float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.mouthAnimO[head], (float)this.mouthAnim[head]);
    }

    public float getBrokenJawAnimation(int head, float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.jawBrokenAnimationO[head], (float)this.jawBrokenAnimation[head]);
    }

    @Nullable
    public Vec3 getDistractedPos(int head) {
        return this.distractedPositions[head];
    }

    public void setDistractedPos(int head, @Nullable Vec3 pos) {
        this.distractedPositions[head] = pos;
    }

    public void makeDistracted(Vec3 pos, int time, int head) {
        this.distractedTime[head] = time;
        this.setDistractedPos(head, pos);
    }

    public void setRoar(int head, boolean flag) {
        this.storm.m_20088_().m_135381_(HEAD_ROARS.get(head), (Object)flag);
    }

    public void doRoar(int head, boolean screaming) {
        this.setRoar(head, true);
        SoundEvent event = (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_ROAR.get();
        if (screaming) {
            event = (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_HURT.get();
        }
        if (this.storm.areOtherHeadsDisabled() || this.storm.getPhase() < 4 && this.storm.getPhase() > 1) {
            if (head == 0) {
                this.storm.playSound(event, head, Math.max(6.0f, this.storm.m_6121_() + 2.5f), 1.0f);
            }
        } else if (this.storm.getPhase() > 3 && !this.storm.areOtherHeadsDisabled()) {
            this.storm.playSound(event, head, Math.max(6.0f, this.storm.m_6121_() + 2.5f), 1.0f);
        }
    }

    public void openMouth(int head) {
        this.storm.m_20088_().m_135381_(HEAD_ROARS.get(head), (Object)true);
    }

    public void disableRoar(int head) {
        this.storm.m_20088_().m_135381_(HEAD_ROARS.get(head), (Object)false);
    }

    public void closeMouth(int head) {
        this.storm.m_20088_().m_135381_(HEAD_ROARS.get(head), (Object)false);
    }

    public boolean getCanRoar(int head) {
        return (Boolean)this.storm.m_20088_().m_135370_(HEAD_ROARS.get(head));
    }

    public void startBiting(int head) {
        this.biteTicks[head] = 0;
        this.storm.m_20088_().m_135381_(HEADS_BITING.get(head), (Object)true);
    }

    public void stopBiting(int head) {
        this.storm.m_20088_().m_135381_(HEADS_BITING.get(head), (Object)false);
    }

    public boolean isBiting(int head) {
        return (Boolean)this.storm.m_20088_().m_135370_(HEADS_BITING.get(head));
    }

    public void setLookPos(int head, @Nullable Vec3 pos) {
        this.setLookPos(head, pos, 3);
    }

    public void setLookPos(int head, @Nullable Vec3 pos, int steps) {
        this.setLookSteps(steps);
        this.storm.m_20088_().m_135381_(TARGETS.get(head), Optional.ofNullable(pos));
    }

    @Nullable
    public Vec3 getLookPos(int head) {
        return ((Optional)this.storm.m_20088_().m_135370_(TARGETS.get(head))).orElse(null);
    }

    public boolean areOtherHeadsDisabled() {
        return (Boolean)this.storm.m_20088_().m_135370_(OTHER_HEADS_DISABLED);
    }

    public void setOtherHeadsDisabled(boolean value) {
        this.storm.m_20088_().m_135381_(OTHER_HEADS_DISABLED, (Object)value);
        this.storm.getSegmentsManager().ifPresent(manager -> {
            WitherStormSegmentEntity[] segments = manager.getSegments();
            for (int i = 0; i < segments.length; ++i) {
                if (segments[i] == null) continue;
                segments[i].setOtherHeadsDisabled(value);
            }
        });
    }

    private void setLookSteps(int steps) {
        this.storm.m_20088_().m_135381_(LOOK_STEPS, (Object)steps);
    }

    private int getLookSteps() {
        return (Integer)this.storm.m_20088_().m_135370_(LOOK_STEPS);
    }

    public double getTractorBeamCutoff(int head) {
        return this.tractorBeamCutoffDistances[head];
    }

    public static void bootstrap() {
    }
}

