/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity.ai.witherstorm;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;

public class IgnoredTargetsManager {
    public static final int DEFAULT_TIME = 80;
    private final List<Ignored> entities = Lists.newArrayList();

    public void tick() {
        Iterator<Ignored> iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            Ignored ignored = iterator.next();
            if (ignored.ticks <= 0) continue;
            --ignored.ticks;
            if (ignored.ticks != 0) continue;
            iterator.remove();
        }
    }

    public void addEntityToIgnore(Entity entity) {
        this.addEntityToIgnore(entity, 80);
    }

    public void addEntityToIgnore(Entity entity, int time) {
        if (!this.shouldIgnoreEntity(entity)) {
            this.entities.add(new Ignored(entity.m_20148_(), time));
        }
    }

    public boolean shouldIgnoreEntity(Entity entity) {
        return this.entities.stream().anyMatch(e -> e.entity.equals(entity.m_20148_()));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Ignored ignored : this.entities) {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("UUID", ignored.entity);
            entry.m_128405_("Ticks", ignored.ticks);
            list.add((Object)entry);
        }
        tag.m_128365_("Entities", (Tag)list);
        return tag;
    }

    public void read(CompoundTag tag) {
        this.entities.clear();
        ListTag list = tag.m_128437_("Entities", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            UUID id = entry.m_128342_("UUID");
            int ticks = entry.m_128451_("Ticks");
            this.entities.add(new Ignored(id, ticks));
        }
    }

    private class Ignored {
        private final UUID entity;
        private int ticks;

        public Ignored(UUID entity, int time) {
            this.entity = entity;
            this.ticks = time;
        }
    }
}

