/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity.ai.witherstorm;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModPacketHandlers;
import nonamecrackers2.witherstormmod.common.packet.CreateDebrisMessage;
import nonamecrackers2.witherstormmod.common.packet.DistantRendererMessage;
import nonamecrackers2.witherstormmod.common.packet.RemoveStormFromDistantRendererMessage;
import nonamecrackers2.witherstormmod.common.packet.StormAttributesMessage;
import nonamecrackers2.witherstormmod.common.packet.StormMetadataMessage;
import nonamecrackers2.witherstormmod.common.packet.StormTeleportMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateStormHeadLookMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateStormPositionMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateStormVelocityMessage;
import nonamecrackers2.witherstormmod.common.packet.WitherStormToDistantRendererMessage;
import nonamecrackers2.witherstormmod.common.util.WorldUtil;

public class DistantRendererManager {
    private final WitherStormEntity entity;
    private final VecDeltaCodec positionCodec = new VecDeltaCodec();
    private int yRotP;
    private int xRotP;
    private Vec3 ap = Vec3.f_82478_;
    private int tickCount;
    private int teleportDelay;
    private boolean wasRiding;
    private boolean wasOnGround;

    public DistantRendererManager(WitherStormEntity entity) {
        this.entity = entity;
        this.positionCodec.m_238033_(entity.m_213870_());
        this.yRotP = Mth.m_14143_((float)(entity.m_146908_() * 256.0f / 360.0f));
        this.xRotP = Mth.m_14143_((float)(entity.m_146909_() * 256.0f / 360.0f));
        this.wasOnGround = entity.m_20096_();
    }

    public void sendChangesToDistantRenderer() {
        if (this.tickCount % this.entity.m_6095_().m_20682_() == 0 || this.entity.hasDistantImpulse || this.entity.m_20088_().m_135352_()) {
            if (this.entity.m_20159_()) {
                boolean flag;
                yRot = Mth.m_14143_((float)(this.entity.m_146908_() * 256.0f / 360.0f));
                xRot = Mth.m_14143_((float)(this.entity.m_146909_() * 256.0f / 360.0f));
                boolean bl = flag = Math.abs(yRot - this.yRotP) >= 1 || Math.abs(xRot - this.xRotP) >= 1;
                if (flag) {
                    UpdateStormPositionMessage message = new UpdateStormPositionMessage(DistantRendererManager.applicable(this.entity), this.entity.m_19879_(), (byte)yRot, (byte)xRot, this.entity.m_20096_());
                    WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.entity.m_9236_().m_46472_()), (Object)message);
                    this.yRotP = yRot;
                    this.xRotP = xRot;
                }
                this.positionCodec.m_238033_(this.entity.m_213870_());
                this.sendDirtyEntityData();
                this.wasRiding = true;
            } else {
                Vec3 vector3d;
                double d0;
                ++this.teleportDelay;
                yRot = Mth.m_14143_((float)(this.entity.m_146908_() * 256.0f / 360.0f));
                xRot = Mth.m_14143_((float)(this.entity.m_146909_() * 256.0f / 360.0f));
                Vec3 pos = this.entity.m_213870_();
                boolean flag = this.positionCodec.m_238031_(pos).m_82556_() >= 7.62939453125E-6;
                DistantRendererMessage message = null;
                boolean flag1 = flag || this.tickCount % 60 == 0;
                boolean flag2 = Math.abs(yRot - this.yRotP) >= 1 || Math.abs(xRot - this.xRotP) >= 1;
                boolean flag5 = false;
                boolean flag6 = false;
                if (this.tickCount > 0) {
                    boolean flag3;
                    long x = this.positionCodec.m_238025_(pos);
                    long y = this.positionCodec.m_238027_(pos);
                    long z = this.positionCodec.m_238029_(pos);
                    boolean bl = flag3 = x < -32768L || x > 32767L || y < -32768L || y > 32767L || z < -32768L || z > 32767L;
                    if (!flag3 && this.teleportDelay <= 400 && !this.wasRiding && this.wasOnGround == this.entity.m_20096_()) {
                        if (!flag1 || flag2) {
                            if (flag1) {
                                message = new UpdateStormPositionMessage(DistantRendererManager.applicable(this.entity), this.entity.m_19879_(), (short)x, (short)y, (short)z, this.entity.m_20096_());
                                flag5 = true;
                            } else if (flag2) {
                                message = new UpdateStormPositionMessage(DistantRendererManager.applicable(this.entity), this.entity.m_19879_(), (byte)yRot, (byte)xRot, this.entity.m_20096_());
                                flag6 = true;
                            }
                        } else {
                            message = new UpdateStormPositionMessage(DistantRendererManager.applicable(this.entity), this.entity.m_19879_(), (short)x, (short)y, (short)z, (byte)yRot, (byte)xRot, this.entity.m_20096_());
                            flag5 = true;
                            flag6 = true;
                        }
                    } else {
                        this.wasOnGround = this.entity.m_20096_();
                        this.teleportDelay = 0;
                        message = new StormTeleportMessage(DistantRendererManager.applicable(this.entity), this.entity);
                        flag5 = true;
                        flag6 = true;
                    }
                }
                if ((this.entity.m_6095_().m_20683_() || this.entity.hasDistantImpulse || this.entity.m_21255_()) && this.tickCount > 0 && ((d0 = (vector3d = this.entity.m_20184_()).m_82557_(this.ap)) > 1.0E-7 || d0 > 0.0 && vector3d.m_82556_() == 0.0)) {
                    this.ap = vector3d;
                    UpdateStormVelocityMessage velocityMessage = new UpdateStormVelocityMessage(DistantRendererManager.applicable(this.entity), this.entity);
                    WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.entity.m_9236_().m_46472_()), (Object)velocityMessage);
                }
                if (message != null) {
                    WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.entity.m_9236_().m_46472_()), message);
                }
                this.sendDirtyEntityData();
                if (flag5) {
                    this.positionCodec.m_238033_(pos);
                }
                if (flag6) {
                    this.yRotP = yRot;
                    this.xRotP = xRot;
                }
                this.wasRiding = false;
            }
            int yHeadRot = Mth.m_14143_((float)(this.entity.m_6080_() * 256.0f / 360.0f));
            byte[] xHeadsRot = new byte[2];
            byte[] yHeadsRot = new byte[2];
            for (int i = 0; i < 2; ++i) {
                xHeadsRot[i] = (byte)Mth.m_14143_((float)(this.entity.getHeadXRot(i) * 256.0f / 360.0f));
                yHeadsRot[i] = (byte)Mth.m_14143_((float)(this.entity.getHeadYRot(i) * 256.0f / 360.0f));
            }
            UpdateStormHeadLookMessage message = new UpdateStormHeadLookMessage(DistantRendererManager.applicable(this.entity), this.entity, (byte)yHeadRot, xHeadsRot, yHeadsRot);
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.entity.m_9236_().m_46472_()), (Object)message);
            this.entity.hasDistantImpulse = false;
        }
        ++this.tickCount;
        if (this.entity.distanceHurtMarked) {
            UpdateStormVelocityMessage message = new UpdateStormVelocityMessage(DistantRendererManager.applicable(this.entity), this.entity);
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.entity.m_9236_().m_46472_()), (Object)message);
            this.entity.hasDistantImpulse = false;
        }
    }

    private void sendDirtyEntityData() {
        SynchedEntityData dataManager = this.entity.m_20088_();
        StormMetadataMessage message = new StormMetadataMessage(DistantRendererManager.applicable(this.entity), this.entity.m_19879_(), dataManager);
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.entity.m_9236_().m_46472_()), (Object)message);
        HashSet set = Sets.newHashSet((Iterable)this.entity.m_21204_().m_22170_());
        if (!set.isEmpty()) {
            StormAttributesMessage attributesMessage = new StormAttributesMessage(DistantRendererManager.applicable(this.entity), this.entity.m_19879_(), set);
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.entity.m_9236_().m_46472_()), (Object)attributesMessage);
        }
    }

    public static List<Integer> applicable(WitherStormEntity entity) {
        return WorldUtil.getAllStorms((ServerLevel)entity.m_9236_()).stream().collect(Collectors.mapping(Entity::m_19879_, Collectors.toList()));
    }

    public static void sendInformationToDistantRenderer(ServerPlayer player) {
        ServerLevel world = (ServerLevel)player.m_9236_();
        for (Entity entity : world.m_8583_()) {
            if (!(entity instanceof WitherStormEntity)) continue;
            WitherStormEntity storm = (WitherStormEntity)entity;
            WitherStormToDistantRendererMessage witherStormMessage = new WitherStormToDistantRendererMessage(DistantRendererManager.applicable(storm), storm);
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)witherStormMessage);
            storm.getPlayDeadManager().sendChanges(PacketDistributor.PLAYER.with(() -> player), false);
            CreateDebrisMessage createDebrisMessage = new CreateDebrisMessage(storm, storm.isDeadOrPlayingDead());
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)createDebrisMessage);
        }
    }

    public static void addEntityToDistantRenderer(WitherStormEntity entity, PacketDistributor.PacketTarget target) {
        WitherStormToDistantRendererMessage message = new WitherStormToDistantRendererMessage(DistantRendererManager.applicable(entity), entity);
        WitherStormModPacketHandlers.MAIN.send(target, (Object)message);
    }

    public static void removeEntityFromDistantRenderer(WitherStormEntity entity, PacketDistributor.PacketTarget target) {
        RemoveStormFromDistantRendererMessage message = new RemoveStormFromDistantRendererMessage(DistantRendererManager.applicable(entity), entity);
        WitherStormModPacketHandlers.MAIN.send(target, (Object)message);
    }

    public static class Events {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            DistantRendererManager.sendInformationToDistantRenderer((ServerPlayer)event.getEntity());
        }

        @SubscribeEvent
        public static void onPlayerChangeDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
            DistantRendererManager.sendInformationToDistantRenderer((ServerPlayer)event.getEntity());
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            DistantRendererManager.sendInformationToDistantRenderer((ServerPlayer)event.getEntity());
        }
    }
}

