/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.BossThemeEntity;
import nonamecrackers2.witherstormmod.common.entity.SickenedCreeper;
import nonamecrackers2.witherstormmod.common.entity.SickenedSpider;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEntityTypes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModPacketHandlers;
import nonamecrackers2.witherstormmod.common.init.WitherStormModParticleTypes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModSoundEvents;
import nonamecrackers2.witherstormmod.common.packet.Message;
import nonamecrackers2.witherstormmod.common.packet.PlayerMotionMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateDamagingProjectileMessage;
import nonamecrackers2.witherstormmod.common.serializer.WitherStormModDataSerializers;
import nonamecrackers2.witherstormmod.common.util.ConditionalLookController;
import nonamecrackers2.witherstormmod.common.util.WorldUtil;
import nonamecrackers2.witherstormmod.mixin.IMixinShulkerBullet;
import org.apache.commons.lang3.ArrayUtils;

public class WitheredSymbiontEntity
extends Monster
implements BossThemeEntity {
    private static final EntityDataAccessor<BossfightStage> BOSSFIGHT_STAGE = SynchedEntityData.m_135353_(WitheredSymbiontEntity.class, WitherStormModDataSerializers.BOSSFIGHT_STAGE_ENUM);
    private static final EntityDataAccessor<SpellType> SPELL_TYPE = SynchedEntityData.m_135353_(WitheredSymbiontEntity.class, WitherStormModDataSerializers.SPELL_ENUM);
    private static final EntityDataAccessor<Boolean> NON_BOSS_MODE = SynchedEntityData.m_135353_(WitheredSymbiontEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RUSH_MODE = SynchedEntityData.m_135353_(WitheredSymbiontEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_NOT_GO_OVER_HALF = SynchedEntityData.m_135353_(WitheredSymbiontEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Predicate<LivingEntity> TARGET_PREDICATE = entity -> entity.m_6097_() && entity instanceof Player;
    private static final TargetingConditions PROTECT_PREDICATE = TargetingConditions.m_148353_().m_26883_(3.0).m_26888_(entity -> entity instanceof Player);
    private List<Goal> bossFightGoals;
    private MeleeAttackGoal attackGoal;
    private PrepareSpellGoal prepareSpellGoal;
    private UseSpellGoal useSpellGoal;
    private SummonMobsGoal summonMobsGoal;
    private DoNothingGoal doNothingGoal;
    private int stageTicks;
    private int spellCastingTime;
    private int nextSpellPickCount;
    private List<Projectile> projectiles = new ArrayList<Projectile>();
    private boolean isDoingSmash;
    private int smashAirTime;
    private List<LivingEntity> entitiesToThrow = new ArrayList<LivingEntity>();
    private int spellsUsed;
    private float crouchAnim;
    private float crouchAnimO;
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private int specialDeathTime;
    @Nullable
    private UUID summoner;
    private int attackDelay;
    private List<ItemStack> dropItems = Lists.newArrayList();
    private float tearAlpha;
    private float tearAlphaO;
    private List<UUID> fightContributors = Lists.newArrayList();

    public WitheredSymbiontEntity(EntityType<? extends WitheredSymbiontEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 150;
        this.f_21365_ = new ConditionalLookController<WitheredSymbiontEntity>(this, entity -> !entity.isVulnerable() && !entity.m_21224_());
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOSSFIGHT_STAGE, (Object)BossfightStage.ATTACKING);
        this.f_19804_.m_135372_(SPELL_TYPE, (Object)SpellType.NONE);
        this.f_19804_.m_135372_(NON_BOSS_MODE, (Object)false);
        this.f_19804_.m_135372_(RUSH_MODE, (Object)false);
        this.f_19804_.m_135372_(SHOULD_NOT_GO_OVER_HALF, (Object)true);
    }

    protected void m_8099_() {
        this.bossFightGoals = new ArrayList<Goal>();
        this.attackGoal = new MeleeAttackGoal((PathfinderMob)this, 1.0, true);
        this.prepareSpellGoal = new PrepareSpellGoal(this);
        this.useSpellGoal = new UseSpellGoal(this);
        this.summonMobsGoal = new SummonMobsGoal(this, Lists.newArrayList((Object[])new EntityType[]{(EntityType)WitherStormModEntityTypes.SICKENED_CREEPER.get(), (EntityType)WitherStormModEntityTypes.SICKENED_SKELETON.get(), (EntityType)WitherStormModEntityTypes.SICKENED_SPIDER.get(), (EntityType)WitherStormModEntityTypes.SICKENED_ZOMBIE.get(), (EntityType)WitherStormModEntityTypes.SICKENED_VILLAGER.get(), (EntityType)WitherStormModEntityTypes.SICKENED_PILLAGER.get()}));
        this.doNothingGoal = new DoNothingGoal(this);
        this.bossFightGoals.add((Goal)this.attackGoal);
        this.bossFightGoals.add(this.prepareSpellGoal);
        this.bossFightGoals.add(this.useSpellGoal);
        this.bossFightGoals.add(this.summonMobsGoal);
        this.bossFightGoals.add(this.doNothingGoal);
        this.f_21345_.m_25352_(1, (Goal)this.prepareSpellGoal);
        this.f_21345_.m_25352_(2, (Goal)this.useSpellGoal);
        this.f_21345_.m_25352_(3, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.7f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, TARGET_PREDICATE));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsNonBossMode", this.isNonBossMode());
        compound.m_128379_("IsRushMode", this.isRushMode());
        compound.m_128405_("Stage", this.getStage().ordinal());
        compound.m_128405_("StageTicks", this.getStageTicks());
        compound.m_128405_("Spell", this.getSpell().ordinal());
        compound.m_128405_("SpellCastingTicks", this.spellCastingTime);
        compound.m_128405_("NextSpellPick", this.nextSpellPickCount);
        compound.m_128379_("Smashing", this.isSmashing());
        compound.m_128405_("SmashAirTime", this.smashAirTime);
        compound.m_128405_("SpellsUsed", this.getSpellsUsed());
        if (this.summoner != null) {
            compound.m_128362_("Summoner", this.summoner);
        }
        compound.m_128405_("AttackDelay", this.attackDelay);
        if (!this.dropItems.isEmpty()) {
            ListTag dropItems = new ListTag();
            for (ItemStack stack : this.dropItems) {
                if (stack.m_41619_()) continue;
                CompoundTag tag = new CompoundTag();
                stack.m_41739_(tag);
                dropItems.add((Object)tag);
            }
            compound.m_128365_("DropItems", (Tag)dropItems);
        }
        compound.m_128379_("ShouldNotGoOverHalf", ((Boolean)this.f_19804_.m_135370_(SHOULD_NOT_GO_OVER_HALF)).booleanValue());
        ListTag fightContributors = new ListTag();
        for (UUID id : this.fightContributors) {
            fightContributors.add((Object)NbtUtils.m_129226_((UUID)id));
        }
        compound.m_128365_("FightContributors", (Tag)fightContributors);
    }

    public void m_7378_(CompoundTag compound) {
        int ordinal;
        super.m_7378_(compound);
        if (compound.m_128441_("IsNonBossMode")) {
            this.setNonBossMode(compound.m_128471_("IsNonBossMode"));
        }
        if (compound.m_128441_("IsRushMode")) {
            this.setRushMode(compound.m_128471_("IsRushMode"));
        }
        if (compound.m_128441_("Stage") && (ordinal = compound.m_128451_("Stage")) >= 0 && ordinal < BossfightStage.values().length) {
            this.setStage(BossfightStage.values()[ordinal]);
        }
        this.setStageTicks(compound.m_128451_("StageTicks"));
        if (compound.m_128441_("Spell") && (ordinal = compound.m_128451_("Spell")) >= 0 && ordinal < SpellType.values().length) {
            this.setSpell(SpellType.values()[ordinal]);
        }
        this.spellCastingTime = compound.m_128451_("SpellCastingTicks");
        this.nextSpellPickCount = compound.m_128451_("NextSpellPick");
        this.setSmashing(compound.m_128471_("Smashing"));
        this.smashAirTime = compound.m_128451_("SmashAirTime");
        this.spellsUsed = compound.m_128451_("SpellsUsed");
        if (compound.m_128441_("Summoner")) {
            this.summoner = compound.m_128342_("Summoner");
        }
        this.attackDelay = compound.m_128451_("AttackDelay");
        if (compound.m_128441_("DropItems")) {
            ListTag dropItems = compound.m_128437_("DropItems", 10);
            for (int i = 0; i < dropItems.size(); ++i) {
                this.dropItems.add(ItemStack.m_41712_((CompoundTag)dropItems.m_128728_(i)));
            }
        }
        if (compound.m_128441_("ShouldNotGoOverHalf")) {
            this.f_19804_.m_135381_(SHOULD_NOT_GO_OVER_HALF, (Object)compound.m_128471_("ShouldNotGoOverHalf"));
        }
        this.fightContributors.clear();
        ListTag fightContributors = compound.m_128437_("FightContributors", 11);
        for (Tag tag : fightContributors) {
            this.fightContributors.add(NbtUtils.m_129233_((Tag)tag));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 16.0).m_22268_(Attributes.f_22277_, 45.0);
    }

    protected int m_7302_(int supply) {
        return supply;
    }

    protected void m_7324_(Entity entity) {
        if (EntitySelector.f_20406_.test(entity) && entity instanceof LivingEntity && TARGET_PREDICATE.test((Object)((LivingEntity)entity)) && this.m_217043_().m_188503_(20) == 0) {
            this.m_6710_((LivingEntity)entity);
        }
        super.m_7324_(entity);
    }

    public void m_8107_() {
        int i;
        super.m_8107_();
        ++this.stageTicks;
        if (this.spellCastingTime > 0) {
            --this.spellCastingTime;
            this.doSpellCasting();
            if (this.spellCastingTime <= 0) {
                this.castSpell();
            }
            if (this.getSpell() != SpellType.PULL) {
                List entities = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(5.0));
                for (Player player : entities) {
                    if (this.entitiesToThrow.contains(player) || !PROTECT_PREDICATE.m_26885_((LivingEntity)this, (LivingEntity)player)) continue;
                    this.entitiesToThrow.add((LivingEntity)player);
                    this.m_5496_((SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_LAUNCH_MOB.get(), 4.0f, 1.0f);
                }
            }
        }
        for (i = 0; i < this.entitiesToThrow.size(); ++i) {
            LivingEntity entity = this.entitiesToThrow.get(i);
            if (PROTECT_PREDICATE.m_26885_((LivingEntity)this, entity)) {
                Vec3 delta = this.m_20182_().m_82546_(entity.m_20182_()).m_82541_().m_82520_(0.0, -0.5, 0.0).m_82490_(-1.0);
                entity.m_20256_(delta);
                continue;
            }
            this.entitiesToThrow.remove(i);
        }
        if (this.nextSpellPickCount > 0) {
            --this.nextSpellPickCount;
        }
        if (this.isSmashing()) {
            if (this.smashAirTime > 0) {
                --this.smashAirTime;
                if (this.smashAirTime <= 0) {
                    this.m_20334_(this.m_20184_().m_7096_(), -5.0, this.m_20184_().m_7094_());
                }
            } else if (this.m_20096_()) {
                this.setSmashing(false);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Level.ExplosionInteraction.MOB);
                }
            }
        }
        if (this.isCastingSpell() || this.isSummoningMobs()) {
            for (i = 0; i < 5; ++i) {
                double x = this.m_20185_() + this.f_19796_.m_188583_() * 2.0;
                double y = this.m_20188_() + this.f_19796_.m_188583_() * 2.0;
                double z = this.m_20189_() + this.f_19796_.m_188583_() * 2.0;
                Vec3 delta = this.m_20299_(1.0f).m_82492_(x, y, z).m_82541_().m_82542_(0.2, 0.2, 0.2);
                this.m_9236_().m_7106_((ParticleOptions)WitherStormModParticleTypes.COMMAND_BLOCK.get(), x, y, z, delta.m_7096_(), delta.m_7098_(), delta.m_7094_());
            }
        }
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0) {
            i = Mth.m_14107_((double)this.m_20185_());
            int j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f));
            int k = Mth.m_14107_((double)this.m_20189_());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState state = this.m_9236_().m_8055_(pos);
            if (!state.m_60713_(Blocks.f_50016_)) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
            }
        }
        if (!this.m_9236_().f_46443_ && this.getStage().shouldMoveToNextStage(this)) {
            this.nextStage();
        }
        if (this.attackDelay > 0) {
            --this.attackDelay;
            if (this.attackDelay <= 0 && this.isVulnerable()) {
                this.setStage(BossfightStage.ATTACKING);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.crouchAnimO = this.crouchAnim;
        if (this.isVulnerable()) {
            this.crouchAnim += (1.0f - this.crouchAnim) * 0.1f + 0.02f;
            if (this.crouchAnim > 0.6f) {
                this.crouchAnim = 0.6f;
            }
        } else {
            this.crouchAnim += -this.crouchAnim * 0.4f - 0.1f;
            if (this.crouchAnim < 0.0f) {
                this.crouchAnim = 0.0f;
            }
        }
        this.tearAlphaO = this.tearAlpha;
        if (((Boolean)WitherStormModConfig.SERVER.attackableWhenNotVulnerable.get()).booleanValue() || this.isVulnerable()) {
            if (this.tearAlpha < 1.0f) {
                this.tearAlpha += 0.05f;
            }
        } else if (this.tearAlpha > 0.0f) {
            this.tearAlpha -= 0.05f;
        }
        if (!this.m_9236_().f_46443_) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public boolean m_7327_(Entity entity) {
        float f = this.getAttackDamage();
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        boolean flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f1);
        if (flag) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.8, 0.0));
            this.m_19970_((LivingEntity)this, entity);
        }
        return flag;
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected SoundEvent m_7515_() {
        return this.isVulnerable() ? null : (SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        if (this.isNonBossMode()) {
            return (SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_NORMAL_DEATH.get();
        }
        return (SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_DEATH.get();
    }

    public float m_6100_() {
        return this.m_21224_() ? 1.0f : super.m_6100_();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_STEP.get(), 0.3f, 1.0f);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else if (!this.m_21532_() && !this.m_8023_()) {
            List<WitherStormEntity> entities = WorldUtil.getPerformantEntitiesOfClass((ServerLevel)this.m_9236_(), WitherStormEntity.class, this.m_20191_().m_82400_(400.0));
            if (entities.isEmpty()) {
                super.m_6043_();
            } else {
                this.f_20891_ = 0;
            }
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource source) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public AABB m_6921_() {
        return super.m_6921_().m_82400_(3.0);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        if (!this.isCastingSpell() && ((Boolean)WitherStormModConfig.SERVER.attackableWhenNotVulnerable.get()).booleanValue() || this.isVulnerable()) {
            double angle;
            double angleDiff;
            Entity entity = source.m_7639_();
            if (entity != null && ((angleDiff = ((double)(-this.f_20883_) - (angle = Math.atan2(entity.m_20185_() - this.m_20185_(), entity.m_20189_() - this.m_20189_()) * 57.29577951308232) + 180.0 + 360.0) % 360.0) <= 40.0 || angleDiff >= 320.0)) {
                if (this.isVulnerable() && this.attackDelay <= 0) {
                    this.attackDelay = 20;
                }
                if (!this.isVulnerable() && entity instanceof LivingEntity && !this.m_21224_()) {
                    SpellType.SMASH.cast(this, (LivingEntity)entity);
                }
                if (source.m_269533_(DamageTypeTags.f_268415_)) {
                    amount /= 4.0f;
                }
                if (this.shouldNotGoOverHalfHealth()) {
                    float predictedHealth = this.m_21223_() - amount;
                    float maxHealthHalf = this.m_21233_() / 2.0f;
                    amount = Math.min(amount - (maxHealthHalf - predictedHealth), amount);
                }
                float healthCurrent = this.m_21223_();
                boolean flag = super.m_6469_(source, amount);
                float damageDealt = healthCurrent - this.m_21223_();
                if (damageDealt >= 5.0f && entity instanceof Player && !this.fightContributors.contains(entity.m_20148_())) {
                    this.fightContributors.add(entity.m_20148_());
                }
                return flag;
            }
            return false;
        }
        return false;
    }

    public int getStageTicks() {
        return this.stageTicks;
    }

    public void setStageTicks(int ticks) {
        this.stageTicks = ticks;
    }

    public BossfightStage getStage() {
        return (BossfightStage)((Object)this.f_19804_.m_135370_(BOSSFIGHT_STAGE));
    }

    protected void clearBossFightGoals() {
        this.bossFightGoals.forEach(goal -> this.f_21345_.m_25363_(goal));
    }

    protected void addBossFightGoal(int level, Goal goal) {
        this.f_21345_.m_25352_(level, goal);
    }

    public void setStage(BossfightStage stage) {
        if (this.getStage() != stage) {
            this.getStage().finish(this);
        }
        this.f_19804_.m_135381_(BOSSFIGHT_STAGE, (Object)stage);
        this.getStage().init(this);
    }

    public void nextStage() {
        BossfightStage nextStage = this.getNextStage(1);
        if (nextStage == BossfightStage.SUMMONING && this.isNonBossMode()) {
            this.setStage(this.getNextStage(2));
        } else {
            this.setStage(nextStage);
        }
    }

    private BossfightStage getNextStage(int advance) {
        int next = this.getStage().ordinal() + advance;
        if (next < BossfightStage.values().length) {
            return BossfightStage.values()[next];
        }
        return BossfightStage.values()[0];
    }

    public SpellType getSpell() {
        return (SpellType)((Object)this.f_19804_.m_135370_(SPELL_TYPE));
    }

    public void setSpell(SpellType spell) {
        this.f_19804_.m_135381_(SPELL_TYPE, (Object)spell);
    }

    public void m_7350_(EntityDataAccessor<?> parameter) {
        super.m_7350_(parameter);
        if (BOSSFIGHT_STAGE.equals(parameter)) {
            this.getStage().init(this);
        }
    }

    public boolean hasSpell() {
        return this.getSpell() != SpellType.NONE;
    }

    public void beginSpellCasting() {
        if (!this.m_9236_().f_46443_) {
            this.getSpell().start(this, this.m_5448_());
            this.spellCastingTime = this.getSpell().getSpellTime();
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new SetSpellTimeMessage(this.m_19879_(), this.spellCastingTime));
        }
    }

    public boolean isCastingSpell() {
        return this.spellCastingTime > 0;
    }

    public boolean isSummoningMobs() {
        return this.getStage() == BossfightStage.SUMMONING;
    }

    public boolean isVulnerable() {
        return this.getStage() == BossfightStage.VULNERABLE;
    }

    public void breakSpell() {
        if (this.isCastingSpell()) {
            this.spellCastingTime = 0;
            if (!this.m_9236_().f_46443_) {
                this.getSpell().finish(this);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)11);
        }
    }

    public void m_7822_(byte event) {
        if (event == 11) {
            this.breakSpell();
        } else if (event == 12) {
            this.activateAttackDelay();
        } else {
            super.m_7822_(event);
        }
    }

    public void castSpell() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_5448_() != null) {
                this.getSpell().cast(this, this.m_5448_());
            }
            this.getSpell().finish(this);
        } else {
            for (int i = 0; i < 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)WitherStormModParticleTypes.COMMAND_BLOCK.get(), this.m_20185_(), this.m_20188_(), this.m_20189_(), this.f_19796_.m_188583_() * 0.5, this.f_19796_.m_188583_() * 0.5, this.f_19796_.m_188583_() * 0.5);
            }
        }
    }

    public void doSpellCasting() {
        if (!this.m_9236_().f_46443_) {
            int spellCastingTime = this.getSpell().getSpellTime() - this.spellCastingTime;
            if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
                this.getSpell().doCasting(this, this.m_5448_());
            } else if (spellCastingTime % 20 == 0) {
                this.breakSpell();
            }
        }
    }

    public boolean canPickSpell() {
        return !this.hasSpell() || this.nextSpellPickCount <= 0;
    }

    public void setSmashing(boolean flag) {
        this.isDoingSmash = flag;
        if (flag) {
            this.smashAirTime = 20;
        }
    }

    public boolean isSmashing() {
        return this.isDoingSmash;
    }

    public int getSpellsUsed() {
        return this.spellsUsed;
    }

    public float getVulnerableAnim(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.crouchAnimO, (float)this.crouchAnim);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public boolean shouldIncreaseDifficulty() {
        return this.isRushMode() || this.m_21223_() / this.m_21233_() <= 0.5f;
    }

    public boolean shouldNotGoOverHalfHealth() {
        return !this.isNonBossMode() && (Boolean)this.f_19804_.m_135370_(SHOULD_NOT_GO_OVER_HALF) != false;
    }

    protected void m_6153_() {
        if (this.isNonBossMode()) {
            super.m_6153_();
        } else {
            int totalTime = 320;
            ++this.specialDeathTime;
            for (int i = 0; i < (totalTime - this.specialDeathTime) / 40; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
            }
            float speed = 3.0f;
            float f = Mth.m_14118_((float)this.m_146909_(), (float)-50.0f);
            float f1 = Mth.m_14036_((float)f, (float)(-speed), (float)speed);
            this.m_146926_(this.m_146909_() + f1);
            if (this.specialDeathTime == totalTime) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                if (!this.m_9236_().f_46443_ && this.dropItems != null) {
                    List players = this.m_9236_().m_6443_(Player.class, this.m_20191_().m_82400_(20.0), EntitySelector.f_20408_);
                    if (players.size() > 1 && !this.fightContributors.isEmpty()) {
                        for (UUID id : this.fightContributors) {
                            players.stream().filter(p -> p.m_20148_().equals(id)).findFirst().ifPresent(player -> {
                                for (ItemStack stack : this.dropItems) {
                                    if (stack.m_41619_()) continue;
                                    ItemStack copy = stack.m_41777_();
                                    if (player.m_150109_().m_36054_(copy)) continue;
                                    ItemEntity entity = this.m_19983_(copy);
                                    entity.m_20219_(player.m_20182_());
                                    entity.m_266426_(id);
                                }
                            });
                        }
                    } else {
                        this.dropDrops();
                    }
                }
                for (int i = 0; i < 20; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
                }
            }
        }
    }

    private void dropDrops() {
        for (ItemStack stack : this.dropItems) {
            if (stack.m_41619_()) continue;
            ItemEntity entity = this.m_5552_(stack, 8.0f);
            entity.m_20334_(0.0, -0.08, 0.0);
            entity.m_20242_(true);
        }
        this.dropItems.clear();
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        LivingEntity livingEntity = this.m_21232_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(WitherStormModCapabilities.PLAYER_WITHER_STORM_DATA).ifPresent(data -> {
                WitherStormEntity owner = this.getOwner();
                if (owner != null) {
                    data.markKilledSymbiont(owner);
                }
            });
        }
        for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(20.0))) {
            player.getCapability(WitherStormModCapabilities.PLAYER_WITHER_STORM_DATA).ifPresent(data -> data.makeInvulnerable(Mth.m_14045_((int)((Integer)WitherStormModConfig.SERVER.playerInvulnerableTime.get()), (int)1, (int)10) * 1200 + player.m_217043_().m_188503_(1200)));
        }
    }

    public void setOwner(WitherStormEntity entity) {
        this.summoner = entity.m_20148_();
    }

    @Nullable
    public WitherStormEntity getOwner() {
        if (!this.m_9236_().f_46443_) {
            ServerLevel world = (ServerLevel)this.m_9236_();
            for (Entity entity : world.m_8583_()) {
                if (!entity.m_20148_().equals(this.summoner) || !(entity instanceof WitherStormEntity)) continue;
                return (WitherStormEntity)entity;
            }
        }
        return null;
    }

    @Override
    public SoundEvent getBossTheme() {
        if (!this.shouldIncreaseDifficulty()) {
            return (SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_THEME.get();
        }
        return (SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_INTENSE_THEME.get();
    }

    @Override
    public boolean isStillAlive() {
        return this.m_6084_();
    }

    @Override
    public Vec3 getPosition() {
        return this.m_20182_();
    }

    @Override
    public double distanceToPlay() {
        return 45.0;
    }

    @Override
    public int priority() {
        return 2;
    }

    @Override
    public int getFadeTime() {
        return 120;
    }

    @Override
    public boolean checkConfig() {
        return (Boolean)WitherStormModConfig.CLIENT.playSymbiontTheme.get();
    }

    public void activateAttackDelay() {
        this.attackDelay = 20;
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)12);
        }
    }

    public boolean hasAttackDelay() {
        return this.attackDelay > 0;
    }

    public boolean isNonBossMode() {
        return (Boolean)this.f_19804_.m_135370_(NON_BOSS_MODE);
    }

    public void setNonBossMode(boolean mode) {
        this.f_19804_.m_135381_(NON_BOSS_MODE, (Object)mode);
        this.f_21364_ = mode ? 25 : 150;
    }

    public boolean isRushMode() {
        return (Boolean)this.f_19804_.m_135370_(RUSH_MODE);
    }

    public void setRushMode(boolean mode) {
        this.f_19804_.m_135381_(RUSH_MODE, (Object)mode);
    }

    protected void m_7625_(DamageSource source, boolean player) {
        ResourceLocation id = this.m_5743_();
        LootTable table = this.m_9236_().m_7654_().m_278653_().m_278676_(id);
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)source).m_287289_(LootContextParams.f_81458_, (Object)source.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)source.m_7640_());
        if (player && this.f_20888_ != null) {
            builder = builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
        }
        LootParams params = builder.m_287235_(LootContextParamSets.f_81415_);
        this.dropItems = table.m_287214_(params, this.m_287233_());
    }

    protected boolean m_7341_(Entity entity) {
        return super.m_7341_(entity) && !(entity instanceof Boat) && !(entity instanceof AbstractMinecart);
    }

    @Override
    public Component getWatermark() {
        return Component.m_237115_((String)"witherstormmod.watermark.withered_symbiont_theme");
    }

    public float getTearAlpha(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.tearAlphaO, (float)this.tearAlpha);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData groupData, CompoundTag tag) {
        double healthAddition;
        List nearbyPlayers = level.m_6443_(Player.class, this.m_20191_().m_82400_(150.0), e -> e.m_6084_() && !e.m_5833_());
        if (nearbyPlayers.size() > 1 && (healthAddition = (double)nearbyPlayers.size() * (Double)WitherStormModConfig.SERVER.healthScalePerPlayer.get()) > 0.0) {
            this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Health scaling", healthAddition, AttributeModifier.Operation.ADDITION));
            this.m_21153_(this.m_21233_());
        }
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    private LivingEntity getRandomNearbyTargetOrFallback(LivingEntity entity) {
        double range = this.m_21133_(Attributes.f_22277_);
        TargetingConditions conditions = TargetingConditions.m_148352_().m_26883_(this.m_21133_(Attributes.f_22277_)).m_26888_(TARGET_PREDICATE);
        List entities = this.m_9236_().m_45971_(LivingEntity.class, conditions, (LivingEntity)this, this.m_20191_().m_82400_(range)).stream().filter(e -> e != entity).collect(Collectors.toList());
        if (!entities.isEmpty() && this.f_19796_.m_188503_(entities.size() + 1) != 0) {
            Collections.shuffle(entities);
            return (LivingEntity)entities.get(0);
        }
        return entity;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BossfightStage {
        ATTACKING{

            @Override
            public void init(WitheredSymbiontEntity entity) {
                super.init(entity);
                if (!entity.m_9236_().f_46443_) {
                    entity.spellsUsed = 0;
                    entity.clearBossFightGoals();
                    entity.addBossFightGoal(1, entity.prepareSpellGoal);
                    entity.addBossFightGoal(2, entity.useSpellGoal);
                    entity.addBossFightGoal(3, (Goal)entity.attackGoal);
                }
            }

            @Override
            public void finish(WitheredSymbiontEntity entity) {
                super.finish(entity);
                if (!entity.m_9236_().f_46443_) {
                    entity.spellsUsed = 0;
                    entity.setSpell(SpellType.NONE);
                }
            }

            @Override
            public boolean shouldMoveToNextStage(WitheredSymbiontEntity entity) {
                return entity.getSpellsUsed() > 5 && !entity.isCastingSpell() && entity.getStageTicks() % 80 == 0 && entity.m_5448_() != null;
            }
        }
        ,
        SUMMONING{

            @Override
            public void init(WitheredSymbiontEntity entity) {
                super.init(entity);
                if (!entity.m_9236_().f_46443_) {
                    entity.clearBossFightGoals();
                    entity.addBossFightGoal(1, entity.summonMobsGoal);
                }
            }
        }
        ,
        VULNERABLE{

            @Override
            public void init(WitheredSymbiontEntity entity) {
                super.init(entity);
                if (!entity.m_9236_().f_46443_) {
                    entity.clearBossFightGoals();
                    entity.addBossFightGoal(1, entity.doNothingGoal);
                    entity.m_5496_((SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_POWER_DOWN.get(), 4.0f, 1.0f);
                }
            }

            @Override
            public void finish(WitheredSymbiontEntity entity) {
                super.finish(entity);
            }

            @Override
            public boolean shouldMoveToNextStage(WitheredSymbiontEntity entity) {
                return entity.getStageTicks() > 4800;
            }
        };


        public boolean shouldDoNothing() {
            return false;
        }

        public void init(WitheredSymbiontEntity entity) {
            entity.setStageTicks(0);
        }

        public void finish(WitheredSymbiontEntity entity) {
        }

        public boolean shouldMoveToNextStage(WitheredSymbiontEntity entity) {
            return false;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SpellType {
        NONE{

            @Override
            public void cast(WitheredSymbiontEntity owner, @Nonnull LivingEntity target) {
            }

            @Override
            public int getDelay(RandomSource random, float modifier) {
                return 0;
            }

            @Override
            public int getSpellTime() {
                return 0;
            }
        }
        ,
        EVOKER_FANGS{

            @Override
            public void cast(WitheredSymbiontEntity owner, @Nonnull LivingEntity target) {
                LivingEntity entity = owner.getRandomNearbyTargetOrFallback(target);
                double minHeight = Math.min(entity.m_20186_(), owner.m_20186_());
                double maxHeight = Math.max(entity.m_20186_(), owner.m_20186_()) + 1.0;
                float f = (float)Mth.m_14136_((double)(entity.m_20189_() - owner.m_20189_()), (double)(entity.m_20185_() - owner.m_20185_()));
                if (owner.m_20280_((Entity)entity) < 9.0) {
                    double z;
                    double x;
                    float f1;
                    int i;
                    for (i = 0; i < 5; ++i) {
                        f1 = f + (float)i * (float)Math.PI * 0.4f;
                        x = owner.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5;
                        z = owner.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5;
                        this.createFang(owner, x, z, minHeight, maxHeight, f1, 0);
                    }
                    for (i = 0; i < 8; ++i) {
                        f1 = f + (float)i * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        x = owner.m_20185_() + (double)Mth.m_14089_((float)f1) * 2.5;
                        z = owner.m_20189_() + (double)Mth.m_14031_((float)f1) * 2.5;
                        this.createFang(owner, x, z, minHeight, maxHeight, f1, 3);
                    }
                } else {
                    for (int i = 0; i < 24; ++i) {
                        double d2 = 1.25 * (double)(i + 1);
                        int j = 1 * i;
                        double x = owner.m_20185_() + (double)Mth.m_14089_((float)f) * d2;
                        double z = owner.m_20189_() + (double)Mth.m_14031_((float)f) * d2;
                        this.createFang(owner, x, z, minHeight, maxHeight, f, j);
                    }
                }
            }

            private void createFang(WitheredSymbiontEntity owner, double x, double z, double minHeight, double maxHeight, float yRot, int delay) {
                BlockPos blockPos = BlockPos.m_274561_((double)x, (double)maxHeight, (double)z);
                boolean flag = false;
                double d0 = 0.0;
                do {
                    BlockState state1;
                    VoxelShape shape;
                    BlockPos below = blockPos.m_7495_();
                    BlockState state = owner.m_9236_().m_8055_(below);
                    if (!state.m_60783_((BlockGetter)owner.m_9236_(), below, Direction.UP)) continue;
                    if (!owner.m_9236_().m_46859_(blockPos) && !(shape = (state1 = owner.m_9236_().m_8055_(blockPos)).m_60812_((BlockGetter)owner.m_9236_(), blockPos)).m_83281_()) {
                        d0 = shape.m_83297_(Direction.Axis.Y);
                    }
                    flag = true;
                    break;
                } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minHeight) - 1);
                if (flag) {
                    owner.m_9236_().m_7967_((Entity)new EvokerFangs(owner.m_9236_(), x, (double)blockPos.m_123342_() + d0, z, yRot, delay, (LivingEntity)owner));
                }
            }

            @Override
            public int getDelay(RandomSource random, float modifier) {
                return Math.max(60, random.m_188503_(100)) - Mth.m_14143_((float)modifier) * 10;
            }

            @Override
            public int getSpellTime() {
                return 20;
            }
        }
        ,
        SHULKER_BULLETS{

            @Override
            public void start(WitheredSymbiontEntity owner, LivingEntity target) {
                owner.projectiles.clear();
                double y = owner.m_20188_();
                int amount = 5;
                for (int i = 0; i < amount; ++i) {
                    float theta = (float)(Math.PI * 2 / (double)amount);
                    float angle = theta * (float)i;
                    double x = 5.0 * (double)Mth.m_14089_((float)angle) + owner.m_20185_();
                    double z = 5.0 * (double)Mth.m_14031_((float)angle) + owner.m_20189_();
                    ShulkerBullet projectile = new ShulkerBullet(EntityType.f_20522_, owner.m_9236_());
                    projectile.m_6027_(x, y, z);
                    projectile.m_20242_(true);
                    projectile.m_5602_((Entity)owner);
                    owner.m_9236_().m_7967_((Entity)projectile);
                    owner.projectiles.add((Projectile)projectile);
                }
            }

            @Override
            public void cast(WitheredSymbiontEntity owner, LivingEntity target) {
                int size = owner.projectiles.size();
                for (int i = 0; i < size; ++i) {
                    Projectile projectile = owner.projectiles.get(i);
                    if (!(projectile instanceof ShulkerBullet)) continue;
                    IMixinShulkerBullet bullet = (IMixinShulkerBullet)projectile;
                    bullet.setFinalTarget((Entity)owner.getRandomNearbyTargetOrFallback(target));
                    bullet.setCurrentMoveDirection(Direction.UP);
                    bullet.callSelectNextMoveDirection(Direction.Axis.Y);
                    projectile.m_20242_(false);
                }
                owner.m_5496_(SoundEvents.f_12417_, 4.0f, 1.0f);
                owner.projectiles.clear();
            }

            @Override
            public void doCasting(WitheredSymbiontEntity owner, LivingEntity target) {
                int size = owner.projectiles.size();
                int spellCastingTime = this.getSpellTime() - owner.spellCastingTime;
                for (int i = 0; i < size; ++i) {
                    Projectile entity = owner.projectiles.get(i);
                    if (!entity.m_6084_()) continue;
                    float theta = (float)(Math.PI * 2 / (double)size);
                    float angle = theta * (float)i + (float)spellCastingTime * 0.1f;
                    double radius = 5.0;
                    double x = radius * (double)Mth.m_14089_((float)angle) + owner.m_20185_();
                    double y = owner.m_20188_();
                    double z = radius * (double)Mth.m_14031_((float)angle) + owner.m_20189_();
                    Vec3 wanted = new Vec3(x, y, z);
                    double distance = entity.m_20182_().m_82554_(wanted);
                    Vec3 delta = wanted.m_82546_(entity.m_20182_()).m_82541_().m_82542_(distance, distance, distance);
                    entity.m_20256_(delta);
                }
            }

            @Override
            public int getDelay(RandomSource random, float modifier) {
                return Math.max(500, random.m_188503_(620)) - Mth.m_14143_((float)modifier) * 10;
            }

            @Override
            public int getSpellTime() {
                return 80;
            }
        }
        ,
        ARROWS{

            @Override
            public void start(WitheredSymbiontEntity owner, LivingEntity target) {
                owner.projectiles.clear();
            }

            @Override
            public void doCasting(WitheredSymbiontEntity owner, LivingEntity target) {
                if (owner.f_19797_ % Math.max(2, owner.f_19796_.m_188503_(5)) == 0) {
                    Arrow arrow = new Arrow(owner.m_9236_(), (LivingEntity)owner);
                    arrow.m_20242_(true);
                    double deltaX = owner.f_19796_.m_188583_() * 0.05;
                    double deltaY = Math.max(0.05, owner.f_19796_.m_188500_() * 0.35);
                    double deltaZ = owner.f_19796_.m_188583_() * 0.05;
                    Vec2 rot = this.getRot(new Vec3(deltaX, deltaY, deltaZ));
                    arrow.m_20334_(deltaX, deltaY, deltaZ);
                    arrow.m_146926_(rot.f_82470_);
                    arrow.m_146922_(rot.f_82471_);
                    owner.m_9236_().m_7967_((Entity)arrow);
                    owner.projectiles.add((Projectile)arrow);
                    owner.m_5496_(SoundEvents.f_11687_, 4.0f, 1.0f);
                }
                for (Projectile projectile : owner.projectiles) {
                    if (!projectile.m_6084_()) continue;
                    double x = projectile.m_20185_() + owner.f_19796_.m_188583_() * 0.5;
                    double y = projectile.m_20188_() + owner.f_19796_.m_188583_() * 0.5;
                    double z = projectile.m_20189_() + owner.f_19796_.m_188583_() * 0.5;
                    Vec3 delta = projectile.m_20299_(1.0f).m_82492_(x, y, z).m_82541_().m_82542_(0.1, 0.1, 0.1);
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)WitherStormModParticleTypes.COMMAND_BLOCK.get()), x, y, z, 0, delta.m_7096_(), delta.m_7098_(), delta.m_7094_(), 1.0);
                }
            }

            @Override
            public void cast(WitheredSymbiontEntity owner, LivingEntity target) {
                for (Projectile projectile : owner.projectiles) {
                    if (!(projectile instanceof AbstractArrow)) continue;
                    AbstractArrow arrow = (AbstractArrow)projectile;
                    LivingEntity entity = owner.getRandomNearbyTargetOrFallback(target);
                    double x = entity.m_20185_() - arrow.m_20185_();
                    double y = entity.m_20227_(0.3333333333333333) - arrow.m_20186_();
                    double z = entity.m_20189_() - arrow.m_20189_();
                    double d0 = Math.sqrt(x * x + z * z);
                    arrow.m_6686_(x, y + d0 * 0.2, z, 1.6f, (float)(14 - owner.m_9236_().m_46791_().m_19028_() * 4));
                    arrow.m_20242_(false);
                }
                owner.m_5496_(SoundEvents.f_12558_, 4.0f, 1.0f);
                owner.projectiles.clear();
            }

            @Override
            public int getDelay(RandomSource random, float modifier) {
                return Math.max(160, random.m_188503_(200)) - Mth.m_14143_((float)modifier) * 10;
            }

            @Override
            public int getSpellTime() {
                return 40;
            }

            private Vec2 getRot(Vec3 delta) {
                float f = Mth.m_14116_((float)((float)delta.m_165925_()));
                float xRot = (float)(Mth.m_14136_((double)delta.f_82480_, (double)f) * 57.2957763671875);
                float yRot = (float)(Mth.m_14136_((double)delta.f_82479_, (double)delta.f_82481_) * 57.2957763671875);
                return new Vec2(xRot, yRot);
            }
        }
        ,
        SMASH{

            @Override
            public void cast(WitheredSymbiontEntity owner, LivingEntity target) {
                float f = owner.m_6118_() * 5.0f;
                if (owner.m_21023_(MobEffects.f_19603_)) {
                    f += 0.1f * (float)(owner.m_21124_(MobEffects.f_19603_).m_19564_() + 1);
                }
                Vec3 prevDelta = owner.m_20184_();
                double x = owner.m_20185_() - target.m_20185_();
                double z = owner.m_20189_() - target.m_20189_();
                double multiplier = Math.min(0.2, (double)owner.m_20270_((Entity)target) * 0.05);
                Vec3 delta = new Vec3(x, (double)f, z).m_82542_(-multiplier, 1.0, -multiplier);
                delta.m_82520_(prevDelta.f_82479_, 0.0, prevDelta.f_82481_);
                owner.m_20256_(delta);
                owner.setSmashing(true);
                owner.m_5496_(owner.m_20075_().m_60827_().m_56775_(), 4.0f, 1.0f);
            }

            @Override
            public int getDelay(RandomSource random, float modifier) {
                return Math.max(160, random.m_188503_(200)) - Mth.m_14143_((float)modifier) * 10;
            }

            @Override
            public int getSpellTime() {
                return 40;
            }
        }
        ,
        FIREBALL{
            private static final int AMOUNT = 8;

            @Override
            public void start(WitheredSymbiontEntity owner, LivingEntity target) {
                owner.projectiles.clear();
                double y = owner.m_20188_() + 4.0;
                int amount = 8;
                for (int i = 0; i < amount; ++i) {
                    float theta = (float)(Math.PI * 2 / (double)amount);
                    float angle = theta * (float)i;
                    double x = 7.0 * (double)Mth.m_14089_((float)angle) + owner.m_20185_();
                    double z = 7.0 * (double)Mth.m_14031_((float)angle) + owner.m_20189_();
                    LargeFireball projectile = new LargeFireball(owner.m_9236_(), (LivingEntity)owner, 0.0, 0.0, 0.0, 1);
                    projectile.m_6034_(x, y, z);
                    projectile.m_20242_(true);
                    owner.m_9236_().m_7967_((Entity)projectile);
                    owner.projectiles.add((Projectile)projectile);
                }
            }

            @Override
            public void cast(WitheredSymbiontEntity owner, LivingEntity target) {
            }

            @Override
            public void doCasting(WitheredSymbiontEntity owner, LivingEntity target) {
                int spellCastingTime = this.getSpellTime() - owner.spellCastingTime;
                for (int i = 0; i < owner.projectiles.size(); ++i) {
                    Projectile projectile = owner.projectiles.get(i);
                    if (projectile instanceof AbstractHurtingProjectile && projectile.m_6084_()) {
                        float theta = 0.7853982f;
                        float angle = theta * (float)i + (float)spellCastingTime * 0.08f;
                        double radius = 7.0;
                        double x = radius * (double)Mth.m_14089_((float)angle) + owner.m_20185_();
                        double y = owner.m_20188_() + 4.0;
                        double z = radius * (double)Mth.m_14031_((float)angle) + owner.m_20189_();
                        Vec3 wanted = new Vec3(x, y, z);
                        AbstractHurtingProjectile damaging = (AbstractHurtingProjectile)owner.projectiles.get(i);
                        double distance = damaging.m_20182_().m_82554_(wanted);
                        double multiplier = Math.min(1.0, distance);
                        Vec3 delta = wanted.m_82546_(damaging.m_20182_()).m_82541_().m_82542_(multiplier, multiplier, multiplier);
                        if (spellCastingTime % 20 == 0 && i == 0) {
                            Vec3 targetDelta = owner.getRandomNearbyTargetOrFallback(target).m_20299_(1.0f).m_82546_(damaging.m_20182_()).m_82541_().m_82542_(0.3, 0.3, 0.3);
                            damaging.m_5496_(SoundEvents.f_11705_, 4.0f, 1.0f);
                            owner.projectiles.remove(i);
                            damaging.m_20256_(Vec3.f_82478_);
                            damaging.f_36813_ = targetDelta.m_7096_();
                            damaging.f_36814_ = targetDelta.m_7098_();
                            damaging.f_36815_ = targetDelta.m_7094_();
                            UpdateDamagingProjectileMessage message = new UpdateDamagingProjectileMessage(damaging);
                            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> damaging), (Object)message);
                            continue;
                        }
                        damaging.m_20256_(delta);
                        continue;
                    }
                    owner.projectiles.remove(i);
                }
            }

            @Override
            public void finish(WitheredSymbiontEntity owner) {
                for (Projectile projectile : owner.projectiles) {
                    projectile.m_146870_();
                }
            }

            @Override
            public int getDelay(RandomSource random, float modifier) {
                return Math.max(400, random.m_188503_(520)) - Mth.m_14143_((float)modifier) * 10;
            }

            @Override
            public int getSpellTime() {
                return 160;
            }
        }
        ,
        WITHER_SKULLS{

            @Override
            public void cast(WitheredSymbiontEntity owner, LivingEntity target) {
            }

            @Override
            public void doCasting(WitheredSymbiontEntity owner, LivingEntity target) {
                if (owner.f_19797_ % (owner.shouldIncreaseDifficulty() ? 10 : 20) == 0) {
                    int spellCastingTime = this.getSpellTime() - owner.spellCastingTime;
                    double radius = 2.0;
                    float angle = (float)spellCastingTime * 0.08f;
                    float angleBetweenTarget = (float)Math.atan2(target.m_20185_() - owner.m_20185_(), target.m_20189_() - owner.m_20189_());
                    float offset = 1.5707964f;
                    double xOffset = (double)Mth.m_14089_((float)(offset - angleBetweenTarget)) * radius;
                    double zOffset = (double)Mth.m_14031_((float)(offset - angleBetweenTarget)) * radius;
                    double rawX = (double)(Mth.m_14089_((float)angle) * Mth.m_14089_((float)(offset * 2.0f - angleBetweenTarget))) * radius;
                    double rawY = (double)Mth.m_14031_((float)angle) * radius;
                    double rawZ = (double)(Mth.m_14089_((float)angle) * Mth.m_14031_((float)(offset * 2.0f - angleBetweenTarget))) * radius;
                    double x = xOffset + rawX + owner.m_20185_();
                    double y = owner.m_20188_() + rawY;
                    double z = zOffset + rawZ + owner.m_20189_();
                    Vec3 skullPose = new Vec3(x, y, z);
                    Vec3 delta = skullPose.m_82546_(target.m_20299_(1.0f)).m_82541_().m_82490_(-2.5);
                    WitherSkull skull = new WitherSkull(owner.m_9236_(), (LivingEntity)owner, delta.m_7096_(), delta.m_7098_(), delta.m_7094_());
                    skull.m_6034_(x, y, z);
                    owner.m_9236_().m_7967_((Entity)skull);
                    skull.m_5496_(SoundEvents.f_12558_, 4.0f, 1.0f);
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 20, owner.f_19796_.m_188583_(), owner.f_19796_.m_188583_(), owner.f_19796_.m_188583_(), 0.01);
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)WitherStormModParticleTypes.COMMAND_BLOCK.get()), x, y, z, 20, owner.f_19796_.m_188583_(), owner.f_19796_.m_188583_(), owner.f_19796_.m_188583_(), 0.2);
                }
            }

            @Override
            public int getDelay(RandomSource random, float modifier) {
                return Math.max(440, random.m_188503_(580)) - Mth.m_14143_((float)modifier) * 10;
            }

            @Override
            public int getSpellTime() {
                return 220;
            }
        }
        ,
        PULL{

            @Override
            public void cast(WitheredSymbiontEntity owner, LivingEntity target) {
            }

            @Override
            public void doCasting(WitheredSymbiontEntity owner, LivingEntity target) {
                if (target.m_6084_()) {
                    Vec3 delta = owner.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82490_(0.1);
                    if ((double)target.m_20270_((Entity)owner) < 3.0) {
                        owner.breakSpell();
                        return;
                    }
                    delta = new Vec3(delta.m_7096_(), target.m_20184_().m_7098_(), delta.m_7094_());
                    target.m_20256_(delta);
                    if (target instanceof ServerPlayer) {
                        PlayerMotionMessage message = new PlayerMotionMessage(delta);
                        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)target), (Object)message);
                    }
                    double x = target.m_20185_() + target.m_217043_().m_188583_() * target.m_20191_().m_82362_() * 0.4;
                    double y = target.m_20191_().m_82399_().f_82480_ + target.m_217043_().m_188583_() * target.m_20191_().m_82376_() * 0.4;
                    double z = target.m_20189_() + target.m_217043_().m_188583_() * target.m_20191_().m_82385_() * 0.4;
                    Vec3 particleDelta = owner.m_20299_(1.0f).m_82492_(x, y, z).m_82541_().m_82490_(0.1);
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)WitherStormModParticleTypes.COMMAND_BLOCK.get()), x, y, z, 0, particleDelta.m_7096_(), particleDelta.m_7098_(), particleDelta.m_7094_(), 1.0);
                }
            }

            @Override
            public void finish(WitheredSymbiontEntity owner) {
                super.finish(owner);
            }

            @Override
            public int getDelay(RandomSource random, float modifier) {
                return Math.max(340, random.m_188503_(420)) - Mth.m_14143_((float)modifier) * 10;
            }

            @Override
            public int getSpellTime() {
                return 240;
            }

            @Override
            public SoundEvent getSoundLoop() {
                return (SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_PULL.get();
            }
        };


        public void start(WitheredSymbiontEntity owner, @Nonnull LivingEntity target) {
        }

        public abstract void cast(WitheredSymbiontEntity var1, @Nonnull LivingEntity var2);

        public void finish(WitheredSymbiontEntity owner) {
            for (Projectile projectile : owner.projectiles) {
                projectile.m_20242_(false);
            }
            owner.projectiles.clear();
        }

        public void doCasting(WitheredSymbiontEntity owner, @Nonnull LivingEntity target) {
        }

        public abstract int getDelay(RandomSource var1, float var2);

        public abstract int getSpellTime();

        @Nullable
        public SoundEvent getSoundLoop() {
            return null;
        }

        public static SpellType random(RandomSource random, SpellType toRemove) {
            SpellType[] spells = (SpellType[])ArrayUtils.remove((Object[])SpellType.values(), (int)0);
            if (ArrayUtils.contains((Object[])spells, (Object)((Object)toRemove))) {
                spells = (SpellType[])ArrayUtils.removeElement((Object[])spells, (Object)((Object)toRemove));
            }
            return (SpellType)((Object)Util.m_214670_((Object[])spells, (RandomSource)random));
        }
    }

    public static class PrepareSpellGoal
    extends Goal {
        protected final WitheredSymbiontEntity entity;

        public PrepareSpellGoal(WitheredSymbiontEntity entity) {
            this.entity = entity;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            if (target != null && target.m_6084_()) {
                if (this.entity.isCastingSpell()) {
                    return false;
                }
                return this.entity.canPickSpell();
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.canPickSpell();
        }

        public void m_8056_() {
            this.entity.setSpell(SpellType.random(this.entity.m_217043_(), this.entity.getSpell()));
            this.entity.useSpellGoal.nextAttackTickCount = this.entity.f_19797_ + 40 + this.entity.m_217043_().m_188503_(20);
            this.entity.m_5496_((SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_PREPARE_SPELL.get(), 4.0f, 1.0f);
            this.entity.nextSpellPickCount = 400 + this.entity.m_217043_().m_188503_(400) - (this.entity.shouldIncreaseDifficulty() ? 320 : 0);
            if (this.entity.shouldNotGoOverHalfHealth() && this.entity.m_21223_() / this.entity.m_21233_() <= 0.5f) {
                this.entity.f_19804_.m_135381_(SHOULD_NOT_GO_OVER_HALF, (Object)false);
            }
        }
    }

    public static class UseSpellGoal
    extends Goal {
        protected final WitheredSymbiontEntity entity;
        protected int nextAttackTickCount;

        public UseSpellGoal(WitheredSymbiontEntity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            if (target != null && target.m_6084_()) {
                if (this.entity.isCastingSpell()) {
                    return false;
                }
                if (!this.entity.hasSpell()) {
                    return false;
                }
                return this.entity.f_19797_ > this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.hasSpell() && this.entity.f_19797_ >= this.nextAttackTickCount || this.entity.isCastingSpell();
        }

        public void m_8056_() {
            float effectiveDifficulty = this.entity.m_9236_().m_6436_(this.entity.m_20183_()).m_19056_();
            int spellDelay = this.entity.getSpell().getDelay(this.entity.m_217043_(), effectiveDifficulty + (float)(this.entity.shouldIncreaseDifficulty() ? 60 : 0));
            if (spellDelay < this.entity.getSpell().getSpellTime() + 10) {
                spellDelay = this.entity.getSpell().getSpellTime() + 10;
            }
            this.nextAttackTickCount = this.entity.f_19797_ + spellDelay;
            this.entity.m_5496_((SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_CAST_SPELL.get(), 4.0f, 1.0f);
            this.entity.beginSpellCasting();
            ++this.entity.spellsUsed;
        }
    }

    public static class SummonMobsGoal
    extends Goal {
        protected final WitheredSymbiontEntity entity;
        protected final List<EntityType<? extends Monster>> spawnTypes;
        protected int time;

        public SummonMobsGoal(WitheredSymbiontEntity entity, List<EntityType<? extends Monster>> types) {
            this.entity = entity;
            this.spawnTypes = types;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            if (target != null && target.m_6084_()) {
                return !this.spawnTypes.isEmpty();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() && this.time > 0;
        }

        public void m_8056_() {
            this.time = 60 + this.entity.f_19796_.m_188503_(60) + (this.entity.shouldIncreaseDifficulty() ? 40 : 0);
            this.entity.m_5496_((SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_SUMMON.get(), 4.0f, 1.0f);
        }

        public void m_8037_() {
            if (this.time > 0) {
                --this.time;
                if (this.time % 10 == 0) {
                    LivingEntity target = this.entity.m_5448_();
                    EntityType<? extends Monster> type = this.spawnTypes.get(this.entity.f_19796_.m_188503_(this.spawnTypes.size()));
                    Monster monster = (Monster)type.m_20615_(this.entity.m_9236_());
                    float angle = -((float)Math.atan2(target.m_20185_() - this.entity.m_20185_(), target.m_20189_() - this.entity.m_20189_())) + 1.5707964f;
                    float spawnX = Mth.m_14089_((float)angle) * 7.0f + (float)this.entity.m_20185_();
                    float spawnZ = Mth.m_14031_((float)angle) * 7.0f + (float)this.entity.m_20189_();
                    double x = (double)spawnX + (double)this.entity.m_20205_() * (2.0 * this.entity.f_19796_.m_188500_() - 1.0) * 5.0;
                    double y = this.entity.m_20188_() + 5.0;
                    double z = (double)spawnZ + (double)this.entity.m_20205_() * (2.0 * this.entity.f_19796_.m_188500_() - 1.0) * 5.0;
                    BlockPos pos = new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
                    boolean flag = false;
                    do {
                        BlockPos below = pos.m_7495_();
                        BlockState state = this.entity.m_9236_().m_8055_(below);
                        if (!state.m_60783_((BlockGetter)this.entity.m_9236_(), below, Direction.UP) || !state.m_60643_((BlockGetter)this.entity.m_9236_(), below, type)) continue;
                        VoxelShape shape = state.m_60812_((BlockGetter)this.entity.m_9236_(), pos);
                        if (!shape.m_83281_()) {
                            y = shape.m_83297_(Direction.Axis.Y) + (double)pos.m_123342_();
                        }
                        flag = true;
                        break;
                    } while ((pos = pos.m_7495_()).m_123342_() >= Mth.m_14107_((double)(this.entity.m_20186_() - 5.0)) - 1);
                    if (flag) {
                        monster.m_6034_(x, y, z);
                        double deltaX = target.m_20185_() - monster.m_20185_();
                        double deltaY = target.m_20188_() - monster.m_20188_();
                        double deltaZ = target.m_20189_() - monster.m_20189_();
                        double sqrt = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                        float yRot = (float)(Mth.m_14136_((double)deltaZ, (double)deltaX) * 57.2957763671875) - 90.0f;
                        float xRot = (float)(-(Mth.m_14136_((double)deltaY, (double)sqrt) * 57.2957763671875));
                        monster.f_20883_ = yRot;
                        monster.m_146922_(yRot);
                        monster.m_146926_(xRot);
                        this.entity.m_9236_().m_7967_((Entity)monster);
                        ServerLevel serverWorld = (ServerLevel)this.entity.m_9236_();
                        DifficultyInstance difficulty = serverWorld.m_6436_(monster.m_20183_());
                        ForgeEventFactory.onFinalizeSpawn((Mob)monster, (ServerLevelAccessor)serverWorld, (DifficultyInstance)difficulty, (MobSpawnType)MobSpawnType.TRIGGERED, null, null);
                        if (!(monster instanceof SickenedSpider) && !(monster instanceof SickenedCreeper)) {
                            if (!monster.m_21033_(EquipmentSlot.HEAD)) {
                                monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(monster.m_217043_().m_188503_(10) <= 2 ? Items.f_42468_ : Items.f_42476_)));
                            }
                            if (!monster.m_21033_(EquipmentSlot.CHEST) && monster.m_217043_().m_188499_()) {
                                ItemStack chestStack = new ItemStack((ItemLike)Items.f_42469_);
                                if (this.entity.shouldIncreaseDifficulty() && this.entity.m_217043_().m_188503_(10) <= 1) {
                                    chestStack = new ItemStack((ItemLike)Items.f_42473_);
                                }
                                monster.m_8061_(EquipmentSlot.CHEST, EnchantmentHelper.m_220292_((RandomSource)monster.m_217043_(), (ItemStack)chestStack, (int)((int)(5.0f + difficulty.m_19057_() * (float)monster.m_217043_().m_188503_(18))), (boolean)false));
                            }
                            if (!monster.m_21033_(EquipmentSlot.FEET) && monster.m_217043_().m_188499_()) {
                                monster.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)(monster.m_217043_().m_188503_(10) <= 8 ? Items.f_42463_ : Items.f_42479_)));
                            }
                        }
                        monster.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("0043CDFC-9359-441E-BA27-409348BBA377", 20.0, AttributeModifier.Operation.ADDITION));
                        monster.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("FD5BD824-B6A6-426F-9EBF-27304480D99F", -((monster.m_217043_().m_188500_() + 0.5) * 5.0), AttributeModifier.Operation.ADDITION));
                        monster.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("A79A6851-BD1E-43E3-9D56-466EAE581527", -0.04 + monster.m_217043_().m_188500_() * -0.025, AttributeModifier.Operation.ADDITION));
                        monster.m_21373_();
                        monster.m_6710_(this.entity.getRandomNearbyTargetOrFallback(this.entity.m_5448_()));
                        serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)WitherStormModParticleTypes.COMMAND_BLOCK.get()), monster.m_20185_(), monster.m_20188_(), monster.m_20189_(), 20, this.entity.f_19796_.m_188583_(), this.entity.f_19796_.m_188583_(), this.entity.f_19796_.m_188583_(), 0.2);
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123755_, monster.m_20185_(), monster.m_20188_(), monster.m_20189_(), 20, this.entity.f_19796_.m_188583_(), this.entity.f_19796_.m_188583_(), this.entity.f_19796_.m_188583_(), 0.01);
                    }
                }
            }
        }

        public void m_8041_() {
            this.entity.nextStage();
        }
    }

    public static class DoNothingGoal
    extends Goal {
        protected final WitheredSymbiontEntity entity;

        public DoNothingGoal(WitheredSymbiontEntity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return this.entity.isVulnerable();
        }

        public void m_8037_() {
            float speed = 3.0f;
            float f = Mth.m_14118_((float)this.entity.m_146909_(), (float)55.0f);
            float f1 = Mth.m_14036_((float)f, (float)(-speed), (float)speed);
            this.entity.m_146926_(this.entity.m_146909_() + f1);
        }
    }

    public static class SetSpellTimeMessage
    extends Message<SetSpellTimeMessage> {
        private int id;
        private int time;

        public SetSpellTimeMessage(int id, int time) {
            super(true);
            this.id = id;
            this.time = time;
        }

        public SetSpellTimeMessage() {
            super(false);
        }

        @Override
        public void decode(SetSpellTimeMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
            message.id = buffer.m_130242_();
            message.time = buffer.readInt();
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            super.encode(buffer);
            buffer.m_130130_(this.id);
            buffer.writeInt(this.time);
        }

        @Override
        public Runnable getProcessor(SetSpellTimeMessage message, NetworkEvent.Context context) {
            return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                Optional optional = (Optional)LogicalSidedProvider.CLIENTWORLD.get(context.getDirection().getReceptionSide());
                optional.ifPresent(world -> {
                    Entity entity = world.m_6815_(message.id);
                    if (entity instanceof WitheredSymbiontEntity) {
                        WitheredSymbiontEntity symbiont = (WitheredSymbiontEntity)entity;
                        symbiont.spellCastingTime = message.time;
                    }
                });
            });
        }
    }
}

