/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.config.preset;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import nonamecrackers2.witherstormmod.common.config.ConfigHolder;
import nonamecrackers2.witherstormmod.common.config.ReloadType;

public class ConfigPreset {
    private final ConfigHolder config;
    private final Map<ForgeConfigSpec.ConfigValue<?>, Object> values;
    private final MutableComponent translatedName;
    @Nullable
    private MutableComponent description;
    private final ResourceLocation name;
    private final Optional<ConfigPreset> parent;
    private final boolean isDefault;

    private ConfigPreset(ConfigHolder config, Map<ForgeConfigSpec.ConfigValue<?>, Object> map, MutableComponent translated, ResourceLocation location, boolean isDefault, Optional<ConfigPreset> parent) {
        this.config = config;
        this.values = map;
        this.translatedName = translated;
        this.name = location;
        this.isDefault = isDefault;
        this.parent = parent;
    }

    public ConfigPreset withDescription(MutableComponent components) {
        this.description = components;
        return this;
    }

    public <T> T getPresetValue(ForgeConfigSpec.ConfigValue<T> config) {
        return (T)this.values.get(config);
    }

    public Map<ForgeConfigSpec.ConfigValue<?>, ?> getValues() {
        return this.values;
    }

    public MutableComponent getTranslationName() {
        return this.translatedName;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public Component getTooltip(boolean hasShiftDown) {
        MutableComponent tooltip = Component.m_237113_((String)this.translatedName.getString());
        if (!hasShiftDown) {
            tooltip.m_130946_("\n");
            tooltip.m_7220_((Component)Component.m_237115_((String)"gui.witherstormmod.button.preset.holdShift").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            this.getParent().ifPresent(preset -> {
                String[] parentComponents = preset.description.getString().split("\n");
                for (int i = 0; i < parentComponents.length; ++i) {
                    tooltip.m_130946_("\n");
                    tooltip.m_7220_((Component)Component.m_237113_((String)parentComponents[i].trim()).m_130940_(ChatFormatting.GRAY));
                }
            });
            if (this.description != null) {
                String[] components = this.description.getString().split("\n");
                for (int i = 0; i < components.length; ++i) {
                    tooltip.m_130946_("\n");
                    tooltip.m_7220_((Component)Component.m_237113_((String)components[i].trim()).m_130940_(ChatFormatting.GRAY));
                }
            }
            HashSet<ReloadType> reloadTypes = new HashSet<ReloadType>();
            for (Map.Entry<ForgeConfigSpec.ConfigValue<?>, ?> entry : this.getValues().entrySet()) {
                ReloadType reloadType = ConfigHolder.getReloadType(entry.getKey());
                if (reloadType == ReloadType.NONE) continue;
                reloadTypes.add(reloadType);
            }
            for (ReloadType reloadType : reloadTypes) {
                tooltip.m_130946_("\n");
                tooltip.m_7220_((Component)Component.m_237113_((String)("May require reload of: " + reloadType.toString())).m_130940_(ChatFormatting.YELLOW));
            }
            tooltip.m_130946_("\n");
            tooltip.m_7220_((Component)Component.m_237113_((String)this.name.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            this.getParent().ifPresent(parent -> {
                tooltip.m_130946_("\n");
                tooltip.m_7220_((Component)Component.m_237113_((String)("parent: " + parent.getName().toString())).m_130940_(ChatFormatting.DARK_GRAY));
            });
            tooltip.m_130946_("\n");
            tooltip.m_7220_((Component)Component.m_237115_((String)"config.witherstormmod.preset.note").m_130940_(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    public <T> boolean doesValueMatch(ForgeConfigSpec.ConfigValue<T> config, T value) {
        if (!this.values.isEmpty()) {
            Object presetValue = this.values.get(config);
            if (presetValue != null) {
                return value.equals(presetValue);
            }
            return true;
        }
        return true;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public ConfigHolder getAssociatedConfig() {
        return this.config;
    }

    public Optional<ConfigPreset> getParent() {
        return this.parent;
    }

    public String toString() {
        return "ConfigPreset[" + this.translatedName.getString() + "]";
    }

    public static class Builder {
        private final ConfigHolder config;
        private final Map<ForgeConfigSpec.ConfigValue<?>, Object> values;
        private boolean isDefault;
        private Optional<ConfigPreset> parent = Optional.empty();

        private Builder(ConfigHolder config, Map<ForgeConfigSpec.ConfigValue<?>, Object> map) {
            this.config = config;
            this.values = map;
        }

        public static Builder of(ConfigHolder config) {
            HashMap map = Maps.newHashMap();
            config.getValues().forEach(value -> {
                if (!config.shouldExclude((ForgeConfigSpec.ConfigValue<?>)value)) {
                    map.put(value, value.getDefault());
                }
            });
            return new Builder(config, map).setDefault(true);
        }

        public static Builder ofPreset(ConfigPreset preset) {
            if (preset.config != null) {
                HashMap map = Maps.newHashMap();
                preset.getValues().forEach((key, value) -> map.put(key, value));
                return new Builder(preset.getAssociatedConfig(), map).setParent(preset).setDefault(preset.isDefault());
            }
            throw new NullPointerException("Cannot construct ConfigPreset based off of another ConfigPreset with a null config");
        }

        public static <T> Builder empty() {
            return new Builder(null, Maps.newHashMap());
        }

        public <T> Builder setConfigPreset(ForgeConfigSpec.ConfigValue<T> config, T value) {
            this.values.computeIfPresent(config, (key, old) -> value);
            return this.setDefault(false);
        }

        private Builder setDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        private Builder setParent(ConfigPreset preset) {
            this.parent = Optional.of(preset);
            return this;
        }

        public ConfigPreset build(MutableComponent translation, ResourceLocation name) {
            return new ConfigPreset(this.config, Maps.newLinkedHashMap(this.values), translation, name, this.isDefault, this.parent);
        }
    }
}

