/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import nonamecrackers2.witherstormmod.common.config.ConfigHolder;
import nonamecrackers2.witherstormmod.common.config.ReloadType;
import nonamecrackers2.witherstormmod.common.config.preset.ConfigPreset;
import nonamecrackers2.witherstormmod.common.entity.ai.witherstorm.ultimatetarget.UltimateTargetManager;
import nonamecrackers2.witherstormmod.common.init.WitherStormModAttributes;
import org.apache.commons.lang3.tuple.Pair;

public class WitherStormModConfig {
    private static final Map<ModConfig.Type, ConfigHolder> ALL_CONFIGS;
    private static final List<ForgeConfigSpec> ALL_SPECS;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    public static Map<ModConfig.Type, ConfigHolder> getAllConfigs() {
        return ALL_CONFIGS;
    }

    public static List<ForgeConfigSpec> getAllSpecs() {
        return ALL_SPECS;
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (ClientConfig)clientSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (CommonConfig)commonSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (ServerConfig)serverSpecPair.getLeft();
        ALL_CONFIGS = ImmutableMap.of((Object)ModConfig.Type.CLIENT, (Object)CLIENT, (Object)ModConfig.Type.COMMON, (Object)COMMON, (Object)ModConfig.Type.SERVER, (Object)SERVER);
        ALL_SPECS = ImmutableList.of((Object)CLIENT_SPEC, (Object)COMMON_SPEC, (Object)SERVER_SPEC);
    }

    public static class ClientConfig
    extends ConfigHolder {
        public final ForgeConfigSpec.ConfigValue<Boolean> renderDebrisCloud;
        public final ForgeConfigSpec.ConfigValue<Boolean> renderDebrisRings;
        public final ForgeConfigSpec.ConfigValue<Boolean> renderDistantDebris;
        public final ForgeConfigSpec.ConfigValue<Boolean> witherStormLOD;
        public final ForgeConfigSpec.ConfigValue<Boolean> lowResModels;
        public final ForgeConfigSpec.ConfigValue<Boolean> renderTractorBeams;
        public final ForgeConfigSpec.ConfigValue<Boolean> renderPulse;
        public final ForgeConfigSpec.ConfigValue<Boolean> distantRenderer;
        public final ForgeConfigSpec.ConfigValue<Boolean> blockClusterRendering;
        public final ForgeConfigSpec.ConfigValue<Boolean> witherSicknessLayer;
        public final ForgeConfigSpec.ConfigValue<Boolean> playWitherStormTheme;
        public final ForgeConfigSpec.ConfigValue<Boolean> playSymbiontTheme;
        public final ForgeConfigSpec.ConfigValue<Boolean> chromaticAberration;
        public final ForgeConfigSpec.ConfigValue<Boolean> blindingEffects;
        public final ForgeConfigSpec.ConfigValue<Boolean> cameraShakeEffects;
        public final ForgeConfigSpec.ConfigValue<Boolean> distantFog;
        public final ForgeConfigSpec.ConfigValue<Boolean> earRingingEffects;
        public final ForgeConfigSpec.ConfigValue<Boolean> renderTractorBeamOverlay;
        public final ForgeConfigSpec.ConfigValue<Boolean> renderSkyAmbienceEffects;
        public final ForgeConfigSpec.ConfigValue<Boolean> tractorBeamParticles;
        public final ForgeConfigSpec.ConfigValue<Boolean> renderShine;
        public final ForgeConfigSpec.ConfigValue<Boolean> alternativeEntityFogShape;
        public final ForgeConfigSpec.ConfigValue<Boolean> optifineWarning;
        public final ForgeConfigSpec.ConfigValue<Boolean> aprilFools;
        public final ForgeConfigSpec.ConfigValue<Boolean> vertexBufferRendering;
        public final ForgeConfigSpec.ConfigValue<Boolean> patronCosmetic;
        public final ForgeConfigSpec.ConfigValue<Boolean> customPanorama;
        public final ForgeConfigSpec.ConfigValue<Boolean> asyncBufferBuilders;

        private ClientConfig(ForgeConfigSpec.Builder builder) {
            super(ModConfig.Type.CLIENT);
            builder.comment("Client options").push("client");
            builder.comment("Compatibility").push("compatibility");
            this.alternativeEntityFogShape = this.createValue(builder, true, "alternativeEntityFogShape", ReloadType.NONE, "Uses the sphere fog shape instead of a cylindrical", "one, to allow the fog on the Wither Storm", "to be applied correctly. Disable if facing", "potential incompatibility issues");
            this.distantRenderer = this.createValue(builder, true, "distantRenderer", ReloadType.NONE, "The distant renderer allows for the Wither Storm", "to be rendered from much greater distances", "than what vanilla allows. Disable if you're", "facing issues with it");
            this.witherSicknessLayer = this.createValue(builder, true, "witherSicknessLayer", ReloadType.GAME, "Specifies if an overlay should be applied to entities", "that renders wither sickness");
            builder.pop();
            builder.comment("Accessibility").push("accessibility");
            this.chromaticAberration = this.createValue(builder, true, "chromaticAberration", ReloadType.NONE, "Toggle to enable/disable the chromatic aberration effect");
            this.blindingEffects = this.createValue(builder, true, "blindingEffects", ReloadType.NONE, "Specifies whether or not a white overlay should cover", "the screen during certain events");
            this.cameraShakeEffects = this.createValue(builder, true, "cameraShakeEffects", ReloadType.NONE, "Specifies whether or not camera shake effects", "should be used");
            this.earRingingEffects = this.createValue(builder, true, "earRingingEffects", ReloadType.NONE, "Turn off to disable the ear ringing", "effects used in the mod");
            builder.pop();
            builder.comment("Preference").push("preference");
            this.renderDebrisCloud = this.createValue(builder, true, "renderDebrisCloud", ReloadType.NONE, "Toggles the rendering of the debris cloud", "surrounding the Wither Storm");
            this.renderDebrisRings = this.createValue(builder, true, "renderDebrisRings", ReloadType.NONE, "Toggles the rendering of debris rings", "that surround the Wither Storm (much more performant", "than the debris cloud)");
            this.renderTractorBeams = this.createValue(builder, true, "renderTractorBeams", ReloadType.NONE, "Toggles the rendering of the tractor beams");
            this.renderTractorBeamOverlay = this.createValue(builder, true, "renderTractorBeamOverlay", ReloadType.NONE, "Turn off to disable the overlay that", "appears when inside a tractor beam");
            this.renderSkyAmbienceEffects = this.createValue(builder, true, "renderSkyAmbienceEffects", ReloadType.NONE, "Specifies if sky ambience affects (sky darkening)", "should render when a Wither Storm is nearby");
            this.tractorBeamParticles = this.createValue(builder, true, "tractorBeamParticles", ReloadType.NONE, "Specifies if particles inside the tractor", "beams of the Wither Storm should render");
            this.distantFog = this.createValue(builder, true, "distantFog", ReloadType.NONE, "Specifies if fog should be applied to", "Wither Storms being rendered from a distance");
            this.renderShine = this.createValue(builder, true, "renderShine", ReloadType.NONE, "Specifies if a purple shine should render", "behind the Wither Storm at night");
            this.renderPulse = this.createValue(builder, true, "renderPulse", ReloadType.NONE, "Specifies if a pulsating effect, mimicking endermen pulling", "the Wither Storm apart, should be rendered once its", "evolution is complete");
            builder.pop();
            builder.comment("Boss music").push("boss_music");
            this.playWitherStormTheme = this.createValue(builder, false, "playWitherStormTheme", ReloadType.NONE, "Toggles the Wither Storm boss theme. NOTE:", "this theme is from MC:SM and is subject to copyright");
            this.playSymbiontTheme = this.createValue(builder, true, "playSymbiontTheme", ReloadType.NONE, "Toggles the Withered Symbiont theme,", "created for CWSM by Mar Mar");
            builder.pop();
            builder.comment("Instancing").push("instancing");
            this.vertexBufferRendering = this.createValue(builder, true, "vertexBufferRendering", ReloadType.NONE, "Specifies if CWSM should use more performant", "rendering when rendering Block Clusters and the", "Wither Storm's mass. NOTE: It is not recommended", "to disable this option unless necessary");
            this.asyncBufferBuilders = this.createValue(builder, true, "asyncBufferBuilders", ReloadType.NONE, "Builds instanced vertex buffers off thread to help reduce stuttering. It is only recommended to disable this if facing compatibility issues");
            builder.pop();
            builder.comment("Performance").push("performance");
            this.renderDistantDebris = this.createValue(builder, true, "renderDistantDebris", ReloadType.NONE, "Setting this value to false will disable the debris", "cloud when rendering the Wither Storm from large", "distances");
            this.witherStormLOD = this.createValue(builder, false, "witherStormLOD", ReloadType.NONE, "Specifies if the low res models should", "be used when being rendered via the distant", "renderer");
            this.lowResModels = this.createValue(builder, false, "lowResModels", ReloadType.NONE, "Uses larger cubes to make up the the phase 4 and up models.", "May result in a performance increase");
            this.blockClusterRendering = this.createValue(builder, true, "blockClusterRendering", ReloadType.NONE, "Toggles the rendering of Block Clusters");
            builder.pop();
            this.optifineWarning = this.createValue(builder, true, "optifineWarning", ReloadType.NONE, "Toggles the OptiFine warning upon joining", "a world");
            this.aprilFools = this.createValue(builder, true, "aprilFools", ReloadType.NONE, "Toggles April Fools special effects");
            this.patronCosmetic = this.createValue(builder, true, "patronCosmetic", ReloadType.NONE, "Toggles the patron cosmetic for nonamecrackers2's Wither Storm backers");
            this.customPanorama = this.createValue(builder, true, "customPanorama", ReloadType.NONE, "Toggles the custom main menu panorama added by the mod");
            this.excludeFromPresets(this.playWitherStormTheme);
            this.excludeFromPresets(this.playSymbiontTheme);
            this.excludeFromPresets(this.chromaticAberration);
            this.excludeFromPresets(this.blindingEffects);
            this.excludeFromPresets(this.cameraShakeEffects);
            this.excludeFromPresets(this.distantFog);
            this.excludeFromPresets(this.earRingingEffects);
            this.excludeFromPresets(this.renderTractorBeamOverlay);
            this.excludeFromPresets(this.renderSkyAmbienceEffects);
            this.excludeFromPresets(this.tractorBeamParticles);
            this.excludeFromPresets(this.renderShine);
            this.excludeFromPresets(this.alternativeEntityFogShape);
            this.excludeFromPresets(this.distantRenderer);
            this.excludeFromPresets(this.witherSicknessLayer);
            this.excludeFromPresets(this.vertexBufferRendering);
            this.excludeFromPresets(this.optifineWarning);
            this.excludeFromPresets(this.aprilFools);
            this.excludeFromPresets(this.patronCosmetic);
            this.excludeFromPresets(this.customPanorama);
            this.excludeFromPresets(this.asyncBufferBuilders);
            ConfigPreset highPreset = ConfigPreset.Builder.of(this).build(Component.m_237115_((String)"config.witherstormmod.preset.client.high.title"), new ResourceLocation("witherstormmod", "high_client")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.client.high.description"));
            ConfigPreset mediumPreset = ConfigPreset.Builder.of(this).setConfigPreset(this.renderDebrisCloud, false).setConfigPreset(this.tractorBeamParticles, false).build(Component.m_237115_((String)"config.witherstormmod.preset.client.medium.title"), new ResourceLocation("witherstormmod", "medium_client")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.client.medium.description"));
            ConfigPreset lowPreset = ConfigPreset.Builder.of(this).setConfigPreset(this.blockClusterRendering, false).setConfigPreset(this.renderDebrisCloud, false).setConfigPreset(this.tractorBeamParticles, false).setConfigPreset(this.witherStormLOD, true).build(Component.m_237115_((String)"config.witherstormmod.preset.client.low.title"), new ResourceLocation("witherstormmod", "low_client")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.client.low.description"));
            ConfigPreset ultraLowPreset = ConfigPreset.Builder.of(this).setConfigPreset(this.blockClusterRendering, false).setConfigPreset(this.renderDebrisCloud, false).setConfigPreset(this.tractorBeamParticles, false).setConfigPreset(this.lowResModels, true).build(Component.m_237115_((String)"config.witherstormmod.preset.client.ultra_low.title"), new ResourceLocation("witherstormmod", "ultra_low_client")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.client.ultra_low.description"));
            this.putPresets(highPreset, mediumPreset, lowPreset, ultraLowPreset);
            builder.pop();
        }
    }

    public static class CommonConfig
    extends ConfigHolder {
        public final ForgeConfigSpec.ConfigValue<Boolean> playerFavorability;
        public final ForgeConfigSpec.ConfigValue<Boolean> blockClustersDropItems;
        public final ForgeConfigSpec.ConfigValue<Boolean> shouldPickUpVehicles;
        public final ForgeConfigSpec.ConfigValue<Boolean> phantomsOrbitWitherStorm;
        public final ForgeConfigSpec.ConfigValue<Boolean> playerCannotDismountTentacles;
        public final ForgeConfigSpec.ConfigValue<Boolean> injectCustomAiBehavior;

        private CommonConfig(ForgeConfigSpec.Builder builder) {
            super(ModConfig.Type.COMMON);
            builder.comment("Common options").push("common");
            this.playerFavorability = this.createValue(builder, true, "playerFavorability", ReloadType.NONE, "This feature makes the Wither Storm more likely", "to choose nearby players as targets", "instead of other mobs");
            this.blockClustersDropItems = this.createValue(builder, false, "blockClustersDropItems", ReloadType.WORLD, "Toggle to enable/disable drops from Block Clusters.", "NOTE: Enabling this feature can cause world lag");
            this.shouldPickUpVehicles = this.createValue(builder, true, "shouldPickUpVehicles", ReloadType.NONE, "Specifies if the current entity the Wither Storm", "is picking up has a vehicle, that it should", "pick it up as well. Ex: Should pick up a player riding a boat");
            this.phantomsOrbitWitherStorm = this.createValue(builder, true, "phantomsOrbitWitherStorm", ReloadType.WORLD, "Specifies if phantoms AI should be overriden to", "allow circling above any nearby Wither Storms.", "Disable if you wish for default behaviour and/or if issues arise");
            this.playerCannotDismountTentacles = this.createValue(builder, true, "playerCannotDismountTentacles", ReloadType.NONE, "Specifies if players should not be able", "to dismount a tentacle entity. Disable", "if facing compatibility issues");
            this.injectCustomAiBehavior = this.createValue(builder, true, "injectCustomAiBehavior", ReloadType.WORLD, "Specifies if custom AI behavior should be injected", "into certain entities (such as mobs running away", "from the Wither Storm). Disable if facing compatibility", "issues");
            ConfigPreset defaultPreset = ConfigPreset.Builder.of(this).build(Component.m_237115_((String)"config.witherstormmod.preset.default.title"), new ResourceLocation("witherstormmod", "default_common")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.default.description"));
            this.putPresets(defaultPreset);
            builder.pop();
        }
    }

    public static class ServerConfig
    extends ConfigHolder {
        private static final String EVOLUTION_MODIFIER_UUID = "A95E1FBA-3DC1-40B0-A8E3-01C81B540444";
        private static final String TARGET_STATIONARY_FLYING_MODIFIER_UUID = "FB8F759A-7025-4684-AF6B-4B67A7E1422A";
        private static final String SLOW_FLYING_MODIFIER_UUID = "0d94f8c8-355c-44db-b75a-9823e5516ce5";
        public final ForgeConfigSpec.ConfigValue<Boolean> shouldChunkLoadWhenNoPlayers;
        public final ForgeConfigSpec.ConfigValue<Boolean> shouldChaseWhenTargetStopped;
        public final ForgeConfigSpec.ConfigValue<Integer> targetStationaryChunkRadius;
        public final ForgeConfigSpec.ConfigValue<Integer> playerPickupChance;
        public final ForgeConfigSpec.ConfigValue<Double> evolutionAttributeModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> targetStationaryMinutes;
        public final ForgeConfigSpec.ConfigValue<Integer> targetRunawayMinutes;
        public final ForgeConfigSpec.ConfigValue<Integer> invulnerabilityTime;
        public final ForgeConfigSpec.ConfigValue<Double> chasingFlyingSpeed;
        public final ForgeConfigSpec.ConfigValue<Double> normalFlyingSpeed;
        public final ForgeConfigSpec.ConfigValue<Boolean> usePhaseAsDistanceMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> distanceMultiplier;
        public final ForgeConfigSpec.ConfigValue<Boolean> chaseOnPhaseChange;
        public final ForgeConfigSpec.ConfigValue<Boolean> targetRunawayAttempts;
        public final ForgeConfigSpec.ConfigValue<Integer> targetRunawayAttemptMinutes;
        public final ForgeConfigSpec.ConfigValue<Integer> targetRunawayAttemptsRequired;
        public final ForgeConfigSpec.ConfigValue<Integer> minutesTillRunawayAttemptDiminish;
        public final ForgeConfigSpec.ConfigValue<Boolean> targettingDistractionsEnabled;
        public final ForgeConfigSpec.ConfigValue<Integer> distractionTimeMinutes;
        public final ForgeConfigSpec.ConfigValue<Integer> maximumDistractionDistance;
        public final ForgeConfigSpec.ConfigValue<Integer> minimumDistractionDistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> randomDistractionChances;
        public final ForgeConfigSpec.ConfigValue<Integer> searchRangeMultiplier;
        public final ForgeConfigSpec.ConfigValue<Integer> distractionWaitTime;
        public final ForgeConfigSpec.ConfigValue<Boolean> clustersRemoveItems;
        public final ForgeConfigSpec.ConfigValue<Boolean> squashHitbox;
        public final ForgeConfigSpec.ConfigValue<Integer> hunchbackClusterPickupInterval;
        public final ForgeConfigSpec.ConfigValue<Integer> clusterPickupInterval;
        public final ForgeConfigSpec.ConfigValue<Integer> devourerClusterPickupInterval;
        public final ForgeConfigSpec.ConfigValue<Integer> flyingHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> tillShouldShowHole;
        public final ForgeConfigSpec.ConfigValue<Double> rotationSpeed;
        public final ForgeConfigSpec.ConfigValue<Boolean> canPickupMobClusters;
        public final ForgeConfigSpec.ConfigValue<Boolean> witherStormInvulnerability;
        public final ForgeConfigSpec.ConfigValue<Boolean> amuletOverride;
        public final ForgeConfigSpec.ConfigValue<Boolean> smartBossbar;
        public final ForgeConfigSpec.ConfigValue<Integer> headEscapeTime;
        public final ForgeConfigSpec.ConfigValue<Boolean> randomBowelsEntrace;
        public final ForgeConfigSpec.ConfigValue<Integer> chunksToLoad;
        public final ForgeConfigSpec.ConfigValue<Boolean> randomStrollingWhenTargetHidden;
        public final ForgeConfigSpec.ConfigValue<Boolean> boatingForTooLongDistractions;
        public final ForgeConfigSpec.ConfigValue<Integer> boatingForTooLongSeconds;
        public final ForgeConfigSpec.ConfigValue<Integer> maxRandomStrollTargetingTypeRadius;
        public final ForgeConfigSpec.ConfigValue<Boolean> ignoreUltimateTargetIfHidden;
        public final ForgeConfigSpec.ConfigValue<Boolean> caveRumbles;
        public final ForgeConfigSpec.ConfigValue<Boolean> crossbowsSupportEnderPearls;
        public final ForgeConfigSpec.ConfigValue<Boolean> removeNearbyKelp;
        public final ForgeConfigSpec.ConfigValue<Boolean> mobsRunIntoPortals;
        public final ForgeConfigSpec.ConfigValue<Boolean> preventWitherStormCamping;
        public final ForgeConfigSpec.ConfigValue<Boolean> occludeSoundsUnderground;
        public final ForgeConfigSpec.ConfigValue<UltimateTargetManager.TargetingType> ultimateTargetingType;
        public final ForgeConfigSpec.ConfigValue<Boolean> witherSicknessEnabled;
        public final ForgeConfigSpec.ConfigValue<Boolean> sickenedMobConversions;
        public final ForgeConfigSpec.ConfigValue<Boolean> increaseAmplifier;
        public final ForgeConfigSpec.ConfigValue<Integer> requiredContacts;
        public final ForgeConfigSpec.ConfigValue<Integer> requiredProximitySeconds;
        public final ForgeConfigSpec.ConfigValue<Integer> applicationDelay;
        public final ForgeConfigSpec.ConfigValue<Integer> cureDelay;
        public final ForgeConfigSpec.ConfigValue<Integer> lowImmuneRequiredProximitySeconds;
        public final ForgeConfigSpec.ConfigValue<Integer> lowImmuneApplicationDelay;
        public final ForgeConfigSpec.ConfigValue<Integer> lowImmuneCureDelay;
        public final ForgeConfigSpec.ConfigValue<Integer> proximitySecondsModifierMax;
        public final ForgeConfigSpec.ConfigValue<Integer> applicationDelayModifierMax;
        public final ForgeConfigSpec.ConfigValue<Integer> cureDelayModifierMax;
        public final ForgeConfigSpec.ConfigValue<Integer> lowImmuneProximityModifierMax;
        public final ForgeConfigSpec.ConfigValue<Integer> lowImmuneApplicationModifierMax;
        public final ForgeConfigSpec.ConfigValue<Integer> lowImmuneCureDelayModifierMax;
        public final ForgeConfigSpec.ConfigValue<Boolean> keepSicknessAfterRespawn;
        public final ForgeConfigSpec.ConfigValue<Integer> craftFuseTicks;
        public final ForgeConfigSpec.ConfigValue<Integer> catchFireFuseTicks;
        public final ForgeConfigSpec.ConfigValue<Integer> dropInterval;
        public final ForgeConfigSpec.ConfigValue<Boolean> shouldDropFromInventory;
        public final ForgeConfigSpec.ConfigValue<Boolean> lowerBlockResistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> revivalTimer;
        public final ForgeConfigSpec.ConfigValue<Integer> revivalTimeMinutes;
        public final ForgeConfigSpec.ConfigValue<Integer> revivalPlayerProtection;
        public final ForgeConfigSpec.ConfigValue<Boolean> canSummonSymbiont;
        public final ForgeConfigSpec.ConfigValue<Integer> minimumSpawnCheckInterval;
        public final ForgeConfigSpec.ConfigValue<Integer> witherStormSummoningDelay;
        public final ForgeConfigSpec.ConfigValue<Integer> playerInvulnerableTime;
        public final ForgeConfigSpec.ConfigValue<Integer> playerSummoningDelay;
        public final ForgeConfigSpec.ConfigValue<Integer> playerSummoningDelayOnKill;
        public final ForgeConfigSpec.ConfigValue<Double> flamingSkullExplosionSize;
        public final ForgeConfigSpec.ConfigValue<Double> flamingSkullSpeedModifier;
        public final ForgeConfigSpec.ConfigValue<Double> tractorPullSpeedModifier;
        public final ForgeConfigSpec.ConfigValue<Boolean> bowelsFallResistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> flyingDisabledWarning;
        public final ForgeConfigSpec.ConfigValue<Boolean> shouldShowHole;
        public final ForgeConfigSpec.ConfigValue<Integer> resummonedPhase;
        public final ForgeConfigSpec.ConfigValue<Integer> minimumRoarInterval;
        public final ForgeConfigSpec.ConfigValue<Integer> maximumRoarInterval;
        public final ForgeConfigSpec.ConfigValue<Integer> clusterSizeModifier;
        public final ForgeConfigSpec.ConfigValue<Boolean> attackableWhenNotVulnerable;
        public final ForgeConfigSpec.ConfigValue<Boolean> bookDropsInInventory;
        public final ForgeConfigSpec.ConfigValue<Boolean> canAttackHeads;
        public final ForgeConfigSpec.ConfigValue<Double> healthScalePerPlayer;
        public final ForgeConfigSpec.ConfigValue<Integer> randomizedTargetingTime;

        protected ServerConfig(ForgeConfigSpec.Builder builder) {
            super(ModConfig.Type.SERVER);
            builder.comment("Server options").push("server");
            builder.comment("Misc").push("misc");
            this.shouldChunkLoadWhenNoPlayers = this.createValue(builder, false, "shouldChunkLoadWhenNoPlayers", ReloadType.NONE, "Toggle to enable/disable Wither Storm chunk loading", "when no players are online");
            this.excludeFromGui(this.shouldChunkLoadWhenNoPlayers);
            this.invulnerabilityTime = this.createRangedIntValue(builder, 50, 1, 320, "invulnerabilityTime", ReloadType.NONE, "Specifies the invulnerability time when the Wither Storm", "has been summoned, in seconds. When invulnerable,", "the Wither Storm doesn't move and can't be attacked");
            this.flyingHeight = this.createRangedIntValue(builder, 75, 10, 150, "flyingHeight", ReloadType.NONE, "Specifies the height the Wither Storm", "will fly at during phase 4 and up");
            this.tillShouldShowHole = this.createRangedIntValue(builder, 6, 1, 30, "tillShouldShowHole", ReloadType.NONE, "If the Wither Storm's ultimate target has", "a command block tool and the Wither Storm is", "at phase 7, a timer specified by this value (in minutes)", "+ random will countdown until the hole will automatically appear");
            this.shouldShowHole = this.createValue(builder, true, "shouldShowHole", ReloadType.NONE, "Specifies if the bowels entrance hole in the Wither Storm's mass at the end of phase 7 should be available or not");
            this.rotationSpeed = this.createRangedDoubleValue(builder, 0.1, 0.1, 1.0, "rotationSpeed", ReloadType.NONE, "Specifies the rotation speed of the Wither Storm");
            this.witherStormInvulnerability = this.createValue(builder, true, "witherStormInvulnerability", ReloadType.NONE, "Specifies if the Wither Storm should", "regenerate its health and be melee attackable");
            this.smartBossbar = this.createValue(builder, true, "smartBossbar", ReloadType.NONE, "The Wither Storm's bossbar and boss music", "will automatically toggle based on whether", "the player is underground or not. Disable", "to revert back to default bossbar/boss theme", "logic");
            this.randomBowelsEntrace = this.createValue(builder, true, "randomBowelsEntrance", ReloadType.NONE, "Specifies if players should spawn somewhere", "random when entering the bowels.", "Disable to revert to a static entrance position");
            this.crossbowsSupportEnderPearls = this.createValue(builder, true, "crossbowsSupportEnderPearls", ReloadType.NONE, "Specifies if crossbows should be able to", "also shoot ender pearls. Disable if facing", "compatibility issues");
            this.preventWitherStormCamping = this.createValue(builder, true, "preventWitherStormCamping", ReloadType.NONE, "Specifies if players should temporarily respawn away from the Wither Storm when they die to it, if their respawn point is near the Storm");
            this.bowelsFallResistance = this.createValue(builder, true, "bowelsFallResistance", ReloadType.NONE, "Specifies if max strength damange resistance should be given to the player when falling out of the bowels, to mitigate fall damage");
            this.resummonedPhase = this.createRangedIntValue(builder, 4, 0, 7, "resummonedPhase", ReloadType.NONE, "Specifies the phase the Wither Storm should be set to when resummoned by a withered beacon");
            this.canAttackHeads = this.createValue(builder, true, "canAttackHeads", ReloadType.NONE, "Specifies if the Wither Storm's heads can be attacked");
            builder.pop();
            builder.comment("Ultimate Target Logic").push("ultimate_target_logic");
            this.ultimateTargetingType = this.createEnumValue(builder, UltimateTargetManager.TargetingType.NEAREST, "ultimateTargetingType", ReloadType.NONE, "Specifies the targeting type the Wither Storm", "should use to determine it's ultimate target");
            this.randomizedTargetingTime = this.createRangedIntValue(builder, 15, 1, 60, "randomizedTargetingTime", ReloadType.NONE, "If you're using RANDOMIZED targeting you can use this to set how often (in minutes) the Wither Storm should switch its targeting type");
            this.amuletOverride = this.createValue(builder, true, "amuletOverride", ReloadType.NONE, "Specifies if the amulet should override", "the Wither Storm's targeting");
            this.maxRandomStrollTargetingTypeRadius = this.createRangedIntValue(builder, 500, 200, 5000, "maxRandomStrollTargetingTypeRadius", ReloadType.NONE, "The max amount of distance a Wither Storm can travel at once when using the RANDOM_STROLL or RANDOM_STROLL_NEAR_PLAYER targeting type");
            this.ignoreUltimateTargetIfHidden = this.createValue(builder, true, "ignoreUltimateTargetIfHidden", ReloadType.NONE, "If the Wither Storm's ultimate target is hidden (bossbar is not visible for that target) for an extended period of time, it will ignore that target temporarily and go for a different player. Toggle to disable. NOTE: Only functional on a multiplayer environment");
            builder.comment("Chases").push("chases");
            this.shouldChaseWhenTargetStopped = this.createValue(builder, true, "shouldChaseWhenTargetStopped", ReloadType.NONE, "If the ultimate target is stationary for a specific amount of time, the Wither Storm will begin to move towards it at a faster rate (chase). Toggle to enable/disable this feature");
            this.chaseOnPhaseChange = this.createValue(builder, true, "chaseOnPhaseChange", ReloadType.NONE, "Specifies if the Wither Storm should accelerate when it evolves into the next phase.");
            builder.pop();
            builder.comment("Target Stationary Logic").push("target_stationary_logic");
            this.targetStationaryChunkRadius = this.createRangedIntValue(builder, 8, 0, 16, "targetStationaryChunkRadius", ReloadType.WORLD, "If the player remains in a radius of chunks specified by", "this value for a specific amount of time,", "the Wither Storm will begin to move towards the player", "at a faster rate");
            this.targetStationaryMinutes = this.createRangedIntValue(builder, 30, 1, 120, "targetStationaryMinutes", ReloadType.WORLD, "Specifies the amount of time in minutes that", "the Wither Storm's ultimate target must", "be stationary in order for it to accelerate");
            this.usePhaseAsDistanceMultiplier = this.createValue(builder, true, "usePhaseAsDistanceMultiplier", ReloadType.NONE, "Specifies if the Wither Storm should use the phase as a", "multiplier when calculating the time in ticks it takes for it", "to start accelerating, when its ultimate target is stationary");
            this.distanceMultiplier = this.createRangedDoubleValue(builder, 1.0, 0.1, 24.0, "distanceMultiplier", ReloadType.NONE, "Specifies if the Wither Storm should use this value as a", "multiplier when calculating the time in ticks it takes for it", "to start accelerating, when its ultimate target is stationary");
            this.targetRunawayMinutes = this.createRangedIntValue(builder, 10, 1, 90, "targetRunawayMinutes", ReloadType.NONE, "Specifies the amount of time in minutes that", "the Wither Storm's ultimate target has begun", "to run away in order to slow back down again");
            builder.pop();
            builder.comment("Runaway Attempts").push("runaway_attempts");
            this.targetRunawayAttempts = this.createValue(builder, true, "targetRunawayAttempts", ReloadType.NONE, "Specifies if the Wither Storm should count the times", "its ultimate target leaves the stationary chunk radius.", "After a specified amount of attempts has been reached,", "the Wither Storm will accelerate to its Target Stationary Speed");
            this.targetRunawayAttemptMinutes = this.createRangedIntValue(builder, 2, 1, 20, "targetRunawayAttemptMinutes", ReloadType.NONE, "Specifies the required time, in minutes, the Wither Storms ultimate", "target must be stationary in order to be able to count", "a runaway attempt when it tries to leave the stationary", "chunk radius");
            this.targetRunawayAttemptsRequired = this.createRangedIntValue(builder, 5, 1, 32, "targetRunawayAttemptsRequired", ReloadType.NONE, "Specifies the amount of runaway attempts made by the Wither Storms ultimate target that must be met for it to begin a chase");
            this.minutesTillRunawayAttemptDiminish = this.createRangedIntValue(builder, 16, 1, 48, "minutesTillRunawayAttemptDiminish", ReloadType.NONE, "Specifies the required time that must pass (in minutes)", "in order to decrease the runaway attempt amount.", "This timer only counts if the Wither Storms ultimate", "target remains in the stationary chunk radius");
            builder.pop();
            builder.comment("Distractions").push("distractions");
            this.targettingDistractionsEnabled = this.createValue(builder, true, "targettingDistractionsEnabled", ReloadType.NONE, "Specifies when the Wither Storm is done chasing", "its ultimate target if it should become", "'distracted' and go to a random nearby area");
            this.distractionTimeMinutes = this.createRangedIntValue(builder, 25, 1, 25, "distractionTimeMinutes", ReloadType.NONE, "Specifies the time in minutes that", "the Wither Storm should be distracted", "for, plus some random modifying and more");
            this.maximumDistractionDistance = this.createRangedIntValue(builder, 1000, 100, 3000, "maximumDistractionDistance", ReloadType.NONE, "Distractions will not occur if the Wither Storm's", "ultimate target is outside the radius determined", "by this value + its target range.", "Although, if the ultimate target is inside the radius,", "but then leaves, a distraction can then later occur");
            this.minimumDistractionDistance = this.createRangedIntValue(builder, 50, 10, 500, "minimumDistractionDistance", ReloadType.NONE, "Distractions will not occur IMMEDIATELY if the", "Wither Storm's ultimate target is INSIDE the", "radius determined by this value + its target range.", "If the target is inside this radius, the", "Wither Storm will wait before becoming distracted,", "to see if the target is outside the radius.", "If not, a distraction will not occur. Set to 0 to disable");
            this.randomDistractionChances = this.createValue(builder, true, "randomDistractionChances", ReloadType.NONE, "Distractions may or may not occur if the", "conditions are met/unmet based off of a random chance.", "Toggle to enable/disable");
            this.searchRangeMultiplier = this.createRangedIntValue(builder, 1, 1, 8, "searchableRangeMultiplier", ReloadType.NONE, "Specifies the search radius multiplier", "for when searching for a random location to", "go to");
            this.distractionWaitTime = this.createRangedIntValue(builder, 2, 1, 20, "distractionWaitTime", ReloadType.NONE, "For when the Wither Storm needs to wait", "to become distracted, this value (in minutes)", "will specifiy the wait time, plus a random", "modifier");
            this.boatingForTooLongDistractions = this.createValue(builder, true, "boatingForTooLongDistractions", ReloadType.NONE, "Specifies if the Wither Storm should get distracted when a player boats across water for too long. Used to prevent specific scenarios where the Wither Storm is chasing players but it can't quite keep up");
            this.boatingForTooLongSeconds = this.createRangedIntValue(builder, 60, 30, 300, "boatingForTooLongSeconds", ReloadType.NONE, "The amount of time a player needs to be boating until the Wither Storm will become distracted");
            builder.pop();
            builder.comment("Random Strolling").push("random_strolling");
            this.randomStrollingWhenTargetHidden = this.createValue(builder, true, "randomStrollingWhenTargetHidden", ReloadType.NONE, "Specifies if the Wither Storm should stroll around the player if they're hidden from the storm");
            builder.pop();
            builder.comment("Speed").push("speed");
            this.chasingFlyingSpeed = this.createRangedDoubleValue(builder, 0.4, 0.01, 1.0, "chasingFlyingSpeed", ReloadType.WORLD, "Specifies a modifier value of Target Stationary Flying Speed attribute.", "The higher the value, the faster the Wither Storm will go when", "its ultimate target is stationary");
            this.addAttributeConfigValue((Supplier<Attribute>)WitherStormModAttributes.TARGET_STATIONARY_FLYING_SPEED, TARGET_STATIONARY_FLYING_MODIFIER_UUID, "Config defined stationary flight speed modifier", AttributeModifier.Operation.ADDITION, this.chasingFlyingSpeed);
            this.normalFlyingSpeed = this.createRangedDoubleValue(builder, 0.02, 0.01, 1.0, "normalFlyingSpeed", ReloadType.WORLD, "Specifies a modifier value of Slow Flying Speed attribute.", "The higher the value, the faster the Wither Storm will go when", "it's ultimate target is not stationary");
            this.addAttributeConfigValue((Supplier<Attribute>)WitherStormModAttributes.SLOW_FLYING_SPEED, SLOW_FLYING_MODIFIER_UUID, "Config defined slow flight speed modifier", AttributeModifier.Operation.ADDITION, this.normalFlyingSpeed);
            builder.pop();
            builder.pop();
            builder.comment("Targeting").push("targeting");
            this.playerPickupChance = this.createRangedIntValue(builder, 4, 0, 10, "playerPickupChance", ReloadType.NONE, "The chance for the Wither Storm to choose a player", "instead of another entity, out of 10");
            this.headEscapeTime = this.createRangedIntValue(builder, 40, 0, 60, "headEscapeTime", ReloadType.NONE, "The targeting invulnerability time in seconds", "players who escape from a Wither Storm after", "injuring a head get");
            this.tractorPullSpeedModifier = this.createRangedDoubleValue(builder, 0.2, 0.1, 1.0, "tractorPullSpeedModifier", ReloadType.NONE, "Modifies the tractor beam pull speed, higher = faster");
            builder.pop();
            builder.comment("Evolution").push("evolution");
            this.evolutionAttributeModifier = this.createRangedDoubleValue(builder, 1.0, 0.01, 32.0, "evolutionAttributeModifier", ReloadType.NONE, "Specifies a modifier value of the evolution rate attribute.", "The higher the value, the longer it takes for", "the Wither Storm to make a complete evolution", "(from phases 0 to 7), and vice versa.", "Cannot be lower than 0");
            this.addAttributeConfigValue((Supplier<Attribute>)WitherStormModAttributes.EVOLUTION_SPEED, EVOLUTION_MODIFIER_UUID, "Config defined evolution modifier", AttributeModifier.Operation.ADDITION, this.evolutionAttributeModifier);
            builder.pop();
            builder.comment("Performance").push("performance");
            this.clustersRemoveItems = this.createValue(builder, true, "clustersRemoveItems", ReloadType.NONE, "Specifies if Block Clusters should remove non-important", "items in its path. NOTE: Disabling can cause major lag");
            this.squashHitbox = this.createValue(builder, false, "squashHitbox", ReloadType.WORLD, "If true, the hitbox of the Wither Storm", "and Wither Storm Segment's will be shrunk", "vertically to one block. Enable if facing major server lag in", "the bigger Wither Storm phases");
            this.chunksToLoad = this.createRangedIntValue(builder, 576, 9, 576, "chunksToLoad", ReloadType.WORLD, "Specifies the maximum amount of chunks", "the Wither Storm should load around itself");
            this.removeNearbyKelp = this.createValue(builder, true, "removeNearbyKelp", ReloadType.NONE, "Specifies if kelp items near the Wither Storm should be immediately destroyed. NOTE: Disabling will cause massive server side lag!");
            this.mobsRunIntoPortals = this.createValue(builder, false, "mobsRunIntoPortals", ReloadType.NONE, "Specifies if mobs should go into nearby nether portals when running away from a Wither Storm. NOTE: Can cause severe server side lag");
            builder.pop();
            builder.comment("World Consumption").push("world_consumption");
            this.hunchbackClusterPickupInterval = this.createRangedIntValue(builder, 20, 10, 80, "hunchbackClusterPickupInterval", ReloadType.NONE, "Alters the interval (in ticks) of picking up block clusters", "for the hunchback phases (phase 0 - 3). NOTE: This value", "changes the evolution speed of the Wither Storm significantly");
            this.clusterPickupInterval = this.createRangedIntValue(builder, 40, 10, 80, "clusterPickupInterval", ReloadType.NONE, "Alters the interval (in ticks) of picking up block clusters", "for the destroyer phases (phase 4 - 5). NOTE: This value", "changes the evolution speed of the Wither Storm significantly");
            this.devourerClusterPickupInterval = this.createRangedIntValue(builder, 40, 10, 80, "devourerClusterPickupInterval", ReloadType.NONE, "Alters the interval (in ticks) of picking up block clusters", "for the devourer phases (phase 6+). NOTE: This value", "changes the evolution speed of the Wither Storm significantly");
            this.canPickupMobClusters = this.createValue(builder, true, "canPickupMobClusters", ReloadType.NONE, "Specifies if the Wither Storm's tractor beams", "can pull in multiple mobs at once that interesect", "the beam");
            this.clusterSizeModifier = this.createRangedIntValue(builder, 0, 0, 16, "clusterSizeModifier", ReloadType.NONE, "Increases the radius of block clusters linearly by this amount. NOTE: Greatly impacts the Wither Storm's evolution rate. Greater values also lead to worse performance!");
            builder.pop();
            builder.comment("Caves").push("caves");
            this.caveRumbles = this.createValue(builder, true, "caveRumbles", ReloadType.NONE, "Specifies if the screen should shake and other various cave rumble effects should occur when underground and near the Storm");
            this.occludeSoundsUnderground = this.createValue(builder, true, "occludeSoundsUnderground", ReloadType.NONE, "Specifies if sounds from the Wither Storm should be heard when deep underground");
            builder.pop();
            builder.comment("Wither sickness").push("wither_sickness");
            this.witherSicknessEnabled = this.createValue(builder, true, "witherSicknessEnabled", ReloadType.WORLD, "Specifies if mobs should be able to receive", "wither sickness");
            this.sickenedMobConversions = this.createValue(builder, true, "sickenedMobConversions", ReloadType.NONE, "Specifies if mobs should convert to sickened mobs", "once they die from wither sickness");
            this.increaseAmplifier = this.createValue(builder, true, "increaseAmplifier", ReloadType.NONE, "Specifies if entities who are reinfected over a short", "period of time should receive wither sickness with a greater strength");
            this.requiredContacts = this.createRangedIntValue(builder, 6, 1, 40, "requiredContacts", ReloadType.WORLD, "After a mob has been targetted by the Wither Storm", "a set maximum of times, the mob will become infected");
            this.requiredProximitySeconds = this.createRangedIntValue(builder, 600, 12, 1200, "requiredProximitySeconds", ReloadType.WORLD, "Specifies the amount of time in seconds high immunity mobs", "(players) must be near the Wither Storm in order to", "to begin infection");
            this.applicationDelay = this.createRangedIntValue(builder, 720, 12, 1200, "applicationDelay", ReloadType.WORLD, "Specifies the amount of time in seconds high immunity mobs", "(players) must be infected in order to", "be applied the wither sickness effect");
            this.cureDelay = this.createRangedIntValue(builder, 480, 12, 1200, "cureDelay", ReloadType.WORLD, "Specifies the delay, in seconds, before high immunity mobs", "(players) are cured of wither sickness");
            this.lowImmuneRequiredProximitySeconds = this.createRangedIntValue(builder, 360, 12, 1200, "lowImmuneRequiredProximitySeconds", ReloadType.WORLD, "Specifies the amount of time in seconds that low immunity mobs", "must be near the Wither Storm in order to begin infection");
            this.lowImmuneApplicationDelay = this.createRangedIntValue(builder, 410, 12, 1200, "lowImmuneApplicationDelay", ReloadType.WORLD, "Specifies the amount of time in seconds low immunity mobs", "must be infected in order to be applied the", "wither sickness effect");
            this.lowImmuneCureDelay = this.createRangedIntValue(builder, 480, 12, 1200, "lowImmuneCureDelay", ReloadType.WORLD, "Specifies the delay, in seconds, before low immunity mobs", "are cured of wither sickness");
            this.proximitySecondsModifierMax = this.createRangedIntValue(builder, 180, 12, 1200, "proximitySecondsModifierMax", ReloadType.NONE, "High immunity mobs (players) will be assigned a random proximity", "seconds modifier that will change the proximity seconds time.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.applicationDelayModifierMax = this.createRangedIntValue(builder, 300, 12, 1200, "applicationDelayModifierMax", ReloadType.NONE, "High immunity mobs (players) will be assigned a random application", "delay modifier that will change the application delay.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.cureDelayModifierMax = this.createRangedIntValue(builder, 180, 12, 1200, "cureDelayModifierMax", ReloadType.NONE, "High immunity mobs (players) will be assigned a random cure", "delay modifier that will change the cure delay.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.lowImmuneProximityModifierMax = this.createRangedIntValue(builder, 180, 12, 1200, "lowImmuneProximityModifierMax", ReloadType.NONE, "Low immunity mobs will be assigned a random proximity seconds", "delay modifier that will change the proximity seconds time.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.lowImmuneApplicationModifierMax = this.createRangedIntValue(builder, 140, 12, 1200, "lowImmuneApplicationModifierMax", ReloadType.NONE, "Low immunity mobs will be assigned a random application", "delay modifier that will change the proximity seconds time.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.lowImmuneCureDelayModifierMax = this.createRangedIntValue(builder, 180, 12, 1200, "lowImmuneCureDelayModifierMax", ReloadType.NONE, "Low immunity mobs will be assigned a random cure", "delay modifier that will change the cure delay time.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.keepSicknessAfterRespawn = this.createValue(builder, true, "keepSicknessAfterRespawn", ReloadType.NONE, "Specifies if Wither Sickness should be", "removed after a player respawns");
            builder.pop();
            builder.comment("Formidibomb").push("formidibomb");
            this.craftFuseTicks = this.createRangedIntValue(builder, 12000, 1, 12000, "craftFuseTicks", ReloadType.NONE, "Specifies the fuse in ticks that count down", "to the formidibomb's explosion.", "The fuse is set when the block is crafted");
            this.catchFireFuseTicks = this.createRangedIntValue(builder, 1200, 1, 12000, "catchFireFuseTicks", ReloadType.NONE, "If the formidibomb is manually set on fire", "the fuse tick count will be set to this", "value, if the original fuse is greater than", "this value");
            this.shouldDropFromInventory = this.createValue(builder, true, "shouldDropFromInventory", ReloadType.NONE, "Specifies if after a set amount of time", "the formidibomb item should drop out of", "whatever inventory is holding it", "and should spawn as the entity");
            this.dropInterval = this.createRangedIntValue(builder, 4, 1, 8, "dropInterval", ReloadType.NONE, "Specifies the interval for when the", "formidibomb will drop out of its inventory", "(if enabled). This value divides the crafted fuse ticks", "to get the interval (e.x. 12000 / 4 = 3000)");
            this.lowerBlockResistance = this.createValue(builder, true, "lowerBlockResistance", ReloadType.NONE, "Lowers the resistance of blocks in", "the path of the explosion, effectively", "increasing the strength of the explosion", "which allows for obsidian, etc. to be destroyed");
            builder.pop();
            builder.comment("Playing dead").push("playing_dead");
            this.revivalTimer = this.createValue(builder, true, "revivalTimer", ReloadType.NONE, "Specifies if the Wither Storm should", "automatically revive if not found", "after a period of time");
            this.revivalTimeMinutes = this.createRangedIntValue(builder, 60, 1, 120, "revivalTimeMinutes", ReloadType.NONE, "Specifies when (in minutes) the Wither Storm", "will automatically revive when playing dead");
            this.revivalPlayerProtection = this.createRangedIntValue(builder, 3, 1, 40, "revivalPlayerProtection", ReloadType.NONE, "Specifies the time (in minutes) after being", "revived that the Wither Storm should ignore", "players");
            builder.pop();
            builder.comment("Withered Symbiont").push("withered_symbiont");
            this.canSummonSymbiont = this.createValue(builder, true, "canSummonSymbiont", ReloadType.NONE, "Specifies if the Wither Storm can summon", "the Withered Symbiont");
            this.minimumSpawnCheckInterval = this.createRangedIntValue(builder, 60, 1, 240, "minimumSpawnCheckInterval", ReloadType.NONE, "Specifies the minimum interval (+random) in seconds", "that the Wither Storm should check for", "Withered Symbiont spawn conditions");
            this.witherStormSummoningDelay = this.createRangedIntValue(builder, 10, 1, 20, "witherStormSummoningDelay", ReloadType.NONE, "Specifies the delay in minutes (+random) that the", "Wither Storm will be able to summon a", "Withered Symbiont");
            this.playerInvulnerableTime = this.createRangedIntValue(builder, 5, 1, 10, "playerInvulnerableTime", ReloadType.NONE, "Specifies the time in minutes (+random) that the", "players who killed a Withered Symbiont", "should be ignored by the Wither Storm for");
            this.playerSummoningDelay = this.createRangedIntValue(builder, 10, 1, 60, "playerSummoningDelay", ReloadType.NONE, "Specifies the delay in minutes (+random) that the", "Wither Storm should be able summon a", "Withered Symbiont for the player it summoned one for");
            this.playerSummoningDelayOnKill = this.createRangedIntValue(builder, 40, 1, 60, "playerSummoningDelayOnKill", ReloadType.NONE, "If a player kills a Withered Symbiont, their", "sumoning delay will be increased to this value", "in minutes (+random)");
            this.attackableWhenNotVulnerable = this.createValue(builder, false, "attackableWhenNotVulnerable", ReloadType.NONE, "Specifies if the symbiont can be attacked from behind if it's not vulnerable");
            this.bookDropsInInventory = this.createValue(builder, true, "bookDropsInInventory", ReloadType.NONE, "If multiple players are near the Withered Symbiont, the command block book will automatically drop into the inventory of the player the Symbiont was spawned for, if they are nearby and have inventory space");
            this.healthScalePerPlayer = this.createRangedDoubleValue(builder, 20.0, 0.0, 100.0, "healthScalePerPlayer", ReloadType.NONE, "Adds this value multiplied by the amount of nearby players to the Symbiont's max health when it is spawned. Set to zero to disable this feature");
            builder.pop();
            builder.comment("Flaming Skulls").push("flaming_skulls");
            this.flamingSkullExplosionSize = this.createRangedDoubleValue(builder, 5.0, 1.0, 16.0, "flamingSkullExplosionSize", ReloadType.NONE, "The flaming skull explosion size when they collide with blocks");
            this.flamingSkullSpeedModifier = this.createRangedDoubleValue(builder, 1.0, 0.5, 8.0, "flamingSkullSpeedModifier", ReloadType.NONE, "The speed modifier for flaming wither skulls. Higher = faster");
            builder.pop();
            builder.comment("Roaring").push("roaring");
            this.minimumRoarInterval = this.createRangedIntValue(builder, 20, 1, 100, "minimumRoarInterval", ReloadType.NONE, "Specifies the lowest time, in seconds, it will take for one of the Wither Storm's heads to initiate a roar and shoot a flaming skull");
            this.maximumRoarInterval = this.createRangedIntValue(builder, 50, 1, 100, "maximumRoarInterval", ReloadType.NONE, "Specifies the greatest time, in seconds, it will take for one of the Wither Storm's heads to initiate a roar and shoot a flaming skull");
            builder.pop();
            this.flyingDisabledWarning = this.createValue(builder, true, "flyingEnabledWarning", ReloadType.NONE, "Specifies if a warning should be printed out to server operators if flying is disabled");
            ConfigPreset defaultPreset = ConfigPreset.Builder.of(this).build(Component.m_237115_((String)"config.witherstormmod.preset.default.title"), new ResourceLocation("witherstormmod", "default_server")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.default.description"));
            ConfigPreset performance = ConfigPreset.Builder.of(this).setConfigPreset(this.squashHitbox, true).build(Component.m_237115_((String)"config.witherstormmod.preset.server.performance.title"), new ResourceLocation("witherstormmod", "performance")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.server.performance.description"));
            ConfigPreset massDestruction = ConfigPreset.Builder.of(this).setConfigPreset(this.hunchbackClusterPickupInterval, 10).setConfigPreset(this.clusterPickupInterval, 10).setConfigPreset(this.devourerClusterPickupInterval, 10).setConfigPreset(this.flamingSkullExplosionSize, 12.0).setConfigPreset(this.flamingSkullSpeedModifier, 4.0).build(Component.m_237115_((String)"config.witherstormmod.preset.server.mass_destruction.title"), new ResourceLocation("witherstormmod", "mass_destruction")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.server.mass_destruction.description"));
            this.putPresets(defaultPreset, performance, massDestruction);
            this.excludeFromGui(this.flyingDisabledWarning);
            builder.pop();
        }
    }
}

