/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import nonamecrackers2.witherstormmod.common.config.ReloadType;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.config.preset.ConfigPreset;
import nonamecrackers2.witherstormmod.common.util.AttributeModifierSnapshot;
import org.apache.commons.lang3.StringUtils;

public class ConfigHolder {
    protected final Map<ForgeConfigSpec.ConfigValue<?>, ReloadType> values = Maps.newHashMap();
    protected final List<AttributeModifierSnapshot> attributeModifiers = Lists.newArrayList();
    protected final List<ConfigPreset> presets = Lists.newArrayList();
    protected final List<ForgeConfigSpec.ConfigValue<?>> presetExcluded = Lists.newArrayList();
    protected final List<ForgeConfigSpec.ConfigValue<?>> guiHidden = Lists.newArrayList();
    public final ConfigPreset custom = ConfigPreset.Builder.empty().build(Component.m_237115_((String)"config.witherstormmod.preset.custom.title"), new ResourceLocation("witherstormmod", "custom")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.custom.description"));
    private final ModConfig.Type type;

    protected ConfigHolder(ModConfig.Type type) {
        this.putPresets(this.custom);
        this.type = type;
    }

    public List<ForgeConfigSpec.ConfigValue<?>> getValues() {
        return ImmutableList.copyOf(this.values.keySet());
    }

    protected <T> ForgeConfigSpec.ConfigValue<T> addConfigValue(ForgeConfigSpec.ConfigValue<T> value, ReloadType type) {
        if (this.values.containsKey(value)) {
            throw new IllegalArgumentException("Duplicate config value: " + value);
        }
        this.values.put(value, type);
        return value;
    }

    protected void putPresets(ConfigPreset ... presets) {
        for (int i = 0; i < presets.length; ++i) {
            this.presets.add(presets[i]);
        }
    }

    public List<ConfigPreset> getPresets() {
        return Lists.newArrayList(this.presets);
    }

    protected void addAttributeConfigValue(Supplier<Attribute> attribute, String id, String description, AttributeModifier.Operation operation, ForgeConfigSpec.ConfigValue<Double> value) {
        AttributeModifierSnapshot snapshot = new AttributeModifierSnapshot(attribute, UUID.fromString(id), description, value, operation);
        this.attributeModifiers.add(snapshot);
    }

    public ImmutableList<AttributeModifierSnapshot> getAttributeConfigs() {
        return ImmutableList.copyOf(this.attributeModifiers);
    }

    protected <T> ForgeConfigSpec.ConfigValue<T> createValue(ForgeConfigSpec.Builder builder, T value, String name, ReloadType type, String ... description) {
        String desc = StringUtils.join((Object[])description, (String)" ");
        return this.addConfigValue(builder.comment("DEFAULT=" + value + ". " + desc + ". " + type.toString()).translation("gui.witherstormmod.config." + name + ".description").define(name, value), type);
    }

    protected ForgeConfigSpec.ConfigValue<Double> createRangedDoubleValue(ForgeConfigSpec.Builder builder, double value, double min, double max, String name, ReloadType type, String ... description) {
        String desc = StringUtils.join((Object[])description, (String)" ");
        return this.addConfigValue((ForgeConfigSpec.ConfigValue)builder.comment("DEFAULT=" + value + ". " + desc + ". " + type.toString()).translation("gui.witherstormmod.config." + name + ".description").defineInRange(name, value, min, max), type);
    }

    protected ForgeConfigSpec.ConfigValue<Integer> createRangedIntValue(ForgeConfigSpec.Builder builder, int value, int min, int max, String name, ReloadType type, String ... description) {
        String desc = StringUtils.join((Object[])description, (String)" ");
        return this.addConfigValue((ForgeConfigSpec.ConfigValue)builder.comment("DEFAULT=" + value + ". " + desc + ". " + type.toString()).translation("gui.witherstormmod.config." + name + ".description").defineInRange(name, value, min, max), type);
    }

    protected <T extends Enum<T>> ForgeConfigSpec.ConfigValue<T> createEnumValue(ForgeConfigSpec.Builder builder, T value, String name, ReloadType type, String ... description) {
        String desc = StringUtils.join((Object[])description, (String)" ");
        return this.addConfigValue((ForgeConfigSpec.ConfigValue<T>)builder.comment("DEFAULT=" + value + ". " + desc + ". " + type.toString()).translation("gui.witherstormmod.config." + name + ".description").defineEnum(name, value), type);
    }

    protected ForgeConfigSpec.ConfigValue<Double> createAttributeValue(ForgeConfigSpec.Builder builder, Supplier<Attribute> attribute, String id, String modifierDesc, AttributeModifier.Operation operation, double value, String name, ReloadType type, String ... description) {
        ForgeConfigSpec.ConfigValue<Double> configValue = this.createValue(builder, value, name, type, description);
        this.addAttributeConfigValue(attribute, id, modifierDesc, operation, configValue);
        return configValue;
    }

    protected void excludeFromPresets(ForgeConfigSpec.ConfigValue<?> value) {
        if (!this.presetExcluded.contains(value)) {
            this.presetExcluded.add(value);
        }
    }

    public boolean shouldExclude(ForgeConfigSpec.ConfigValue<?> value) {
        return this.presetExcluded.contains(value);
    }

    protected void excludeFromGui(ForgeConfigSpec.ConfigValue<?> value) {
        if (!this.guiHidden.contains(value)) {
            this.guiHidden.add(value);
        }
    }

    public boolean shouldHideFromGui(ForgeConfigSpec.ConfigValue<?> value) {
        return this.guiHidden.contains(value);
    }

    public ModConfig.Type getType() {
        return this.type;
    }

    @Nullable
    public ReloadType reloadTypeFor(ForgeConfigSpec.ConfigValue<?> value) {
        return this.values.get(value);
    }

    public static String getName(ForgeConfigSpec.ConfigValue<?> value) {
        return StringUtils.join((Iterable)value.getPath(), (String)".");
    }

    public static ReloadType getReloadType(ForgeConfigSpec.ConfigValue<?> value) {
        for (ConfigHolder config : WitherStormModConfig.getAllConfigs().values()) {
            ReloadType type = config.reloadTypeFor(value);
            if (type == null) continue;
            return type;
        }
        throw new NullPointerException("Value '" + value + "' is not registered in any config!");
    }

    public static Class<?> getValuesClass(ForgeConfigSpec.ConfigValue<?> value) {
        return value.getDefault().getClass();
    }

    public static <T> boolean isValid(ForgeConfigSpec.ConfigValue<T> config, T val) {
        return ConfigHolder.getValueSpec(config).test(val);
    }

    @Nullable
    public static ForgeConfigSpec.ValueSpec getValueSpec(ForgeConfigSpec.ConfigValue<?> value) {
        for (ForgeConfigSpec spec : WitherStormModConfig.getAllSpecs()) {
            Object object = spec.getRaw(value.getPath());
            if (!(object instanceof ForgeConfigSpec.ValueSpec)) continue;
            ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)object;
            return valueSpec;
        }
        return null;
    }

    public static <T> void setToDefault(ForgeConfigSpec.ConfigValue<T> value) {
        value.set(value.getDefault());
    }
}

