/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import nonamecrackers2.witherstormmod.common.config.ConfigHolder;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigArgument<T>
implements ArgumentType<ForgeConfigSpec.ConfigValue<T>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Dynamic2CommandExceptionType INVALID_VALUE = new Dynamic2CommandExceptionType((o, o2) -> Component.m_237110_((String)"argument.witherstormmod.config.invalidValue", (Object[])new Object[]{o, o2}));
    private static final DynamicCommandExceptionType INAPPROPRIATE = new DynamicCommandExceptionType(o -> Component.m_237110_((String)"argument.witherstormmod.config.inappropriate", (Object[])new Object[]{o}));
    public final ConfigHolder config;
    @Nullable
    public final Class<T> type;

    private ConfigArgument(ConfigHolder config, @Nullable Class<T> type) {
        this.config = config;
        this.type = type;
    }

    public ForgeConfigSpec.ConfigValue<T> parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        for (ForgeConfigSpec.ConfigValue<?> value : this.config.getValues()) {
            if (!ConfigHolder.getName(value).equals(name)) continue;
            if (this.type != null) {
                Enum e;
                Object object = value.get();
                if (object instanceof Enum ? (e = (Enum)object).getDeclaringClass().isAssignableFrom(this.type) : value.get().getClass().isAssignableFrom(this.type)) {
                    ForgeConfigSpec.ConfigValue<?> cast = value;
                    return cast;
                }
                throw INAPPROPRIATE.create((Object)name);
            }
            ForgeConfigSpec.ConfigValue<?> cast = value;
            return cast;
        }
        throw INVALID_VALUE.create((Object)name, (Object)this.config.getType());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_((Iterable)this.config.getValues().stream().filter(val -> {
            if (this.type != null) {
                boolean bl;
                Object patt3308$temp = val.get();
                if (patt3308$temp instanceof Enum) {
                    Enum e = (Enum)patt3308$temp;
                    bl = e.getDeclaringClass().isAssignableFrom(this.type);
                } else {
                    bl = val.get().getClass().isAssignableFrom(this.type);
                }
                return bl;
            }
            return true;
        }).collect(Collectors.mapping(ConfigHolder::getName, Collectors.toList())), (SuggestionsBuilder)builder);
    }

    public static <T> ForgeConfigSpec.ConfigValue<T> get(CommandContext<CommandSourceStack> context, String argName) {
        return (ForgeConfigSpec.ConfigValue)context.getArgument(argName, ForgeConfigSpec.ConfigValue.class);
    }

    public static ConfigArgument<Boolean> booleanArg(ConfigHolder config) {
        return ConfigArgument.arg(config, Boolean.class);
    }

    public static ConfigArgument<Integer> integerArg(ConfigHolder config) {
        return ConfigArgument.arg(config, Integer.class);
    }

    public static ConfigArgument<Double> doubleArg(ConfigHolder config) {
        return ConfigArgument.arg(config, Double.class);
    }

    public static ConfigArgument<Object> any(ConfigHolder config) {
        return ConfigArgument.arg(config, null);
    }

    public static <T> ConfigArgument<T> arg(ConfigHolder config, Class<T> arg) {
        return new ConfigArgument<T>(config, arg);
    }

    public static class Serializer<T>
    implements ArgumentTypeInfo<ConfigArgument<T>, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)template.config.getType());
            buffer.writeBoolean(template.type != null);
            if (template.type != null) {
                buffer.m_130070_(template.type.getName());
            }
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            ModConfig.Type type = (ModConfig.Type)buffer.m_130066_(ModConfig.Type.class);
            ConfigHolder config = null;
            for (ConfigHolder conf : WitherStormModConfig.getAllConfigs().values()) {
                if (!conf.getType().equals((Object)type)) continue;
                config = conf;
            }
            if (config != null) {
                if (buffer.readBoolean()) {
                    try {
                        return new Template(config, Class.forName(buffer.m_130277_()));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                } else {
                    return new Template(config, null);
                }
            }
            LOGGER.error("Failed to create ConfigArgument from network");
            return null;
        }

        public void serializeToJson(Template template, JsonObject object) {
            object.addProperty("config", template.config.getType().toString());
            object.addProperty("type", template.type.getName());
        }

        public Template unpack(ConfigArgument<T> argument) {
            return new Template(argument.config, argument.type);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ConfigArgument<T>> {
            public final ConfigHolder config;
            @Nullable
            public final Class<T> type;

            private Template(@Nullable ConfigHolder config, Class<T> type) {
                this.config = config;
                this.type = type;
            }

            public ConfigArgument<T> instantiate(CommandBuildContext context) {
                return new ConfigArgument(this.config, this.type);
            }

            public ArgumentTypeInfo<ConfigArgument<T>, ?> m_213709_() {
                return Serializer.this;
            }
        }
    }
}

